/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.log;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import jline.console.ConsoleReader;
import net.md_5.bungee.log.ColouredWriter;
import net.md_5.bungee.log.ConciseFormatter;
import net.md_5.bungee.log.LogDispatcher;

public class BungeeLogger
extends Logger {
    private final Formatter formatter = new ConciseFormatter();
    private final LogDispatcher dispatcher = new LogDispatcher(this);

    @SuppressFBWarnings(value={"SC_START_IN_CTOR"})
    public BungeeLogger(String loggerName, String filePattern, ConsoleReader reader) {
        super(loggerName, null);
        this.setLevel(Level.ALL);
        try {
            FileHandler fileHandler = new FileHandler(filePattern, 0x800000, 8, false);
            fileHandler.setFormatter(this.formatter);
            this.addHandler(fileHandler);
            ColouredWriter consoleHandler = new ColouredWriter(reader);
            consoleHandler.setLevel(Level.INFO);
            consoleHandler.setFormatter(this.formatter);
            this.addHandler(consoleHandler);
        }
        catch (IOException ex) {
            System.err.println("Could not register logger!");
            ex.printStackTrace();
        }
        this.dispatcher.start();
    }

    @Override
    public void log(LogRecord record) {
        this.dispatcher.queue(record);
    }

    void doLog(LogRecord record) {
        super.log(record);
    }
}

