/*
 * Decompiled with CFR 0.152.
 */
package io.github.waterfallmc.waterfall.console;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.github.waterfallmc.waterfall.console.ConsoleCommandCompleter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import net.md_5.bungee.BungeeCord;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.ProxyServer;
import net.minecrell.terminalconsole.TerminalConsoleAppender;
import org.jline.reader.EndOfFileException;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.UserInterruptException;
import org.jline.terminal.Terminal;

public final class WaterfallConsole {
    private static final Executor executor = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("Console Command Thread #%d").build());

    public static void readCommands() throws IOException {
        Terminal terminal = TerminalConsoleAppender.getTerminal();
        if (terminal != null) {
            WaterfallConsole.readCommands(terminal);
        } else {
            WaterfallConsole.readCommands(System.in);
        }
    }

    private static void runCommand(String input) {
        String command = input.trim();
        if (command.isEmpty()) {
            return;
        }
        executor.execute(() -> {
            ProxyServer proxy = ProxyServer.getInstance();
            if (!proxy.getPluginManager().dispatchCommand(proxy.getConsole(), command)) {
                proxy.getConsole().sendMessage((Object)((Object)ChatColor.RED) + "Command not found");
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void readCommands(Terminal terminal) throws IOException {
        BungeeCord bungee = BungeeCord.getInstance();
        LineReader reader = LineReaderBuilder.builder().appName(ProxyServer.getInstance().getName()).terminal(terminal).completer(new ConsoleCommandCompleter(bungee)).build();
        reader.setOpt(LineReader.Option.DISABLE_EVENT_EXPANSION);
        reader.unsetOpt(LineReader.Option.INSERT_TAB);
        TerminalConsoleAppender.setReader(reader);
        try {
            while (bungee.isRunning) {
                String line;
                try {
                    line = reader.readLine("> ");
                }
                catch (EndOfFileException ignored) {
                    continue;
                }
                if (line == null) {
                    break;
                }
                WaterfallConsole.runCommand(line);
            }
        }
        catch (UserInterruptException e) {
            ProxyServer.getInstance().stop();
        }
        finally {
            TerminalConsoleAppender.setReader(null);
        }
    }

    private static void readCommands(InputStream in) throws IOException {
        BungeeCord bungee = BungeeCord.getInstance();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(in));){
            String line;
            while (bungee.isRunning && (line = reader.readLine()) != null) {
                WaterfallConsole.runCommand(line);
            }
        }
    }
}

