#if !defined HASH_LIB
#define HASH_LIB
	float hash1(inout float seed) {
		return fract(sin(seed += 0.1)*43758.5453123);
	}

	vec2 hash2(inout float seed) {
		return fract(sin(vec2(seed+=0.1,seed+=0.1))*vec2(43758.5453123,22578.1459123));
	}

	float hash1(vec2 p) {
		vec3 p3 = fract(vec3(p.xyx) * .1031);
		p3 += dot(p3, p3.yzx + 19.19);
		return fract((p3.x + p3.y) * p3.z);
	}

	vec2 hash2(vec2 p) {
		vec3 p3 = fract(p.xyx * vec3(443.897, 441.423, 437.195));
		p3 += dot(p3, p3.yzx + 19.19);
		return fract((p3.xx + p3.yz) * p3.zy);
	}

	vec2 hash2(vec3 p3) {
		p3 = fract(p3 * vec3(443.897, 441.423, 437.195));
		p3 += dot(p3, p3.yzx + 19.19);
		return fract((p3.xx + p3.yz) * p3.zy);
	}

	vec3 hash3(inout float seed) {
		return fract(sin(vec3(seed+=0.1,seed+=0.1,seed+=0.1))*vec3(43758.5453123,22578.1459123,19642.3490423));
	}
#endif