#if !defined POS_DEPTH_LIB
#define POS_DEPTH_LIB
    struct positionDepth {
        float depth0;
        float depth1;

        mat2x3 screenPosition;
        mat2x3 viewPosition;
        mat2x3 scenePosition;
        vec3 shadowViewPosition;
        vec3 shadowClipPosition;
    } pd;

    struct positionStruct {
        float depthTexture;

        vec3 screenPosition;
        vec3 viewPosition;
        vec3 scenePosition;
    };

    positionStruct getPositions(in vec2 coordinate, in sampler2D depth) {
        positionStruct pos;
        pos.depthTexture = texture(depth, textureCoordinate).r;

        pos.screenPosition = vec3(coordinate, pos.depthTexture);
        pos.viewPosition = screenSpaceToViewSpace(pos.screenPosition, gbufferProjectionInverse);
        pos.scenePosition = viewSpaceToSceneSpace(pos.viewPosition, gbufferModelViewInverse);

        return pos;
    }

    void fillPositionStruct() {

        positionStruct pos0 = getPositions(textureCoordinate, depthtex0);
        positionStruct pos1 = getPositions(textureCoordinate, depthtex1);

        pd.depth0 = pos0.depthTexture;
        pd.depth1 = pos1.depthTexture;

        pd.screenPosition[0] = pos0.screenPosition;
        pd.viewPosition[0] = pos0.viewPosition;
        pd.scenePosition[0] = pos0.scenePosition;

        pd.screenPosition[1] = pos1.screenPosition;
        pd.viewPosition[1] = pos1.viewPosition;
        pd.scenePosition[1] = pos1.scenePosition;


        pd.shadowViewPosition = sceneSpaceToShadowView(pd.scenePosition[0], shadowModelView);
        pd.shadowClipPosition = shadowViewToShadowClip(pd.shadowViewPosition, shadowProjection);
    }
#endif