#if !defined TRANSMITTANCE_LIB
#define TRANSMITTANCE_LIB
    vec3 atmosphereTransmittance(float coreDistance, float cosViewZenithAngle) {
        vec2 coord = atmosphereTransmittanceLookupUv(coreDistance, cosViewZenithAngle);
             coord = addUvMargin(coord, textureSize(depthtex2, 0));
        if(atmosphereRayIntersectsLowerLimit(coreDistance, cosViewZenithAngle)) {
            return vec3(0.0);
        }
        return texture(depthtex2, coord).rgb;
    }

    vec3 atmosphereTransmittance(vec3 position, vec3 direction) {
        float coreDistance = length(position);
        return atmosphereTransmittance(coreDistance, dot(position, direction) / coreDistance);
    }
#endif