#if !defined ATMOS_CONSTANTS
#define ATMOS_CONSTANTS
    const float planetRadius = 6371e3; //Radius of the planet surface in kilometers
    const float planetRadiusSquared = planetRadius * planetRadius;
    const float atmosphereLowerLimit = planetRadius + -10e3; //This should be -4e3, but this looks more like it should for some reason.
    const float atmosphereLowerLimitSquared = atmosphereLowerLimit * atmosphereLowerLimit;
    const float atmosphereHeight = 110e3; //Height of the atmosphere in kilometers
    const float atmosphereRadius = atmosphereHeight + planetRadius; //Radius of the atmosphere in kilometers
    const float atmosphereRadiusSquared = atmosphereRadius * atmosphereRadius;
    const float ozoneNumberDensity = 4e14;
    const float airNumberDensity = 2.4690778e25;
    const float mieScatteringAlbedo = 0.9; //Scattering albedo of aerosols.
    const float mieG = 0.70;

    const vec2 scaleHeights = vec2(8.5e3, 1.8e3);
    const vec2 inverseScaleHeights = 1.0f / scaleHeights;
    const vec2 scaledPlanetRadius = planetRadius * inverseScaleHeights;

    const float turbidity = 0.4;
    const float mieConst = 2.6650023e14;
    const float turb = (0.2 * turbidity) * 10E-19;
    const float mieCoefficient = 0.434 * turb * mieConst;

    const float depolarizationFactor = 0.035; //Depolarization factor of air.
    const float kingFactor = (6.0 + 3.0 * depolarizationFactor) / (6.0 - 7.0 * depolarizationFactor);

    const vec3 lambda = vec3(680.0, 550.0, 440.0);
    const vec3 lambdaNanometers = lambda * 1e-9;
    const vec3 lambdaMicrometers = lambda * 1e-6;
    const vec3 dispersion = 8.06e-5 + (2.481e-2 / (132.0 - pow(lambdaMicrometers, vec3(-2.0)))) + (1.74e-4 / (39.3 - pow(lambdaMicrometers, vec3(-2.0))));
    const vec3 n_Air = vec3(pow(1.00029, 2.0) - 1.0) + dispersion; //IOR of air.
    const vec3 rayleighScatteringCoefficient = ((8.0 * pow(pi, 3.0) * pow(n_Air, vec3(2.0))) / (3.0 * airNumberDensity * pow(lambdaNanometers, vec3(4.0)))) * kingFactor;
    const vec3 mieScatteringCoefficient = vec3(mieCoefficient); //Mie scattering coefficient.

    const vec3 mieExtinctionCoefficient = mieScatteringCoefficient / mieScatteringAlbedo; //Mie extinction coefficient.
    const vec3 ozoneExtinctionCoefficient = vec3(3.26033e-21, 3.21736e-21, 2.97488e-22) * ozoneNumberDensity; //Ozone extinction coefficient.

    const mat2x3 scatteringCoefficients = mat2x3(rayleighScatteringCoefficient, mieScatteringCoefficient); //Scattering coefficients.
    const mat3x3 extinctionCoefficients = mat3x3(rayleighScatteringCoefficient, mieExtinctionCoefficient, ozoneExtinctionCoefficient); //Extinction coefficients.


    const float atmosphere_MuS_min = -0.4;

    const int resR   = 32;
    const int resMu  = 128;
    const int resMuS = 32;
    const int resV   = 8;
#endif