//Vertex Inputs/Attributes
vec4 inPosition = gl_Vertex;
vec3 inNormal = gl_Normal;
vec4 inColor = gl_Color;
vec2 inTexCoord = gl_MultiTexCoord0.st;
vec2 inLmCoord = gl_MultiTexCoord1.st;

attribute vec4 mc_Entity;
attribute vec4 at_tangent;
attribute vec2 mc_midTexCoord;

//Uniforms
uniform mat4 gbufferModelViewInverse;

uniform vec3 cameraPosition;

//Vertex Outputs
out mat3 tbn;
out mat2 tileInfo;
out vec3 tint;
out vec3 worldPosition;
out vec3 viewPosition;
out vec3 tangentSpaceViewPosition;
flat out vec3 vertexNormal;
out vec2 textureCoordinate;
out vec2 lightmapCoordinate;
out float ao;
out float id;
out float top;

#include "/lib/universal/universal.glsl"

//Functions
vec4 projectVertex(vec3 position) {
	return vec4(gl_ProjectionMatrix[0].x, gl_ProjectionMatrix[1].y, gl_ProjectionMatrix[2].zw) * position.xyzz + gl_ProjectionMatrix[3] + vec4(gl_ProjectionMatrix[2].xy * position.z, 0.0, 0.0);
}

//Main function
void main() {
    tbn = mat3(
        fNormalize(gl_NormalMatrix * at_tangent.xyz), 
        fNormalize(gl_NormalMatrix * cross(at_tangent.xyz, inNormal.xyz) * sign(at_tangent.w)), 
        fNormalize(gl_NormalMatrix * inNormal.xyz)
    );

    tileInfo = mat2(
		abs(inTexCoord.xy - mc_midTexCoord.xy) * 2.,
		mc_midTexCoord.xy
	);

    tint = inColor.rgb;
    ao = inColor.a;

	worldPosition = (gbufferModelViewInverse * gl_ModelViewMatrix * inPosition).xyz + cameraPosition;
	viewPosition = (gl_ModelViewMatrix * inPosition).xyz;

    tangentSpaceViewPosition = viewPosition * tbn;

    vertexNormal = mat3(gbufferModelViewInverse) * (gl_NormalMatrix * inNormal);

    textureCoordinate = inTexCoord;
    lightmapCoordinate = inLmCoord / 255.0;
    lightmapCoordinate = square(lightmapCoordinate);

    id = mc_Entity.x;

    top = dot(fNormalize(vertexNormal), vec3(0.0, 1.0, 0.0));

    gl_Position.xyz = mat3(gl_ModelViewMatrix) * inPosition.xyz + gl_ModelViewMatrix[3].xyz;
    gl_Position = projectVertex(gl_Position.xyz);
    gl_Position.xy += taaOffset * gl_Position.w;
}