//Fragment Output
layout(location = 0) out vec4 outColor;
layout(location = 1) out uvec4 outData0;
layout(location = 2) out uvec4 outData1;

//Samplers
uniform sampler2D tex;
uniform sampler2D specular;

uniform sampler2D gaux4;

uniform sampler2D noisetex;

//Uniforms
uniform mat4 gbufferModelViewInverse, gbufferProjectionInverse;
uniform mat4 gbufferProjection;

//Fragment Inputs
in mat3 tbn;
in vec3 tint;
in vec3 worldPosition;
in vec3 viewPosition;
in vec3 metalTint;
in vec3 vertexNormal;
in vec2 textureCoordinate;
in vec2 lightmapCoordinate;
in float ao;
in float id;

#include "/lib/universal/universal.glsl"

#include "/lib/shared/surface/water/constants.glsl"
#include "/lib/shared/surface/water/waves.glsl"

vec3 waterParallax(vec3 position, vec3 viewDirection) {
    cInt numLayers = 8;
    float layerDepth = 1.0 / float(numLayers);
    float currentLayerDepth = 0.0;
    vec3 interval = inversesqrt(numLayers) * viewDirection / abs(viewDirection.y);

    vec3  currentPosition = vec3(0.0);
    float currentDepthMapValue = calculateWaves(position.xz) - .2;
    float previousDepthMapValue = 0.0;

    for(int i = 0; i < numLayers && currentLayerDepth > currentDepthMapValue; ++i) {
        previousDepthMapValue = currentDepthMapValue;
        currentPosition = (currentPosition.y - currentDepthMapValue) * interval + currentPosition;
        currentDepthMapValue = calculateWaves((currentPosition + position).xz) - .2; 
        currentLayerDepth -= layerDepth;
    }

    return vec3(1, 0, 1) * currentPosition + position;
}

/* DRAWBUFFERS:123 */
void main() {
    vec4 texSpecular = texture(specular, textureCoordinate);
    vec4 texColor = texture(tex, textureCoordinate);
    outColor.rgb = texColor.rgb * tint;
    outColor.a = texColor.a;

    vec3 normals = vertexNormal;
        if(abs(id - 8.0) < 0.6) {
            #ifndef USE_VERTEX_NORMAL
                vec3 position = worldPosition;
                if(MAX_WATER_SUBDIVISIONS < 2) {
                    position = waterParallax(position, fNormalize(viewPosition * tbn).xzy);
                }
                normals = tbn * waterNormal(position.xz).xzy;
                normals = mat3(gbufferModelViewInverse) * normals;
            #endif
        } else {
            normals = vertexNormal;
        }

    outData0.r = packUnorm4x8(vec4(texColor.rgb * tint, id / 255.0));
    outData0.g = packSnorm2x16(EncodeUnitVector(normals));
    outData0.b = packSnorm4x8(vec4(lightmapCoordinate, EncodeUnitVector(vertexNormal)));
    outData0.a = packSnorm4x8(vec4(1.0, ao, 0.0, 0.0));

    outData1.r = packUnorm2x16(texSpecular.rg);
    outData1.g = packUnorm2x16(texSpecular.ba);
    outData1.b = 1u;
    outData1.a = 1u;
}