//Vertex Inputs/Attributes
vec4 inPosition = gl_Vertex;
vec3 inNormal = gl_Normal;
vec4 inColor = gl_Color;
vec2 inTexCoord = gl_MultiTexCoord0.st;
vec2 inLmCoord = gl_MultiTexCoord1.st;

attribute vec4 mc_Entity;
attribute vec4 at_tangent;

//Uniforms
uniform mat4 gbufferModelViewInverse;

uniform vec3 cameraPosition;

//Vertex Outputs
out mat3 out_tbn;
out vec3 out_tint;
out vec3 out_worldPosition;
out vec3 out_viewPosition;
out vec3 out_vertexNormal;
out vec2 out_textureCoordinate;
out vec2 out_lightmapCoordinate;
out float out_ao;
out float out_id;

#include "/lib/universal/universal.glsl"

//Functions
vec4 projectVertex(vec3 position) {
	return vec4(gl_ProjectionMatrix[0].x, gl_ProjectionMatrix[1].y, gl_ProjectionMatrix[2].zw) * position.xyzz + gl_ProjectionMatrix[3] + vec4(gl_ProjectionMatrix[2].xy * position.z, 0.0, 0.0);
}

//Main function
void main() {
    out_tbn = mat3(
        fNormalize(gl_NormalMatrix * at_tangent.xyz), 
        fNormalize(gl_NormalMatrix * cross(at_tangent.xyz, inNormal.xyz) * sign(at_tangent.w)), 
        fNormalize(gl_NormalMatrix * inNormal.xyz)
    );

    out_tint = inColor.rgb;
    out_ao = inColor.a;

	out_worldPosition = (gbufferModelViewInverse * gl_ModelViewMatrix * inPosition).xyz + cameraPosition;
	out_viewPosition = (gl_ModelViewMatrix * inPosition).xyz;

    out_vertexNormal = gl_NormalMatrix * inNormal;

    out_textureCoordinate = inTexCoord;
    out_lightmapCoordinate = inLmCoord / 255.0;
    out_lightmapCoordinate = square(out_lightmapCoordinate);

    out_id = mc_Entity.x;

	gl_Position = inPosition;
}