//Fragment Output
layout(location = 0) out vec3 outColor;

#define FINAL

/*
    const int colortex0Format = RGBA32UI;
    const int colortex1Format = RGBA16F;
    const int colortex2Format = RGBA32UI;
    const int colortex3Format = RGBA32UI;
    const int colortex4Format = RGBA16F;
    const int colortex5Format = RGBA16F;
    const int colortex6Format = RGBA16F;
    const int colortex7Format = RGBA16F;
*/

//Samplers
uniform sampler2D colortex1;
uniform usampler2D colortex2;
uniform usampler2D colortex3;
uniform sampler2D colortex4;
uniform sampler2D colortex5;
uniform sampler2D colortex7;

uniform sampler2D depthtex1;

//Uniforms
uniform mat4 gbufferModelView, gbufferProjection;

uniform vec3 sunPosition;

uniform vec2 viewSize, viewPixelSize;

uniform float aspectRatio;

uniform int isEyeInWater;

//Fragment Inputs
in vec2 textureCoordinate;

#include "/lib/universal/universal.glsl"
#include "/lib/fragment/dither/bayer.glsl"
#include "/lib/fragment/colorspace.glsl"

#include "/lib/fragment/surfaceData.glsl"

#include "/lib/shared/surface/water/constants.glsl"

#include "/lib/shared/sky/celestial/constants.glsl"

//#include "/lib/fragment/rrt/misc.glsl"
//#include "/lib/fragment/rrt/rrt.glsl"

vec3 vibrance(in vec3 color) {
    float lum = dot(color, lumacoeff_rec709);
    vec3 mask = (color - vec3(lum));
    mask = clamp(mask, 0.0, 1.0);
    float lum_mask = dot(lumacoeff_rec709, mask);
    lum_mask = 1.0 - lum_mask;
    return mix(vec3(lum), color, (1.0 + 0.2) * lum_mask);
}

vec3 tonemapHejlBurgess(in vec3 color) {
	//color = max(vec3(0.0), color - 0.0008);
	color = (color * (6.2 * color + 0.5)) / (color * (6.2 * color + 1.7) + 0.06);

	return color;
}

vec3 purkinjeEffect(in vec3 color) {
    cVec3 rodResponse = vec3(7.15e-5, 4.81e-1, 3.28e-1);
    vec3 xyz = rgbToXYZ(color);

    vec3 scotopicLuminance = xyz * (1.33*(1.0+(xyz.y+xyz.z)/xyz.x)-1.68);

    float purkinje = dot(rodResponse, xyzToRGB(scotopicLuminance));

    color = mix(color, purkinje * vec3(0.5, 0.7, 1.0), exp2(-purkinje * 2.0));

    return max(color, 0.0);
}

void applyBloom(inout vec3 color) {
    vec2 px = viewPixelSize;
	vec3 bloom  = textureBicubic(colortex5, (textureCoordinate / exp2(1)) + vec2(0.00000      , 0.00000            )).rgb * 0.475;
	     bloom += textureBicubic(colortex5, (textureCoordinate / exp2(2)) + vec2(0.00000           , 0.50000 + px.y * 19)).rgb * 0.625;
	     bloom += textureBicubic(colortex5, (textureCoordinate / exp2(3)) + vec2(0.25000 + px.x * 2, 0.50000 + px.y * 19)).rgb * 0.750;
	     bloom += textureBicubic(colortex5, (textureCoordinate / exp2(4)) + vec2(0.25000 + px.x * 2, 0.62500 + px.y * 37)).rgb * 0.850;
	     bloom += textureBicubic(colortex5, (textureCoordinate / exp2(5)) + vec2(0.31250 + px.x * 4, 0.62500 + px.y * 37)).rgb * 0.925;
	     bloom += textureBicubic(colortex5, (textureCoordinate / exp2(6)) + vec2(0.31250 + px.x * 4, 0.65625 + px.y * 55)).rgb * 0.975;
	     bloom += textureBicubic(colortex5, (textureCoordinate / exp2(7)) + vec2(0.46875 + px.x * 6, 0.65625 + px.y * 55)).rgb * 1.000;

    float exposure = texture(colortex4, textureCoordinate).a;
    bloom *= rcp(exposure);

    float a = square(0.1);
    if(isEyeInWater == 1) {
        a = square(0.4);
    }
    color = color + (bloom * a);
}

vec3 glare(float size) {
    vec3 sunScreenPosition = viewSpaceToScreenSpace(sunPosition, gbufferProjection);
    vec2 sunTextureCoordinate = sunScreenPosition.xy/sunScreenPosition.z;
    vec2 main = sunTextureCoordinate;
         main = (textureCoordinate-main) * vec2(aspectRatio, 1.0);

	float ang = atan(main.y, main.x);
	float dist = length(main); dist = pow(dist,.1);

	float f0 = 1.0/(length(main)*(16.0/size*64.0)+1.0);

    vec3 sunColor = texture(colortex1, sunTextureCoordinate).rgb * rcp(texture(colortex4, textureCoordinate).a);
         sunColor *= 0.03;

    return f0+f0*(sin((ang)*6.0)*.9+dist*.1+.9) * sunColor;
}

const mat3 coneOverlapMatrix2Deg = mat3(
    mix(vec3(1.0, 0.0, 0.0), vec3(0.5595088340965042, 0.39845359892109633, 0.04203756698239944), vec3(CONE_OVERLAP_SIMULATION)),
    mix(vec3(0.0, 1.0, 0.0), vec3(0.43585871315661756, 0.5003841413971261, 0.06375714544625634), vec3(CONE_OVERLAP_SIMULATION)),
    mix(vec3(0.0, 0.0, 1.0), vec3(0.10997368482498855, 0.15247972169325025, 0.7375465934817612), vec3(CONE_OVERLAP_SIMULATION))
);

void main() {
    fillSurfaceStruct();

    vec3 texColor = texture(colortex1, textureCoordinate).rgb * rcp(texture(colortex4, textureCoordinate).a);
    outColor = texColor;
    //outColor += glare(0.01);
    applyBloom(outColor);
	outColor = purkinjeEffect(outColor);
	outColor = outColor * texture(colortex4, textureCoordinate).a;
    outColor = tonemapHejlBurgess(outColor * coneOverlapMatrix2Deg) * inverse(coneOverlapMatrix2Deg);
    outColor = vibrance(outColor);

    outColor += bayer128(gl_FragCoord.st) / 128.0;

    #ifdef DISPLAY_WAVE_TEXTURE
        float waveHeightR = texture(colortex7, textureCoordinate).x;
        float waveHeightI = texture(colortex7, textureCoordinate).y;

        vec2 uv = gl_FragCoord.st - vec2(0.0, SIZE);

        if (gl_FragCoord.x < SIZE && gl_FragCoord.y < SIZE) {
            outColor = 0.5 + 0.5 * vec3(waveHeightR, waveHeightI, 0.0);
        } else if (uv.x < SIZE && uv.y < SIZE) {
            outColor = 0.5 + 0.5 * vec3(texture(colortex7, uv/viewSize).zw, 0.0) / (A/SIDELENGTH);
        }
    #endif

    //outColor = vec3(dot(vec3(0.0, 0.2, 1.0), sd.normals));
}