//Fragment Output
layout(location = 0) out vec3 outColor;
layout(location = 1) out vec4 outTemporal;

//Samplers
uniform usampler2D colortex0;
uniform sampler2D colortex4;
uniform sampler2D colortex5;

uniform sampler2D depthtex1;

//Uniforms
uniform mat4 gbufferProjection;
uniform mat4 gbufferModelViewInverse, gbufferProjectionInverse;
uniform mat4 gbufferPreviousProjection, gbufferPreviousModelView;

uniform vec3 cameraPosition, previousCameraPosition;

uniform vec2 viewSize, viewPixelSize;

uniform float frameTime;
uniform float nightVision;

//Fragment Inputs
in vec2 textureCoordinate;

const bool colortex5MipmapEnabled = true;

#include "/lib/universal/universal.glsl"

float computeTargetEV(float averageLuminance) {
    const float K = 12.5f;
    return log2(averageLuminance * 100.0f / K);
}

float EV100ToExposure(float EV100) {
    float maxLuminance = 1.2 * pow(2.0, EV100);

    return maxLuminance;
}

const float minExposure = 5.0e-6;
const float maxExposure = 6.0e-3;

float cameraExposure() {
    float exposure = 1.0;

    vec3 avgSamples = square(textureLod(colortex5, vec2(0.5), log2(max(viewSize.x, viewSize.y))).rgb);

    float sensitivity = mix(6.0 / 0.1, 64.0 / 0.03, nightVision);

    float avgBrightness = 1.0 * rcp(dot(avgSamples, vec3(sensitivity)));

    float targetEV = computeTargetEV(clamp(avgBrightness, minExposure, maxExposure));

    exposure = EV100ToExposure(targetEV);

    float exposureTime = frameTime * rcp(mix(4.0, 0.1, float(exposure < texture(colortex4, vec2(0.0) + viewPixelSize * 0.5).a)) + frameTime * rcp(3.0));
    exposure = mix(texture(colortex4, vec2(0.0) + viewPixelSize * 0.5).a, exposure, exposureTime);

    return max(exposure, 0.0);
}

vec4 temporalAntiAliasing();

/* DRAWBUFFERS:14 */
void main() {
    vec4 encodedColor = vec4(unpackUnorm2x16(texture(colortex0, textureCoordinate).r), unpackUnorm2x16(texture(colortex0, textureCoordinate).g));

    outColor = decodeRGBE8(encodedColor) * cameraExposure();

    outTemporal.rgb = texture(colortex4, textureCoordinate).rgb;
    outTemporal.a = cameraExposure();
}