#extension GL_ARB_gpu_shader_int64 : enable
#extension AMD_gpu_shader_int64 : enable

//Fragment Output
layout(location = 0) out vec3 outColor;

//Samplers
uniform sampler2D colortex1;
uniform sampler2D colortex4;

uniform sampler2D depthtex1;

//Uniforms
uniform mat4 gbufferProjection;
uniform mat4 gbufferModelViewInverse, gbufferProjectionInverse;
uniform mat4 gbufferPreviousProjection, gbufferPreviousModelView;

uniform vec3 cameraPosition, previousCameraPosition;

uniform vec2 viewSize, viewPixelSize;

uniform float frameTime;
uniform float nightVision;

uniform int frameCounter;

//Fragment Inputs
in vec2 textureCoordinate;

const bool colortex1MipmapEnabled = true;

#include "/lib/universal/universal.glsl"
#include "/lib/fragment/dither/randNext.glsl"

/* DRAWBUFFERS:1 */
void main() {
    vec2 coord = mod(gl_FragCoord.xy, 512);
	uint s = uint(coord.x * viewSize.y + coord.y);
	     s = s * 720720u + uint(frameCounter);
	init_msws(s);

    outColor = texture(colortex4, textureCoordinate).rgb;

    vec3 nightVisionColor = dot(outColor, lumacoeff_rec709) * square(vec3(0.5, 0.9, 0.7)) * 50.0;
         nightVisionColor = mix(nightVisionColor, vec3(0.02), randNextF());

    outColor = mix(outColor, nightVisionColor, nightVision);
}