layout(location = 0) out vec3 bloom;

//Samplers
uniform sampler2D colortex1;

//Uniforms
uniform vec2 viewSize, viewPixelSize;

//Fragment Inputs
in vec2 textureCoordinate;

const bool colortex1MipmapEnabled = true;

#include "/lib/universal/universal.glsl"

const float[5] weights = float[5](0.19947114, 0.29701803, 0.09175428, 0.01098007, 0.00050326);
const float[5] offsets = float[5](0.00000000, 1.40733340, 3.29421497, 5.20181322, 7.13296424);

vec3 calculateBloom(in sampler2D sampler, in vec2 coord, in int lod) {
    if(any(greaterThan(abs(coord - 0.5), vec2(0.5)))) return vec3(0.0);

	vec2 resolution = textureSize(sampler, lod);

	vec3 bloom = textureLod(sampler, coord, lod).rgb * weights[0];

	for (int i = 1; i < 5; i++) {
		vec2 offset = offsets[i] * vec2(1.0, 0.0) / resolution;
		bloom += textureLod(sampler, coord + offset, lod).rgb * weights[i];
		bloom += textureLod(sampler, coord - offset, lod).rgb * weights[i];
	}

	return bloom;
}

/* DRAWBUFFERS:5 */
void main() {
    vec2 px = viewPixelSize;
	bloom  = calculateBloom(colortex1, (textureCoordinate - vec2(0.000000           , 0.00000            )) * exp2(1), 1);
	bloom += calculateBloom(colortex1, (textureCoordinate - vec2(0.000000           , 0.50000 + px.y * 19)) * exp2(2), 2);
	bloom += calculateBloom(colortex1, (textureCoordinate - vec2(0.250000 + px.x * 2, 0.50000 + px.y * 19)) * exp2(3), 3);
	bloom += calculateBloom(colortex1, (textureCoordinate - vec2(0.250000 + px.x * 2, 0.62500 + px.y * 37)) * exp2(4), 4);
	bloom += calculateBloom(colortex1, (textureCoordinate - vec2(0.312500 + px.x * 4, 0.62500 + px.y * 37)) * exp2(5), 5);
	bloom += calculateBloom(colortex1, (textureCoordinate - vec2(0.312500 + px.x * 4, 0.65625 + px.y * 55)) * exp2(6), 6);
	bloom += calculateBloom(colortex1, (textureCoordinate - vec2(0.328125 + px.x * 6, 0.65625 + px.y * 55)) * exp2(7), 7);
}