layout(location = 0) out vec3 bloom;

//Samplers
uniform sampler2D colortex5;

//Uniforms
uniform vec2 viewSize, viewPixelSize;

//Fragment Inputs
in vec2 textureCoordinate;

#include "/lib/universal/universal.glsl"

const float[5] weights = float[5](0.19947114, 0.29701803, 0.09175428, 0.01098007, 0.00050326);
const float[5] offsets = float[5](0.00000000, 1.40733340, 3.29421497, 5.20181322, 7.13296424);

/* DRAWBUFFERS:5 */
void main() {
	bloom = texture(colortex5, textureCoordinate).rgb * weights[0];

	for (int i = 1; i < 5; i++) {
		vec2 offset = offsets[i] * vec2(0.0, 1.0 / viewSize.y);
		bloom += texture(colortex5, textureCoordinate + offset).rgb * weights[i];
		bloom += texture(colortex5, textureCoordinate - offset).rgb * weights[i];
	}
}