#extension GL_ARB_gpu_shader_int64 : enable
#extension AMD_gpu_shader_int64 : enable

//Fragment Output
layout(location = 0) out uvec3 outColor;
layout(location = 1) out vec4 outC1;

//Samplers
uniform usampler2D colortex2;
uniform usampler2D colortex3;
uniform sampler2D colortex6;
uniform sampler2D colortex5;
uniform sampler2D depthtex0;

uniform sampler2D gaux4;

uniform sampler2D noisetex;

uniform sampler2D shadowtex0;
uniform sampler2D shadowtex1;
uniform sampler2D shadowcolor0;
uniform sampler2D shadowcolor1;

//Sky Textures
uniform sampler2D depthtex1;
uniform sampler2D depthtex2;

//Uniforms
uniform mat4 gbufferProjection, gbufferModelView;
uniform mat4 gbufferProjectionInverse, gbufferModelViewInverse;

uniform mat4 shadowProjection, shadowModelView;
uniform mat4 shadowProjectionInverse, shadowModelViewInverse;

uniform vec3 sunVector, moonVector, shadowLightVector, upVector;
uniform vec3 sunVectorView, moonVectorView, shadowLightVectorView;
uniform vec3 cameraPosition;

uniform vec2 viewSize, viewPixelSize;

uniform ivec2 eyeBrightness;

uniform float eyeAltitude, frameTimeCounter;

uniform int frameCounter, isEyeInWater;

//Fragment Inputs
struct lightStruct {
    vec3 indirect;
    vec3 direct;

    vec3 skySh[9];
};

in lightStruct lc;
in vec2 textureCoordinate;

#include "/lib/universal/universal.glsl"
#include "/lib/fragment/dither/bayer.glsl"
#include "/lib/fragment/dither/hash.glsl"
#include "/lib/fragment/dither/hammersley.glsl"
#include "/lib/fragment/dither/randNext.glsl"
#include "/lib/fragment/colorspace.glsl"

#include "/lib/fragment/positionDepth.glsl"
#include "/lib/fragment/surfaceData.glsl"

#include "/lib/fragment/lighting/direct/distortion.glsl"
#include "/lib/fragment/lighting/direct/hard.glsl"
#include "/lib/fragment/lighting/direct/soft.glsl"

#include "/lib/ray/rayShape.glsl"
#include "/lib/ray/raytracer.glsl"

#include "/lib/shared/sky/celestial/constants.glsl"

#include "/lib/shared/sky/constants.glsl"
#include "/lib/shared/sky/phase.glsl"
#include "/lib/shared/sky/atmosphere/lookup.glsl"
#include "/lib/shared/sky/atmosphere/scattering.glsl"
#include "/lib/shared/sky/atmosphere/transmittance.glsl"
#include "/lib/shared/sky/projection.glsl"

#include "/lib/shared/sky/clouds/volumetric/constants.glsl"
#include "/lib/shared/sky/clouds/volumetric/functions.glsl"
#include "/lib/shared/sky/clouds/volumetric/shadow.glsl"

#include "/lib/shared/surface/water/constants.glsl"
#include "/lib/shared/surface/water/waves.glsl"

#include "/lib/fragment/lighting/lighting.glsl"
#include "/lib/fragment/lighting/volumetric.glsl"

#include "/lib/shared/sky/celestial/celestialObjects.glsl"


/* DRAWBUFFERS:01 */
void main() {
    vec2 coord = mod(gl_FragCoord.xy, 512);
	uint s = uint(coord.x * viewSize.y + coord.y);
	     s = s * 720720u + uint(frameCounter);
	init_msws(s);

    waterCoefficients();

    fillSurfaceStruct();
    fillPositionStruct();

    vec3 sceneColor = vec3(0.0);
    if(landmask(pd.depth0)) {
        sceneColor = calculateLighting();
    } else {
        float cloudDistance = texture(colortex5, (textureCoordinate / 2.5) + 0.5).a;
        vec4 clouds = square(texture(colortex6, (textureCoordinate / 2.5) + 0.5));

        vec3 transmittanceView = atmosphereTransmittance(vec3(0.0, planetRadius, 0.0), fNormalize(pd.scenePosition[0]));
        vec3 transmittanceFromCloud = atmosphereTransmittance(vec3(0.0, planetRadius, 0.0) + fNormalize(pd.scenePosition[0]) * cloudDistance, fNormalize(pd.scenePosition[0]));
        vec3 transmittanceToCloud = min(transmittanceView / transmittanceFromCloud, 1.0);

        vec3 background = (physicalSun(fNormalize(pd.scenePosition[0])) + physicalMoon(fNormalize(pd.scenePosition[0]))) * transmittanceView;
        vec3 skyColor = atmosphericScattering(vec3(0.0, planetRadius, 0.0), fNormalize(pd.scenePosition[0]));

        sceneColor = (background + skyColor) * clouds.a;
        sceneColor = mix(skyColor, sceneColor + clouds.rgb, square(transmittanceToCloud));
    }

    //sceneColor = texture(colortex6, textureCoordinate).r * vec3(1.0);

    //sceneColor = calculateVolumetricLighting(sceneColor, pd.viewPosition[0], vec3(0.0));

    outColor.r = packUnorm2x16(encodeRGBE8(sceneColor).xy);
    outColor.g = packUnorm2x16(encodeRGBE8(sceneColor).zw);

    outC1 = vec4(1.0, 1.0, 1.0, 0.0);
}