//Vertex Inputs/Attributes
vec4 inPosition = gl_Vertex;

//Sky Textures
uniform sampler2D depthtex1;
uniform sampler2D depthtex2;
uniform sampler2D colortex5;

//Uniforms
uniform vec3 sunVector, moonVector, shadowLightVector, upVector;
uniform vec3 sunPosition, upPosition;

uniform vec2 viewSize, viewPixelSize;

//Vertex Outputs
struct lightStruct {
    vec3 indirect;
    vec3 direct;

    vec3 skySh[9];
};

out lightStruct lc;
out vec2 textureCoordinate;

#include "/lib/universal/universal.glsl"

#include "/lib/shared/sky/celestial/constants.glsl"

#include "/lib/shared/sky/constants.glsl"
#include "/lib/shared/sky/phase.glsl"
#include "/lib/shared/sky/atmosphere/lookup.glsl"
#include "/lib/shared/sky/atmosphere/scattering.glsl"
#include "/lib/shared/sky/atmosphere/transmittance.glsl"
#include "/lib/shared/sky/projection.glsl"

#include "/lib/shared/surface/sphericalHarmonics.glsl"

//Main function
void main() {
    {
        lc.direct = dot(sunPosition, upPosition) < 0.6 ? atmosphereTransmittance(vec3(0.0, planetRadius + 64.0, 0.0), moonVector) * moonIlluminance : atmosphereTransmittance(vec3(0.0, planetRadius + 64.0, 0.0), sunVector) * sunIlluminance;

        ivec2 samples = ivec2(16, 8);

        lc.indirect = vec3(0.0);
        for(int x = 0; x < samples.x; ++x) {
            for(int y = 0; y < samples.y; ++y) {
                vec3 dir = genUnitVector(vec2(x, y));
                
                lc.indirect += texture(colortex5, projectSky(dir)).rgb;
            }
        }

        lc.indirect *= rcp(samples.x + samples.y);
        //lc.indirect += lc.direct * (0.04/pi); //Light contribution from sun approximation.

        cInt shSamples = 128;

        for (int i = 0; i < 9; ++i) {
            lc.skySh[i] = vec3(0.0);
        }

        for(int i = 0; i < shSamples; ++i) {
            vec3 direction = genUnitVector(vec2((i + 0.5) / shSamples, fract(i * phi)));

            vec3 sky = texture(colortex5, projectSky(direction)).rgb;

            float[9] sh = SHCoeffs(direction);
            for(int j = 0; j < 9; ++j) {
                lc.skySh[j] += sh[j] * sky;
            }
        }

        float norm = 2.0 * pi / shSamples;
        for (int i = 0; i < 9; ++i) {
            lc.skySh[i] *= norm;
        }
    }
    textureCoordinate = inPosition.xy;

    gl_Position = vec4(inPosition.xy * 2.0 - 1.0, 0.0, 1.0);
}