//////////////////////////////////////////////////////////////////////////////
//    ##      #####   ######   ######     ##     ####     #######  ##  ##   //
//   ####    ##   ##  # ## #    ##  ##   ####     ##       ##   #  ##  ##   //
//  ##  ##   #          ##      ##  ##  ##  ##    ##       ## #     ####    //
//  ##  ##    #####     ##      #####   ##  ##    ##       ####      ##     //
//  ######        ##    ##      ## ##   ######    ##   #   ## #     ####    //
//  ##  ##   ##   ##    ##      ##  ##  ##  ##    ##  ##   ##   #  ##  ##   //
//  ##  ##    #####    ####    #### ##  ##  ##   #######  #######  ##  ##   //
//--------------------------------------------------------------------------//
//--------------------------------------------------------------------------//
//      #####   ##   ##    ##     #####    #######  ######    #####         //
//     ##   ##  ##   ##   ####     ## ##    ##   #   ##  ##  ##   ##        //
//     #        ##   ##  ##  ##    ##  ##   ## #     ##  ##  #              //
//      #####   #######  ##  ##    ##  ##   ####     #####    #####         //
//          ##  ##   ##  ######    ##  ##   ## #     ## ##        ##        //
//          ##  ##   ##  ######    ##  ##   ## #     ## ##        ##        //
//     ##   ##  ##   ##  ##  ##    ## ##    ##   #   ##  ##  ##   ##        //
//      #####   ##   ##  ##  ##   #####    #######  #### ##   #####         //
/////(BSL Shaders Edit)//////////////////////////////////////By LexBoosT//////

//Settings//
#include "/lib/settings.glsl"

//Varyings//

varying vec2 texCoord;
varying vec3 sunVec, upVec;

//Fragment Shader///////////////////////////////////////////////////////////////////////////////////
#ifdef FSH

//Uniforms//
uniform int isEyeInWater;
uniform int worldTime;
uniform float frameTimeCounter;
uniform float blindFactor;
uniform float rainStrengthS;
uniform float screenBrightness;
uniform float shadowFade;
uniform float timeAngle, timeBrightness, moonBrightness;
uniform float viewWidth, viewHeight;

uniform ivec2 eyeBrightnessSmooth;

uniform sampler2D colortex0;
uniform sampler2D colortex1;


uniform mat4 gbufferProjectionInverse;


//Optifine Constants//
const bool colortex1MipmapEnabled = true;

//Common Variables//
float eBS = eyeBrightnessSmooth.y / 255.0;
float eBS2 = clamp(pow(eBS,2.0),0.0,1.0);
float sunVisibility  = clamp(dot( sunVec,upVec) + 0.0625, 0.0, 0.125) * 8.0;
float moonVisibility = clamp(dot( -sunVec,upVec) + 0.0625, 0.0, 0.125) * 8.0;
float screenBrightness2 = clamp(screenBrightness, 0.0, 1.0);

//Includes//
#include "/lib/color/dimensionColor.glsl"

//Program//
void main(){
	vec4 color = texture2D(colortex0,texCoord.xy);
	
	#ifdef END
	vec3 vl = texture2DLod(colortex1, texCoord.xy, 1.5).rgb;
	vl *= vl;
	#else
	vec3 vl = texture2DLod(colortex1, texCoord.xy, 1.5).rgb;
	vl = vl * 0.5 + texture2DLod(colortex1, texCoord.xy, 0.5).rgb * 0.5;
	
	vl *= vl;
	
	#endif
	
	#ifdef OVERWORLD
	#ifdef END
	if (isEyeInWater == 0) {
		vl *= lightCol * lightCol * lightCol * lightCol;
		vl *= mix(1.0, LIGHT_SHAFT_NOON_MULTIPLIER * 0.5, timeBrightness*timeBrightness);
		vl *= mix(LIGHT_SHAFT_NIGHT_MULTIPLIER * 10.0, 2.0, sunVisibility);
		vl *= mix(1.0, LIGHT_SHAFT_RAIN_MULTIPLIER * 0.25, rainStrengthS*rainStrengthS);
	}
	else vl *= length(lightCol) * 0.2 * LIGHT_SHAFT_UNDERWATER_MULTIPLIER  * (1.0 - rainStrengthS * 0.85);
	#else
	if (isEyeInWater == 0) {
		float lightShaftEndurance = LIGHTSHAFT_ENDURANCE;
		if ((lightShaftEndurance < 5.40 || lightShaftEndurance > 5.60) && rainStrengthS < 1.0) {
			vec4 screenPos = vec4(gl_FragCoord.xy / vec2(viewWidth, viewHeight), gl_FragCoord.z, 1.0);
			vec4 viewPos = gbufferProjectionInverse * (screenPos * 2.0 - 1.0);
			viewPos /= viewPos.w;
			vec3 nViewPos = normalize(viewPos.xyz);
			
			float NdotU = dot(nViewPos, upVec);
			NdotU = max(NdotU, 0.0);
			NdotU = 1.0 - NdotU;
			if (NdotU > 0.5) NdotU = smoothstep(0.0, 1.0, NdotU);
			
			#if DIRECTION_LIGHTSHAFT == 3
			#endif
			#if DIRECTION_LIGHTSHAFT == 2
			NdotU *= NdotU;
			#endif
			#if DIRECTION_LIGHTSHAFT == 1
			NdotU *= NdotU;
			NdotU *= NdotU;
			#endif
			#if DIRECTION_LIGHTSHAFT == 0
			NdotU *= NdotU;
			NdotU *= NdotU;
			NdotU *= NdotU;
			#endif
			
			if (rainStrengthS > 0.0) NdotU = pow(NdotU, 1.0 - rainStrengthS);
			
			vl *= NdotU * NdotU;
		}
		
		#ifdef SHINY_SUNRISE
		vec3 dayLightCol = lightCol2 * lightCol2 * lightCol2;
		#else
		vec3 dayLightCol = lightCol * lightCol * lightCol * lightCol;
		#endif
		
		vec3 nightLightCol = lightCol * lightCol * 20.0;
		vl *= mix(nightLightCol, dayLightCol, sunVisibility);
		
		vl *= clamp(mix(1.0, LIGHT_SHAFT_NOON_MULTIPLIER * 0.75, timeBrightness * timeBrightness),0.0,1.0);
		vl *= clamp(mix(LIGHT_SHAFT_NIGHT_MULTIPLIER *  (0.35 - moonBrightness * 0.15), 2.0, sunVisibility),0.0,1.0);
		vl *= clamp(mix(1.0, LIGHT_SHAFT_RAIN_MULTIPLIER * 0.5, rainStrengthS*rainStrengthS),0.0,1.0);


	} else vl *= length(lightCol) * 0.2 * LIGHT_SHAFT_UNDERWATER_MULTIPLIER  * (1.0 - rainStrengthS * 0.85);
	#endif
	#endif
	
	#ifdef END
	vl *= endCol.rgb * 0.025;
	#endif
	
	#ifdef OVERWORLD
	vl *= LIGHT_SHAFT_STRENGTH / 3.0 * (1.0 - rainStrengthS * eBS * 0.875) * shadowFade * (1 + isEyeInWater * 40.0 * eBS2) * (1.0 - blindFactor);
	#else
	vl *= LIGHT_SHAFT_STRENGTH_END * shadowFade * (1.0 - blindFactor);
	
	float vlFactor = (1.0 - min((timeBrightness)*2.0, 0.75));
	vlFactor = mix(vlFactor, 0.05, rainStrengthS);
	if (isEyeInWater == 1) vlFactor = 3.0;
	vl *= vlFactor * 1.15;
	#endif
	
	color.rgb += vl;
	
	
	/*DRAWBUFFERS:0*/
	gl_FragData[0]=color;
}

#endif

//Vertex Shader/////////////////////////////////////////////////////////////////////////////////////
#ifdef VSH

//Uniforms//
uniform float timeAngle;

uniform mat4 gbufferModelView;

//Program//
void main(){
	texCoord=gl_MultiTexCoord0.xy;
	
	gl_Position=ftransform();
	
	const vec2 sunRotationData=vec2(cos(sunPathRotation*.01745329251994),-sin(sunPathRotation*.01745329251994));
	float ang=fract(timeAngle-.25);
	ang=(ang+(cos(ang*3.14159265358979)*-.5+.5-ang)/3.)*6.28318530717959;
	sunVec=normalize((gbufferModelView*vec4(vec3(-sin(ang),cos(ang)*sunRotationData)*2000.,1.)).xyz);
	
	upVec=normalize(gbufferModelView[1].xyz);
}

#endif