//////////////////////////////////////////////////////////////////////////////
//    ##      #####   ######   ######     ##     ####     #######  ##  ##   //
//   ####    ##   ##  # ## #    ##  ##   ####     ##       ##   #  ##  ##   //
//  ##  ##   #          ##      ##  ##  ##  ##    ##       ## #     ####    //
//  ##  ##    #####     ##      #####   ##  ##    ##       ####      ##     //
//  ######        ##    ##      ## ##   ######    ##   #   ## #     ####    //
//  ##  ##   ##   ##    ##      ##  ##  ##  ##    ##  ##   ##   #  ##  ##   //
//  ##  ##    #####    ####    #### ##  ##  ##   #######  #######  ##  ##   //
//--------------------------------------------------------------------------//
//--------------------------------------------------------------------------//
//      #####   ##   ##    ##     #####    #######  ######    #####         //
//     ##   ##  ##   ##   ####     ## ##    ##   #   ##  ##  ##   ##        //
//     #        ##   ##  ##  ##    ##  ##   ## #     ##  ##  #              //
//      #####   #######  ##  ##    ##  ##   ####     #####    #####         //
//          ##  ##   ##  ######    ##  ##   ## #     ## ##        ##        //
//          ##  ##   ##  ######    ##  ##   ## #     ## ##        ##        //
//     ##   ##  ##   ##  ##  ##    ## ##    ##   #   ##  ##  ##   ##        //
//      #####   ##   ##  ##  ##   #####    #######  #### ##   #####         //
/////(BSL Shaders Edit)//////////////////////////////////////By LexBoosT//////

//Settings//
#include "/lib/settings.glsl"

//Varyings//
varying vec2 texCoord;

varying vec4 color;

//Fragment Shader///////////////////////////////////////////////////////////////////////////////////
#ifdef FSH

//Uniforms//
uniform sampler2D texture;

//Includes//
#include "/lib/color/blocklightColor.glsl"

//Program//
void main(){
	vec4 albedo = texture2D(texture, texCoord) * color * 0.8229;
	
	#ifdef EMISSIVE_RECOLOR
	if (dot(color.rgb, vec3(1.0)) > 2.66){
		float ec = length(albedo.rgb);
		albedo.rgb = blocklightCol * (ec * 0.63 / BLOCKLIGHT_I) + ec * 0.07;
	}
	#endif
	
	albedo.rgb = pow(albedo.rgb,vec3(5.0)) * 10.0;
	
	#ifdef WHITE_WORLD
	#ifdef BEACONW
	albedo.rgb = vec3(2.0);
	#endif
	#endif
	#ifdef BLACK_WORLD
	#ifdef BEACONW
	albedo.rgb = vec3(0.0);
	#endif
	#endif
	
	/* DRAWBUFFERS:0 */
	gl_FragData[0] = albedo;
	
	#ifdef ADVANCED_MATERIALS
	/* DRAWBUFFERS:0367 */
	gl_FragData[1]=vec4(0.,0.,0.,1.);
	gl_FragData[2]=vec4(0.,0.,float(gl_FragCoord.z<1.),1.);
	gl_FragData[3]=vec4(0.,0.,0.,1.);
	#endif
}

#endif

//Vertex Shader/////////////////////////////////////////////////////////////////////////////////////
#ifdef VSH

//Uniforms//
#if AA>1
uniform int frameCounter;

uniform float viewWidth;
uniform float viewHeight;
#endif

#ifdef WORLD_CURVATURE
uniform mat4 gbufferModelView;
uniform mat4 gbufferModelViewInverse;
#endif

//Includes//
#if AA>1
#include "/lib/util/jitter.glsl"
#endif

#ifdef WORLD_CURVATURE
#include "/lib/vertex/worldCurvature.glsl"
#endif

//Program//
void main(){
	texCoord=(gl_TextureMatrix[0]*gl_MultiTexCoord0).xy;
	
	color=gl_Color;
	
	#ifdef WORLD_CURVATURE
	vec4 position=gbufferModelViewInverse*gl_ModelViewMatrix*gl_Vertex;
	if(gl_ProjectionMatrix[2][2]<-.5)position.y-=WorldCurvature(position.xz);
	gl_Position=gl_ProjectionMatrix*gbufferModelView*position;
	#else
	gl_Position=ftransform();
	#endif
	
	#if AA>1
	gl_Position.xy=TAAJitter(gl_Position.xy,gl_Position.w);
	#endif
}

#endif