//////////////////////////////////////////////////////////////////////////////
//    ##      #####   ######   ######     ##     ####     #######  ##  ##   //
//   ####    ##   ##  # ## #    ##  ##   ####     ##       ##   #  ##  ##   //
//  ##  ##   #          ##      ##  ##  ##  ##    ##       ## #     ####    //
//  ##  ##    #####     ##      #####   ##  ##    ##       ####      ##     //
//  ######        ##    ##      ## ##   ######    ##   #   ## #     ####    //
//  ##  ##   ##   ##    ##      ##  ##  ##  ##    ##  ##   ##   #  ##  ##   //
//  ##  ##    #####    ####    #### ##  ##  ##   #######  #######  ##  ##   //
//--------------------------------------------------------------------------//
//--------------------------------------------------------------------------//
//      #####   ##   ##    ##     #####    #######  ######    #####         //
//     ##   ##  ##   ##   ####     ## ##    ##   #   ##  ##  ##   ##        //
//     #        ##   ##  ##  ##    ##  ##   ## #     ##  ##  #              //
//      #####   #######  ##  ##    ##  ##   ####     #####    #####         //
//          ##  ##   ##  ######    ##  ##   ## #     ## ##        ##        //
//          ##  ##   ##  ######    ##  ##   ## #     ## ##        ##        //
//     ##   ##  ##   ##  ##  ##    ## ##    ##   #   ##  ##  ##   ##        //
//      #####   ##   ##  ##  ##   #####    #######  #### ##   #####         //
/////(BSL Shaders Edit)//////////////////////////////////////By LexBoosT//////

//Settings//
#include "/lib/settings.glsl"

//Varyings//
varying float mat, recolor;
varying float visibleblock;
varying vec2 texCoord, lmCoord;

varying vec3 normal;
varying vec3 sunVec, upVec, eastVec;

varying vec4 color;
varying vec4 position;

#ifdef ADVANCED_MATERIALS
varying float dist;

varying vec3 binormal, tangent;
varying vec3 viewVector;

varying vec4 vTexCoord, vTexCoordAM;
#endif

//Fragment Shader///////////////////////////////////////////////////////////////////////////////////
#ifdef FSH

//Uniforms//
uniform int blockEntityId;
uniform int frameCounter;
uniform int isEyeInWater;
uniform int worldTime;
uniform int heldItemId;
uniform int heldItemId2;

#ifdef DYNAMIC_HAND_LIGHT
	uniform int heldBlockLightValue;
	uniform int heldBlockLightValue2;
#endif

uniform float frameTimeCounter;
uniform float nightVision;
uniform float rainStrength;
uniform float rainStrengthS;
uniform float screenBrightness;
uniform float shadowFade;
uniform float timeAngle, timeBrightness;
uniform float viewWidth, viewHeight;

uniform ivec2 eyeBrightnessSmooth;

uniform mat4 gbufferProjectionInverse;
uniform mat4 gbufferModelViewInverse;
uniform mat4 shadowProjection;
uniform mat4 shadowModelView;
uniform vec3 cameraPosition;
uniform sampler2D texture;
uniform sampler2D noisetex;

#ifdef ADVANCED_MATERIALS
uniform ivec2 atlasSize;
uniform sampler2D specular;
uniform sampler2D normals;

#ifdef REFLECTION_RAIN
uniform float wetness;
uniform mat4 gbufferModelView;

#endif
#endif

uniform vec3 fogColor;

//Common Variables//
float eBS = eyeBrightnessSmooth.y / 255.0;
float sunVisibility  = clamp(dot( sunVec,upVec) + 0.0625, 0.0, 0.125) * 8.0;
float moonVisibility = clamp(dot( -sunVec,upVec) + 0.0625, 0.0, 0.125) * 8.0;
float screenBrightness2 = clamp(screenBrightness, 0.0, 1.0);

#ifdef ADVANCED_MATERIALS
vec2 dcdx = dFdx(texCoord);
vec2 dcdy = dFdy(texCoord);
#endif

vec3 lightVec = sunVec * ((timeAngle < 0.5325 || timeAngle > 0.9675) ? 1.0 : -1.0);

//Common Functions//
float GetLuminance(vec3 color){
	return dot(color,vec3(0.299, 0.587, 0.114));
}

float InterleavedGradientNoise(){
	float n = 52.9829189 * fract(0.06711056 * gl_FragCoord.x + 0.00583715 * gl_FragCoord.y);
	return fract(n + frameCounter / 8.0);
}

//Includes//
#include "/lib/color/blocklightColor.glsl"
#include "/lib/color/dimensionColor.glsl"
#include "/lib/color/specularColor.glsl"
#include "/lib/util/dither.glsl"
#include "/lib/util/spaceConversion.glsl"
#include "/lib/lighting/forwardLighting.glsl"
#include "/lib/surface/ggx.glsl"

#ifdef WATER_CAUSTICS
#ifdef OVERWORLD
#include "/lib/color/waterColor.glsl"
#include "/lib/lighting/caustics.glsl"
#endif
#endif

#if AA >1
#include "/lib/util/jitter.glsl"
#endif

#ifdef ADVANCED_MATERIALS
#include "/lib/util/encode.glsl"
#include "/lib/reflections/complexFresnel.glsl"
#include "/lib/surface/directionalLightmap.glsl"
#include "/lib/surface/materialGbuffers.glsl"
#include "/lib/surface/parallax.glsl"

#ifdef REFLECTION_RAIN
#include "/lib/reflections/rainPuddles.glsl"
#endif
#endif

//Program//
void main(){
	
	#ifdef DETECTEUR_CAVE
	if(visibleblock>0.5){
		#endif
		
		vec4 albedo = texture2D(texture, texCoord) * vec4(color.rgb, 1.0);
		vec3 newNormal = normal;
		float smoothness = 0.0, metalness = 0.0, emission = 0.0;
		vec3 baseReflectance = vec3(0.04);

		#ifdef ADVANCED_MATERIALS
		vec2 newCoord = vTexCoord.st * vTexCoordAM.pq + vTexCoordAM.st;
		float parallaxFade = clamp((dist - PARALLAX_DISTANCE) / 32.0, 0.0, 1.0);
		float skipAdvMat = float(mat > 4.02 && mat < 5.02);
		
		#ifdef PARALLAX
		if(skipAdvMat < 0.5){
			newCoord = GetParallaxCoord(parallaxFade);
			albedo = texture2DGradARB(texture, newCoord, dcdx, dcdy) * vec4(color.rgb, 1.0);
		}
		#endif
		
		float skyOcclusion = 0.0;
		vec3 fresnel3 = vec3(0.0);
		#endif
		
		if (albedo.a > 0.00001){
			
			vec2 lightmap = clamp(lmCoord, vec2(0.0), vec2(1.0));
			
			float foliage  = float(mat > 0.98 && mat < 1.52);
			float leaves   = float(mat > 1.48 && mat < 1.52);
			float emissive = float(mat > 1.98 && mat < 2.02);
			float lava     = float(mat > 2.98 && mat < 3.02);
			float redstoneb= float(mat > 3.02 && mat < 4.02);
			float lapilazul= float(mat > 4.02 && mat < 5.02);
			
			emission = (emissive + lava) * 0.25;

			vec3 screenPos = vec3(gl_FragCoord.xy / vec2(viewWidth, viewHeight), gl_FragCoord.z);
			#if AA > 1
			vec3 viewPos = ToNDC(vec3(TAAJitter(screenPos.xy, -0.5), screenPos.z));
			#else
			vec3 viewPos = ToNDC(screenPos);
			#endif
			vec3 worldPos = ToWorld(viewPos);
			
			float lViewPos = length(viewPos.xyz);

			#ifdef ADVANCED_MATERIALS
			float metalness = 0.0, f0 = 0.0, ao = 1.0;
			vec3 normalMap = vec3(0.0, 0.0, 1.0);
			GetMaterials(smoothness, metalness, f0, emission, ao, normalMap, newCoord, dcdx, dcdy);
			
			mat3 tbnMatrix = mat3(tangent.x, binormal.x, normal.x,
								  tangent.y, binormal.y, normal.y,
								  tangent.z, binormal.z, normal.z);
			
			if (normalMap.x > -0.999 && normalMap.y > -0.999)
			newNormal = clamp(normalize(normalMap * tbnMatrix), vec3(-1.0), vec3(1.0));

			#ifdef REDSTONE_BLOCK_EMISSIVE
			if (redstoneb > 0.5) emission = 1.00, albedo.r *= 1.0, lightmap = vec2(0.7);
			#endif
			#ifdef LAPISLAZUL_BLOCK_EMISSIVE
			if (lapilazul > 0.5) emission = 1.00, albedo.b *= 1.0, lightmap = vec2(0.7);
			#endif

			#endif
			
			albedo.rgb = pow(albedo.rgb, vec3(2.2));
			
			float ec = GetLuminance(albedo.rgb) * 1.7;
			#ifdef EMISSIVE_RECOLOR
			if (recolor > 0.5){
				albedo.rgb = blocklightCol * pow(ec, 1.5) / (BLOCKLIGHT_I * BLOCKLIGHT_I);
				albedo.rgb /= 0.7 * albedo.rgb + 0.7;
			}
			if (lava > 0.02){
				albedo.rgb = pow(blocklightCol * ec / BLOCKLIGHT_I, vec3(2.0));
				albedo.rgb /= 0.5 * albedo.rgb + 0.5;
			}
			#else
			#endif
			
			#ifdef WHITE_WORLD
			#ifdef TERRAINW
			albedo.rgb = vec3(0.5);
			#endif
			#endif
			#ifdef BLACK_WORLD
			#ifdef TERRAINW
			albedo.rgb = vec3(0.0);
			#endif
			#endif
			
			vec3 outNormal = newNormal;
			if(foliage > 0.5 && leaves < 0.5) newNormal = upVec;

			float NoL = clamp(dot(newNormal, lightVec) * 1.01 - 0.01, 0.0, 1.0);
			float NoU = clamp(dot(newNormal, upVec), -1.0, 1.0);
			float NoE = clamp(dot(newNormal, eastVec), -1.0, 1.0);
			float vanillaDiffuse = (0.25 * NoU + 0.75) + (0.667 - abs(NoE)) * (1.0 - abs(NoU)) * 0.15;
				  vanillaDiffuse*= vanillaDiffuse;
			
			float smoothLighting = color.a;

			float parallaxShadow = 1.0;
			#ifdef ADVANCED_MATERIALS
			vec3 rawAlbedo = albedo.rgb * 0.999 + 0.001;
			albedo.rgb *= ao * ao;
			
			#ifdef REFLECTION_SPECULAR
			albedo.rgb *= 1.0 - metalness * smoothness;
			#endif
			
			float doParallax = 0.0;
			
			#ifdef SELF_SHADOW
			float pNoL = dot(outNormal, lightVec);
			#ifdef OVERWORLD
			doParallax = float(lightmap.y > 0.0 && pNoL > 0.0);
			#endif
			#ifdef END
			doParallax = float(pNoL > 0.0);
			#endif
			
			if (doParallax > 0.5 && skipAdvMat < 0.5){
				parallaxShadow = GetParallaxShadow(parallaxFade, newCoord, lightVec, tbnMatrix);
			}
			#endif
			
			#ifdef DIRECTIONAL_LIGHTMAP
			mat3 lightmapTBN = GetLightmapTBN(viewPos);
			lightmap.x = DirectionalLightmap(lightmap.x, lmCoord.x, newNormal, lightmapTBN);
			lightmap.y = DirectionalLightmap(lightmap.y, lmCoord.y, newNormal, lightmapTBN);
			#endif
			#endif
			
			vec3 shadow = vec3(0.0);
			
			GetLighting(albedo.rgb, shadow, viewPos, lViewPos, worldPos, lightmap, smoothLighting, NoL, vanillaDiffuse,
			parallaxShadow, emission, foliage * 0.5, 1.0);

			#ifdef ADVANCED_MATERIALS
			float puddles = 0.0;
			#if defined REFLECTION_RAIN && defined OVERWORLD
			NoU = clamp(NoU, 0.0, 1.0);
			
			#if REFLECTION_RAIN_TYPE == 0
			puddles = GetPuddles(worldPos) * NoU * wetness;
			#else
			puddles = NoU * wetness;
			#endif
			
			#ifdef WEATHER_PERBIOME
			float weatherweight = isCold + isDesert + isMesa + isSavanna;
			puddles *= 1.0 - weatherweight;
			#endif
			
			puddles *= clamp(lightmap.y * 32.0 - 31.0, 0.0, 1.0);
			
			smoothness = mix(smoothness, 1.0, puddles);
			f0 = max(f0, puddles * 0.02);
			
			albedo.rgb *= 1.0 - (puddles * 0.15);
			
			if (puddles > 0.001 && rainStrengthS > 0.001){
				mat3 tbnMatrix = mat3(tangent.x, binormal.x, normal.x,
					tangent.y, binormal.y, normal.y,
				tangent.z, binormal.z, normal.z);
				
				vec3 puddleNormal = GetPuddleNormal(worldPos, viewPos, tbnMatrix);
				newNormal = normalize(mix(newNormal, puddleNormal, puddles * rainStrengthS));
			}
			#endif
			
			skyOcclusion = lightmap.y * lightmap.y * (3.0 - 2.0 * lightmap.y);
			
			vec3 baseReflectance = mix(vec3(f0), rawAlbedo, metalness);
			float fresnel = pow(clamp(1.0 + dot(newNormal, normalize(viewPos.xyz)), 0.0, 1.0), 5.0);
			
			fresnel3 = mix(baseReflectance, vec3(1.0), fresnel);
			#if MATERIAL_FORMAT == 1
			if (f0 >= 0.9 && f0 < 1.0) {
				baseReflectance = GetMetalCol(f0);
				fresnel3 = ComplexFresnel(pow(fresnel, 0.2), f0);
				#ifdef ALBEDO_METAL
				fresnel3 *= rawAlbedo;
				#endif
			}
			#endif
			
			float aoSquared = ao * ao;
				  shadow *= aoSquared; fresnel3 *= aoSquared;
				  albedo.rgb = albedo.rgb * (1.0 - fresnel3 * smoothness * smoothness * (1.0 - metalness));
		
			
			#if defined OVERWORLD || defined END
			vec3 specularColor = GetSpecularColor(lightmap.y, metalness, baseReflectance);
			
			albedo.rgb += GetSpecularHighlight(newNormal, viewPos, lightVec, smoothness, baseReflectance,
										   specularColor, shadow * vanillaDiffuse, color.a);
			#endif
			
			#if defined ADVANCED_MATERIALS && defined REFLECTION_SPECULAR && defined REFLECTION_ROUGH
			if (normalMap.x > -0.999 && normalMap.y > -0.999){
				normalMap = mix(vec3(0.0, 0.0, 1.0), normalMap, smoothness);
				newNormal = mix(normalMap * tbnMatrix, newNormal, 1.0 - pow(1.0 - puddles, 4.0));
				newNormal = clamp(normalize(newNormal), vec3(-1.0), vec3(1.0));
			}
			#endif
			#endif
			
			#if defined WATER_CAUSTICS && defined OVERWORLD
			if (isEyeInWater == 1) {
				float skyLightMap = lightmap.y * lightmap.y * (3.0 - 2.0 * lightmap.y);
				shadow *= NoL;
				albedo.rgb = GetCaustics(albedo.rgb, worldPos.xyz, cameraPosition.xyz, shadow, skyLightMap, lightmap.x);
			}
			#endif
			
			#ifdef SHOW_LIGHT_LEVELS
			float showLightLevelFactor = fract(frameTimeCounter / 2.0);
			if (showLightLevelFactor > 0.5) showLightLevelFactor = 1.0 - showLightLevelFactor;
			if (lmCoord.x < 0.5 && vanillaDiffuse > 0.99) albedo.rgb += mix(albedo.rgb,vec3(SLV_R, SLV_G, SLV_B),SLV_I / 10.0) * showLightLevelFactor;
			#endif
			
		} else albedo.a = 0.0;
		
		
		
		/* DRAWBUFFERS:0 */
		gl_FragData[0] = albedo;
		
		#if defined ADVANCED_MATERIALS && defined REFLECTION_SPECULAR
		/* DRAWBUFFERS:0367 */
		gl_FragData[1]=vec4(smoothness,skyOcclusion, 0.0, 1.0);
		gl_FragData[2]=vec4(EncodeNormal(newNormal),float(gl_FragCoord.z<1.),1.);
		gl_FragData[3]=vec4(fresnel3, 1.0);
		
		#endif
		
		#ifdef DETECTEUR_CAVE
	}
	else
	{
		discard;
	}
	#endif
	
}

#endif

//Vertex Shader/////////////////////////////////////////////////////////////////////////////////////
#ifdef VSH

//Uniforms//
uniform int worldTime;

uniform float frameTimeCounter;
uniform float timeAngle;

uniform vec3 cameraPosition;

uniform mat4 gbufferModelView,gbufferModelViewInverse;
uniform mat4 gbufferProjection;

#if AA>1
uniform int frameCounter;
uniform float viewWidth,viewHeight;
#endif

//Attributes//
attribute vec4 mc_Entity;
attribute vec4 mc_midTexCoord;

#ifdef ADVANCED_MATERIALS
attribute vec4 at_tangent;
#endif

//Includes//
#include "/lib/vertex/waving.glsl"

#if AA>1
#include "/lib/util/jitter.glsl"
#endif

#ifdef WORLD_CURVATURE
#include "/lib/vertex/worldCurvature.glsl"
#endif

//Program//
void main(){
	
	#ifdef DETECTEUR_CAVE
	if(mc_Entity.x==10003||mc_Entity.x==10002||mc_Entity.x==10999){visibleblock=0.;}else{visibleblock=1.;};
	#else
	visibleblock=1.;
	#endif
	
	texCoord=(gl_TextureMatrix[0]*gl_MultiTexCoord0).xy;
	
	lmCoord=(gl_TextureMatrix[1]*gl_MultiTexCoord1).xy;
	lmCoord = clamp((lmCoord - 0.03125) * 1.06667, vec2(0.0), vec2(0.9333, 1.0));
	
	normal=normalize(gl_NormalMatrix*gl_Normal);
	
	#ifdef ADVANCED_MATERIALS
	binormal=normalize(gl_NormalMatrix*cross(at_tangent.xyz,gl_Normal.xyz)*at_tangent.w);
	tangent=normalize(gl_NormalMatrix*at_tangent.xyz);
	
	mat3 tbnMatrix=mat3(tangent.x,binormal.x,normal.x,
						tangent.y,binormal.y,normal.y,
						tangent.z,binormal.z,normal.z);
	
	viewVector=tbnMatrix*(gl_ModelViewMatrix*gl_Vertex).xyz;
	
	dist=length(gl_ModelViewMatrix*gl_Vertex);
	
	vec2 midCoord=(gl_TextureMatrix[0]*mc_midTexCoord).st;
	vec2 texMinMidCoord=texCoord-midCoord;
	
	vTexCoordAM.pq=abs(texMinMidCoord)*2;
	vTexCoordAM.st=min(texCoord,midCoord-texMinMidCoord);
	
	vTexCoord.xy=sign(texMinMidCoord) * 0.5 + 0.5;
	#endif
	
	color=gl_Color;
	
	mat=0.0 ; recolor=0.0;
	
	if (mc_Entity.x == 10100 || mc_Entity.x == 10101 || mc_Entity.x == 10102 || mc_Entity.x == 10103 ||
	    mc_Entity.x == 10104 || mc_Entity.x == 10105 || mc_Entity.x == 10106 || mc_Entity.x == 10107 ||
	    mc_Entity.x == 10108 || mc_Entity.x == 10109)
		mat = 1.5;
		color.rgb *= 1.35;

	if (mc_Entity.x == 10200 || mc_Entity.x == 10207 || mc_Entity.x == 10210 || mc_Entity.x == 10214 ||
		mc_Entity.x == 10215 || mc_Entity.x == 10216 || mc_Entity.x == 10226 || mc_Entity.x == 10231 ||
		mc_Entity.x == 10249 || mc_Entity.x == 10250 || mc_Entity.x == 10251 || mc_Entity.x == 10252 ||
		mc_Entity.x == 10253 || mc_Entity.x == 10254 )
		mat = 2.0;

	////////////////////////////////////////////////////////////////////////////
	////////////////////////////////Emissive Menu//////////////////////////////
	//////////////////////////////////////////////////////////////////////////

	#ifdef OVERWORLD

	// Lava / Flowing Lava
	if(	mc_Entity.x == 10248) 
		mat=3.0, color.a *=0.40, lmCoord.x += 0.0667, color.rgb *= sqrt(OVERWORLD_LAVA_BRIGHTNESS);

	// Fire / Soul Fire
	if (mc_Entity.x ==  10249 || mc_Entity.x ==10252) 
		lmCoord.x = 0.5, color.a *= 1.0, color.rgb *= sqrt(FIRE_BRIGHTNESS_OVERWORLD);

	// Lantern
	if (mc_Entity.x == 10251 || mc_Entity.x == 10254) 
		lmCoord.x = 0.860, color.a *= 1.0, color.rgb *= sqrt(LANTERN_BRIGHTNESS_OVERWORLD);

	// Soul Lantern
	if (mc_Entity.x == 10226 || mc_Entity.x == 10253) 
		lmCoord.x = 0.750, color.a *= 1.0, color.rgb *= sqrt(SOUL_LANTERN_BRIGHTNESS_OVERWORLD);

	// Shroomlight
	if (mc_Entity.x == 10217) 
		lmCoord.x = 0.165, mat=2.0 ,color.a *= 1.0, color.rgb *= sqrt(SHROOMLIGHT_BRIGHTNESS_OVERWORLD);

	// GlowStone
	if (mc_Entity.x == 10231) 
		lmCoord.x = 0.165, mat=2.0 ,color.a *= 1.0, color.rgb *= sqrt(GLOWSTONE_BRIGHTNESS_OVERWORLD);

	// Redstone Lamp
	if (mc_Entity.x == 10218) 
		lmCoord.x = 0.165, mat=2.0 ,color.a *= 1.0, color.rgb *= sqrt(REDSTONE_LAMP_BRIGHTNESS_OVERWORLD);

	// Sea Lantern
	if (mc_Entity.x == 10219) 
		lmCoord.x = 0.165, mat=2.0 ,color.a *= 1.0, color.rgb *= sqrt(SEA_LANTERN_BRIGHTNESS_OVERWORLD);

	#ifdef ADVANCED_MATERIALS
	#ifdef REDSTONE_BLOCK_EMISSIVE
	// Redstone Block
	if (mc_Entity.x == 10220 || mc_Entity.x == 10200) 
		lmCoord.x = 0.5, mat=4.0 ,color.a *= 1.0, color.rgb *= sqrt(REDSTONE_BLOCK_BRIGHTNESS_OVERWORLD);
	#endif

	#ifdef LAPISLAZUL_BLOCK_EMISSIVE
	// Lapis Lazuli Block
	if (mc_Entity.x == 10221) 
		lmCoord.x = 0.5, mat=5.0 ,color.a *= 1.0, color.rgb *= sqrt(LAPIS_BLOCK_BRIGHTNESS_OVERWORLD);
	#endif
	#endif

	// Jack O Lantern
	if (mc_Entity.x == 10222) 
		lmCoord.x = 0.165, mat=2.0 ,color.a *= 1.0, color.rgb *= sqrt(JACKOLANTERN_BRIGHTNESS_OVERWORLD);

	// Torch / End Rod
	if (mc_Entity.x == 10214) 
		lmCoord.x = 0.855, mat=2.0 ,color.a *= 1.0, color.rgb *= sqrt(TORCH_ENDROD_BRIGHTNESS_OVERWORLD);
	
	#endif

	#ifdef NETHER

	// Lava / Flowing Lava
	if(	mc_Entity.x == 10248) 
		mat=3.0, color.a *=0.40,lmCoord.x += 0.0667, color.rgb *= sqrt(NETHER_LAVA_BRIGHTNESS);

	// Fire / Soul Fire
	if (mc_Entity.x ==  10249 || mc_Entity.x ==10252)
		lmCoord.x = 0.5, color.a *= 1.0, color.rgb *= sqrt(FIRE_BRIGHTNESS_NETHER);

	// Lantern
	if (mc_Entity.x == 10251 || mc_Entity.x == 10254) 
		lmCoord.x = 0.860, color.a *= 1.0, color.rgb *= sqrt(LANTERN_BRIGHTNESS_NETHER);

	// Soul Lantern
	if (mc_Entity.x == 10226 || mc_Entity.x == 10253) 
		lmCoord.x = 0.750, color.a *= 1.0, color.rgb *= sqrt(SOUL_LANTERN_BRIGHTNESS_NETHER);

	// Shroomlight
	if (mc_Entity.x == 10217) 
		lmCoord.x = 0.165, mat=2.0 ,color.a *= 1.0, color.rgb *= sqrt(SHROOMLIGHT_BRIGHTNESS_NETHER);

	// GlowStone
	if (mc_Entity.x == 10231) 
		lmCoord.x = 0.165, mat=2.0 ,color.a *= 1.0, color.rgb *= sqrt(GLOWSTONE_BRIGHTNESS_NETHER);

	// Redstone Lamp
	if (mc_Entity.x == 10218) 
		lmCoord.x = 0.165, mat=2.0 ,color.a *= 1.0, color.rgb *= sqrt(REDSTONE_LAMP_BRIGHTNESS_NETHER);

	// Sea Lantern
	if (mc_Entity.x == 10219) 
		lmCoord.x = 0.165, mat=2.0 ,color.a *= 1.0, color.rgb *= sqrt(SEA_LANTERN_BRIGHTNESS_NETHER);

	#ifdef ADVANCED_MATERIALS
	#ifdef REDSTONE_BLOCK_EMISSIVE
	// Redstone Block
	if (mc_Entity.x == 10220 || mc_Entity.x == 10200) 
		lmCoord.x = 0.5, mat=4.0 ,color.a *= 1.0, color.rgb *= sqrt(REDSTONE_BLOCK_BRIGHTNESS_OVERWORLD);
	#endif
	#endif

	#ifdef LAPISLAZUL_BLOCK_EMISSIVE
	// Lapis Lazuli Block
	if (mc_Entity.x == 10221) 
		lmCoord.x = 0.5, mat=5.0 ,color.a *= 1.0, color.rgb *= sqrt(LAPIS_BLOCK_BRIGHTNESS_OVERWORLD);
	#endif

	// Jack O Lantern
	if (mc_Entity.x == 10222) 
		lmCoord.x = 0.165, mat=2.0 ,color.a *= 1.0, color.rgb *= sqrt(JACKOLANTERN_BRIGHTNESS_NETHER);

	// Torch / End Rod
	if (mc_Entity.x == 10214) 
		lmCoord.x = 0.855, mat=2.0 ,color.a *= 1.0, color.rgb *= sqrt(TORCH_ENDROD_BRIGHTNESS_NETHER);

	#endif

	#ifdef END

	// Lava / Flowing Lava
	if(	mc_Entity.x == 10248)
		lmCoord.x += 0.0667, mat=3.0, lmCoord.x += 0.0667, color.a *=0.40, color.rgb *= sqrt(END_LAVA_BRIGHTNESS);

	// Fire / Soul Fire
	if (mc_Entity.x ==  10249 || mc_Entity.x ==10252) 
		lmCoord.x = 0.5, color.a *= 1.0, color.rgb *= sqrt(FIRE_BRIGHTNESS_ENDER);

	// Lantern
	if (mc_Entity.x == 10251 || mc_Entity.x == 10254) 
		lmCoord.x = 0.860, color.a *= 1.0, color.rgb *= sqrt(LANTERN_BRIGHTNESS_ENDER);

	// Soul Lantern
	if (mc_Entity.x == 10226 || mc_Entity.x == 10253) 
		lmCoord.x = 0.750, color.a *= 1.0, color.rgb *= sqrt(SOUL_LANTERN_BRIGHTNESS_ENDER);

	// Shroomlight
	if (mc_Entity.x == 10217) 
		lmCoord.x = 0.165, mat=2.0 ,color.a *= 1.0, color.rgb *= sqrt(SHROOMLIGHT_BRIGHTNESS_ENDER);

	// GlowStone
	if (mc_Entity.x == 10231) 
		lmCoord.x = 0.165, mat=2.0 ,color.a *= 1.0, color.rgb *= sqrt(GLOWSTONE_BRIGHTNESS_ENDER);

	// Redstone Lamp
	if (mc_Entity.x == 10218) 
		lmCoord.x = 0.165, mat=2.0 ,color.a *= 1.0, color.rgb *= sqrt(REDSTONE_LAMP_BRIGHTNESS_ENDER);
	
	// Sea Lantern
	if (mc_Entity.x == 10219) 
		lmCoord.x = 0.165, mat=2.0 ,color.a *= 1.0, color.rgb *= sqrt(SEA_LANTERN_BRIGHTNESS_ENDER);

	#ifdef ADVANCED_MATERIALS
	#ifdef REDSTONE_BLOCK_EMISSIVE
	// Redstone Block
	if (mc_Entity.x == 10220 || mc_Entity.x == 10200)
		lmCoord.x = 0.5, mat=4.0 ,color.a *= 1.0, color.rgb *= sqrt(REDSTONE_BLOCK_BRIGHTNESS_OVERWORLD);
	#endif

	#ifdef LAPISLAZUL_BLOCK_EMISSIVE
	// Lapis Lazuli Block
	if (mc_Entity.x == 10221) 
		lmCoord.x = 0.5, mat=5.0 ,color.a *= 1.0, color.rgb *= sqrt(LAPIS_BLOCK_BRIGHTNESS_OVERWORLD);
	#endif
	#endif
	
	// Jack O Lantern
	if (mc_Entity.x == 10222) 
		lmCoord.x = 0.165, mat=2.0 ,color.a *= 1.0, color.rgb *= sqrt(JACKOLANTERN_BRIGHTNESS_ENDER);

	// Torch / End Rod
	if (mc_Entity.x == 10214) 
		lmCoord.x = 0.855, mat=2.0 ,color.a *= 1.0, color.rgb *= sqrt(TORCH_ENDROD_BRIGHTNESS_ENDER);

	#endif

	//////////Recolor//////////
	if (mc_Entity.x == 10216 || mc_Entity.x == 10217 || mc_Entity.x == 10219|| mc_Entity.x == 10226 || 
		mc_Entity.x == 10231 || mc_Entity.x == 10250 ||	mc_Entity.x == 10251 || mc_Entity.x == 10253 || 
		mc_Entity.x == 10254)
		recolor = 1.0;
	
	if (mc_Entity.x == 10245) // Furnace
		lmCoord.x -= 0.0667;

	if (mc_Entity.x == 10400) // lectern
		color.a = 1.0;


	const vec2 sunRotationData=vec2(cos(sunPathRotation*.01745329251994),-sin(sunPathRotation*.01745329251994));
	float ang=fract(timeAngle-.25);
	ang=(ang+(cos(ang*3.14159265358979)*-.5+.5-ang)/3.)*6.28318530717959;
	sunVec=normalize((gbufferModelView*vec4(vec3(-sin(ang),cos(ang)*sunRotationData)*2000.,1.)).xyz);
	
	upVec=normalize(gbufferModelView[1].xyz);
	eastVec=normalize(gbufferModelView[0].xyz);

	vec4 position=gbufferModelViewInverse*gl_ModelViewMatrix*gl_Vertex;
	
	float istopv=gl_MultiTexCoord0.t<mc_midTexCoord.t?1.0:0.0;
	position.xyz=WavingBlocks(position.xyz,istopv,lmCoord.y);
	
	#ifdef WORLD_CURVATURE
	position.y-=WorldCurvature(position.xz);
	#endif
	
	#ifdef MOUVEMENT_CAM
	position+=vec4(.03*sin(frameTimeCounter*3.*SPEED_MOOVE),.015*cos(frameTimeCounter*4.*SPEED_MOOVE),0.,0.)*gbufferModelView;
	#endif
	
	gl_Position=gl_ProjectionMatrix*gbufferModelView*position;
	
	#if AA>1
	gl_Position.xy=TAAJitter(gl_Position.xy,gl_Position.w);
	#endif
	
}

#endif