/********************************************************
    © 2020 Continuum Graphics LLC. All Rights Reserved
 ********************************************************/

#if !defined _TERRAINPARALLAX_
#define _TERRAINPARALLAX_

#define wrapCoord(p) (round( (midcoord - (p) ) / tileSize ) * tileSize + (p))

vec4 texBilinear(sampler2D tex, vec2 pos, mat2 texD) {
    #if !(defined terrain || defined hand || defined translucent) 
        return texture2DGrad(tex, pos, texD[0], texD[1]);
    #endif

    vec3 offset = vec3(vec2(1.0 / atlasSize), 0.0);

    vec2 weight = fract(pos * atlasSize);
         weight = weight * weight * (3.0 - 2.0 * weight);
         
    vec2 fp = wrapCoord(floor(pos * atlasSize) / atlasSize);
   
    vec4 bottom = mix(texture2DGrad(tex, fp, texD[0], texD[1]),
                      texture2DGrad(tex, wrapCoord(fp + offset.xz), texD[0], texD[1]),
                      weight.x);

    vec4 top = mix(texture2DGrad(tex, wrapCoord(fp + offset.zy), texD[0], texD[1]), 
                   texture2DGrad(tex, wrapCoord(fp + offset.xy), texD[0], texD[1]), 
                   weight.x);

    return mix(bottom, top, weight.y);
}

#ifdef BILINEAR_TEXTURES
#define getDepth(p) (texBilinear(normals, wrapCoord(p), texD).a * parallaxDepth - parallaxDepth)
#else
#define getDepth(p) (texture2DGrad(normals, wrapCoord(p), texD[0], texD[1]).a * parallaxDepth - parallaxDepth)
#endif

vec2 TerrainPOM(vec2 coord, mat2 texD, inout float pomShadow) {
    #if !(defined terrain && defined TERRAIN_PARALLAX)
        return coord;
    #endif
    
    float texHeight = texture2D(normals, coord).a;
    if (texHeight <= 0.0 || texHeight >= 1.0) { return coord; }

    vec3 step = tangentSpaceViewVector * inversesqrt(dot(tangentSpaceViewVector.xy, tangentSpaceViewVector.xy));
         step = length(step.xy * texD) * step;

    float l = length(step);
		  l = max(l, 1e-4) / l;
          
    step *= step.z >= -1e-5 ? l : 1.0;

    bool fix = step.z < -1e-5;
    vec3 p = vec3(coord, 0.0);

    while (getDepth(p.xy) < p.z && fix)
        { p += step; }

    #if defined WORLD0
    #ifdef TERRAIN_PARALLAX_SHADOW
        vec3 stepL = (shadowLightPosition * mat3(gbufferModelView)) * tbn;
            stepL = stepL * inversesqrt(dot(stepL.xy, stepL.xy));
            stepL = length(stepL.xy * texD) * stepL;

        float lightL = length(stepL);
		      lightL = max(lightL, 1e-4) / l;

        float shadowBias = (parallaxDepth * 2.0) / 255.0;

        stepL *= stepL.z <= 1e-6 ? lightL : 1.;

        vec3 lightP = vec3(p.xy, getDepth(p.xy) + shadowBias);
        bool lightFix = stepL.z > 1e-6;

        while(getDepth(lightP.xy) <= lightP.z && lightFix && lightP.z < 0.0) {
            lightP += stepL;
        }

        pomShadow = lightP.z < -1e-6 && lightFix ? 0.0 : 1.0;
    #endif
    #endif
    
    return wrapCoord(p.xy);
}

#endif
