/********************************************************
    © 2020 Continuum Graphics LLC. All Rights Reserved
 ********************************************************/

#if !defined _VOLUMETRICLIGHTING_
#define _VOLUMETRICLIGHTING_

#include "/../ContinuumLib/Uniform/ShadowDistortion.glsl"

float CalculateVolumeInShadow(vec3 shadowPosition) {
    shadowPosition.xy = DistortShadowSpaceProj(shadowPosition.xy);
    if (any(greaterThanEqual(abs(vec3(shadowPosition.xy, shadowPosition.z)), vec3(1.0)))) return 1.0;
    
    float depth = textureLod(shadowtex1, shadowPosition.xy, 0).x;
    return float(depth > shadowPosition.z);
}

//#define VOLUMETRIC_SHADOWS

// Returns the fraction of marched air that is in sunlight (not occluded)
// Outputs in the range [0.0, 1.0] where 1.0 == no shadow
float CalculateLitAirVolume(vec3 start, vec3 end, float dither) {
    #ifndef VOLUMETRIC_SHADOWS
		return 1.0;
	#endif
	
	// Clamp marching endpoint to be within the terrain volume (0.0 to 256.0)
	if (abs(end.y) > cameraPosition.y) end = end / abs(end.y) * cameraPosition.y;
	
	const int   steps  = 50;
    const float rSteps = 1.0 / steps;

    float stepLength = length((end - start) * rSteps);

    vec3 shadowStart = WorldSpaceToShadowSpace(start);
    vec3 shadowEnd = WorldSpaceToShadowSpace(end);
    vec3 shadowStep = (shadowEnd - shadowStart) * rSteps;
    vec3 shadowPosition = shadowStart + shadowStep * dither;

    float litAir = 0.0;

    for(int i = 0; i < steps; ++i, shadowPosition += shadowStep) {
        litAir += CalculateVolumeInShadow(shadowPosition);
    }
	
    return litAir * rSteps;
}

#endif
