/********************************************************
    © 2020 Continuum Graphics LLC. All Rights Reserved
 ********************************************************/

#if !defined _VERTEXDISPLACEMENT_
#define _VERTEXDISPLACEMENT_

float calculateWindInteraction(float x) {
    return exp(-sin(x) - 1.0);
}

vec3 calculateWindInteraction(vec3 worldPosition, float wind) {
    float x = calculateWindInteraction(worldPosition.x + worldPosition.z - wind * 2.) * 0.25;
          x -= calculateWindInteraction(worldPosition.x + wind * 3. - x * PI) * 0.125;
          x += calculateWindInteraction(worldPosition.z - wind * 4.) * 0.125;
          x += calculateWindInteraction(worldPosition.y * 2. - wind * 3.) * 0.125;

    float y = calculateWindInteraction(worldPosition.x - worldPosition.z + wind * 2.) * 0.25;
          y -= calculateWindInteraction(worldPosition.y - wind * 3. + y * PI) * 0.125;
          y -= calculateWindInteraction(worldPosition.z - worldPosition.x + wind * 4.) * 0.125;

    float z = calculateWindInteraction(worldPosition.z + worldPosition.x - wind * 2.) * 0.25;
          z += calculateWindInteraction(worldPosition.z + wind * 3. + z * PI) * 0.125;
          z -= calculateWindInteraction(worldPosition.x - wind * 4.) * 0.125;
          z -= calculateWindInteraction(worldPosition.y * 2. + wind * 3.) * 0.125;

    return vec3(x, y, z);
}

void calculateDisplacement(inout vec3 worldPosition, float skylightmap, int blockID) {
    #ifndef WAVING_PLANTS
        return;
    #endif
    
    float topVertex = float(texcoord.y < mc_midTexCoord.y);
    
    worldPosition += cameraPosition;

    float underCover = clamp01(skylightmap * skylightmap * 2.0 - 1.0);
    
    vec3 grassDisplacement = calculateWindInteraction(worldPosition, TIME) * 0.75 * underCover;
    vec3 leavesDisplacement = calculateWindInteraction(worldPosition, TIME * 0.5) * 0.5 * underCover;

    switch (blockID) {
        case 18:
        case 161:
            worldPosition += leavesDisplacement;
            break;
        case 31:
        case 37:
        case 38:
        case 59:
        case 175:
            worldPosition.xz += grassDisplacement.xz * topVertex;
            break;
        case 176:
            worldPosition.xz += grassDisplacement.xz * (topVertex + 1.0);
            break;
        default:
            break;
    }

    worldPosition -= cameraPosition;
}

#endif