#if !defined _CAMERASETTINGS_
#define _CAMERASETTINGS_

/*******************************************************************************
 - Camera Settings
 ******************************************************************************/

#define CAMERA_MODE CAMERA_AUTO // [CAMERA_AUTO CAMERA_MANUAL]  //0 Auto 1 Manual
#define CAMERA_EV 0.0 // [-4.0 -3.9 -3.8 -3.7 -3.6 -3.5 -3.4 -3.3 -3.2 -3.1 -3.0 -2.9 -2.8 -2.7 -2.6 -2.5 -2.4 -2.3 -2.2 -2.1 -2.0 -1.9 -1.8 -1.7 -1.6 -1.5 -1.4 -1.3 -1.2 -1.1 -1.0 -0.9 -0.8 -0.7 -0.6 -0.5 -0.4 -0.3 -0.2 -0.1 0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0 2.1 2.2 2.3 2.4 2.5 2.6 2.7 2.8 2.9 3.0 3.1 3.2 3.3 3.4 3.5 3.6 3.7 3.8 3.9 4.0]
#define CAMERA_FOCAL_LENGTH 100 // [10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29 30 31 32 33 34 35 36 37 38 39 40 41 42 43 44 45 46 47 48 49 50 51 52 53 54 55 56 57 58 59 60 65 70 75 80 85 90 95 100 110 120 130 140 150 160 170 180 190 200 220 240 260 280 300 320 340 360 380 400 420 440 460 480 500]

//Auto Camera Settings
#define AUTO_EXPOSURE_TIME 1.0
#define AUTO_EXPOSURE_MIN_LUM 0.5
#define AUTO_EXPOSURE_MAX_LUM 2048.0

//Manual Camera Settings
#define CAMERA_APERTURE 16.0 // [1.4 2 2.8 4 5.6 8.0 11.0 16.0 22.0]
#define CAMERA_ISO 100 // [50 75 100 200 400 800 1600 3200 6400]
#define CAMERA_SHUTTER_SPEED 100 // [1 2 4 8 10 20 25 50 75 100 125 200 300 400 500 600 700 800 900 1000 1100 1200 1300 1400 1500 1600 1700 1800 1900 2000]

#define DISTORTION_ANAMORPHIC 1.0 // [0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5]
#define DISTORTION_BARREL 0.0

#define CAMERA_BLADES 8 // [3 4 5 6 7 8]                                            //Amount of blades on the camera
#define BLADE_ROTATION 0.0 // [0.0 0.2 0.4 0.6 0.8 1.0]                             //Rotation of the blades in radians
#define BLADE_ROUNDING 0.3 // [0.0 0.2 0.4 0.6 0.8 1.0]                             //Rounding of the blades. 0 no rounding, 1 full rounding
#define CAMERA_BIAS 0.8 // [0.0 0.2 0.4 0.6 0.8 1.0]                                //Bias of the camera
#define LENS_SHIFT_AMOUNT 0.1 // [0.1 0.2 0.3 0.4 0.5]                              //RGB Shift of the camera's lens
#define LENS_HARDNESS 0.8

//#define FOV_OVERRIDE

// FOV_TARGET is only temporary.
#define FOV_TARGET 90 // [30 31 32 33 34 35 35 36 37 38 39 40 41 42 43 44 45 46 47 48 49 50 51 52 53 54 55 56 57 58 59 60 61 62 63 64 65 66 67 68 69 70 71 72 73 74 75 76 77 78 79 80 81 82 83 84 85 86 87 88 89 90 91 92 93 94 95 96 97 98 99 100 101 102 103 104 105 106 107 108 109 110]

//#define BOKEH_DEBUG

/*
CAMERA_BIAS = Spherical Aberration
LENS_SHIFT_AMOUNT = Axial Chromatic Aberration

*/

#endif
