#if !defined _TONEMAPOVERRIDE_
#define _TONEMAPOVERRIDE_

//#define TONEMAP_OVERRIDE

//TODO: CHange name to LookModificationTransform

//Base LMT has many settings, however if extra steps are wanted we have left
// The LMT open to customization.
// This file has access to all aces color manipulation including
// ASC CDL, Linear Gamma, and an array of HSV modifications for saturaltion, luminance, and hue shifts/rotations
// Color temp modifications from Unreal Engine are included as well.
// As far as splines go we need to build a 5 part spline for
// adjusting your black/white points, shadow and highlight points, and intensities.

// TODO. Viewing library, we need histograms, a lot of them, lets start building bins in the vertex shaders!!
// then we can start visualizing our curves and changes on them in realtime. And getting some readouts on luminance values will be handy.

#define COLOR_GRADE0 0
#define COLOR_GRADE1 1
#define COLOR_GRADE2 2

//#define COLOR_GRADE
#define COLOR_GRADE_TYPE COLOR_GRADE0 //[COLOR_GRADE0]

vec3 LMT(vec3 ACES) { // Out in ACES

    #define SLOPE_R 1.0
    #define SLOPE_G 1.0
    #define SLOPE_B 1.0
    #define SLOPE_M 1.0

    #define OFFSET_R 0.0
    #define OFFSET_G 0.0
    #define OFFSET_B 0.0
    #define OFFSET_M 0.0

    #define POWER_R 1.0
    #define POWER_G 1.0
    #define POWER_B 1.0
    #define POWER_M 1.0

    #define SATURATION 1.0

    #define GAMMA 1.0
    #define GAMMA_PIVOT 0.18 // Should default to 0.18

    #define WHITE_BALANCE 6500 // [4000 4100 4200 4300 4400 4500 4600 4700 4800 4900 5000 5100 5200 5300 5400 5500 5600 5700 5800 5900 6000 6100 6200 6300 6400 6500 6600 6700 6800 6900 7000 7100 7200 7300 7400 7500 7600 7700 7800 7900 8000 8100 8200 8300 8400 8500 8600 8700 8800 8900 9000 9100 9200 9300 9400 9500 9600 9700 9800 9900 10000 10100 10200 10300 10400 10500 10600 10700 10800 10900 11000 11100 11200 11300 11400 11500 11600 11700 11800 11900 12000]
    #define TINT_BALANCE 0.0 // [-1.0 -0.95 -0.9 -0.85 -0.8 -0.75 -0.7 -0.65 -0.6 -0.55 -0.5 -0.45 -0.4 -0.35 -0.3 -0.25 -0.2 -0.15 -0.1 -0.05 0.0 0.05 0.1 0.15 0.2 0.25 0.3 0.35 0.4 0.45 0.5 0.55 0.6 0.65 0.7 0.75 0.8 0.85 0.9 0.95 1.0]

    const vec3 slope  = vec3(SLOPE_R, SLOPE_G, SLOPE_B) * SLOPE_M;
    const vec3 offset = vec3(OFFSET_R, OFFSET_G, OFFSET_B) + OFFSET_M;
    const vec3 power  = vec3(POWER_R, POWER_G, POWER_B) * POWER_M;

    ACES = LMT_ASC_CDL(ACES, slope, offset, power, SATURATION);
    ACES = LMT_Gamma_Adjust_Linear(ACES, GAMMA, GAMMA_PIVOT);

    //#define PFE
    #ifdef PFE
    ACES = scale_C(ACES, 0.7);

    ACES = LMT_ASC_CDL( ACES, vec3(1.0, 1.0, 0.94), vec3(0.0, 0.0, 0.02), vec3(1.0), 1.0);

    ACES = rotate_H_in_H(ACES, 0.0, 30.0, 5.0);
    ACES = rotate_H_in_H(ACES, 80.0, 60.0, -15.0);
    ACES = rotate_H_in_H(ACES, 52.0, 50.0, -14.0);
    ACES = scale_C_at_H(ACES, 45.0, 40.0, 1.4);
    ACES = rotate_H_in_H(ACES, 190.0, 40.0, 30.0);
    ACES = scale_C_at_H(ACES, 240.0, 120.0, 1.4);
    #endif

    #ifdef COLOR_GRADE
        #if COLOR_GRADE_TYPE == COLOR_GRADE0
            ACES = LMT_ASC_CDL( ACES, vec3(1.0, 1.06, 1.12), vec3(0.0, 0.0, 0.0), vec3(1.0, 1.06, 1.15), 1.0);
            ACES = LMT_ASC_CDL( ACES, vec3(1.0) * 0.75, vec3(0.0), vec3(1.0) * 0.7, 1.0);
            ACES = scale_C_at_H(ACES, 240.0, 60.0, 0.95);
            ACES = rotate_H_in_H(ACES, 240.0, 60.0, -2.0);
            ACES = scale_C_at_H(ACES, 80.0, 60.0, 0.9);
            ACES = rotate_H_in_H(ACES, 80.0, 60.0, 3.0);
            ACES = WhiteBalance(ACES, 7000.0, -0.4);
            ACES = rotate_H_in_H(ACES, 50.0, 30.0, -6.0);
            ACES = LMT_Gamma_Adjust_Linear(ACES, 1.15, GAMMA_PIVOT);
        #else
            // More color grade options later
        #endif
    #endif
    
    ACES = WhiteBalance(ACES, float(WHITE_BALANCE), TINT_BALANCE);
    
    return ACES;
}

#endif
