/********************************************************
    © 2020 Continuum Graphics LLC. All Rights Reserved
 ********************************************************/

#include "/../ContinuumLib/Syntax.glsl"

#define Final_glsl 50
#define DynamicShaderStage Final_glsl


varying vec2 texcoord;


/***********************************************************************/
#if defined vsh

uniform mat4 gbufferProjection;
uniform mat4 gbufferProjectionInverse;

uniform float fov;

#include "/../ContinuumLib/Utilities.glsl"

#include "/../ContinuumLib/Uniform/ProjectionMatrices.glsl"

void main() {
    texcoord = gl_Vertex.xy;

    gl_Position = vec4(gl_Vertex.xy * 2.0 - 1.0, 0.0, 1.0);
}

#endif
/***********************************************************************/



/***********************************************************************/
#if defined fsh

#include "/../ContinuumLib/Debug.glsl"

uniform sampler2D colortex4;

uniform float fov;

/* DRAWBUFFERS:0 */
layout (location = 0) out vec4 Buffer0;
#define LAYOUT_0 Buffer0
#include "/../ContinuumLib/Exit.glsl"

#include "/../ContinuumLib/Syntax.glsl"
#include "/../ContinuumLib/Utilities.glsl"

#include "/../ContinuumLib/Uniform/ProjectionMatrices.glsl"

#include "/../ContinuumLib/Fragment/ColorCorrection.glsl"

void main() {
	
    vec3 color = texture(colortex4, texcoord).rgb;

    #ifdef LUT
         color = Lookup(color, colortex7);
    #endif

    Buffer0 = vec4(color, 1.0);
	
	exit();
}

#endif
/***********************************************************************/
