/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customfishing;

import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.ProtocolManager;
import java.util.TimeZone;
import net.momirealms.customfishing.commands.FishingBagCommand;
import net.momirealms.customfishing.commands.MainCommand;
import net.momirealms.customfishing.commands.SellFishCommand;
import net.momirealms.customfishing.helper.LibraryLoader;
import net.momirealms.customfishing.helper.VersionHelper;
import net.momirealms.customfishing.libs.net.kyori.adventure.platform.bukkit.BukkitAudiences;
import net.momirealms.customfishing.libs.org.bstats.bukkit.Metrics;
import net.momirealms.customfishing.manager.BagDataManager;
import net.momirealms.customfishing.manager.BarMechanicManager;
import net.momirealms.customfishing.manager.CompetitionManager;
import net.momirealms.customfishing.manager.ConfigManager;
import net.momirealms.customfishing.manager.DataManager;
import net.momirealms.customfishing.manager.EffectManager;
import net.momirealms.customfishing.manager.FishingManager;
import net.momirealms.customfishing.manager.IntegrationManager;
import net.momirealms.customfishing.manager.LootManager;
import net.momirealms.customfishing.manager.MessageManager;
import net.momirealms.customfishing.manager.OffsetManager;
import net.momirealms.customfishing.manager.SellManager;
import net.momirealms.customfishing.manager.StatisticsManager;
import net.momirealms.customfishing.manager.TotemManager;
import net.momirealms.customfishing.object.Reflection;
import net.momirealms.customfishing.scheduler.Scheduler;
import net.momirealms.customfishing.util.AdventureUtils;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class CustomFishing
extends JavaPlugin {
    private static CustomFishing plugin;
    private static BukkitAudiences adventure;
    private static ProtocolManager protocolManager;
    private IntegrationManager integrationManager;
    private FishingManager fishingManager;
    private CompetitionManager competitionManager;
    private EffectManager effectManager;
    private LootManager lootManager;
    private BarMechanicManager barMechanicManager;
    private BagDataManager bagDataManager;
    private TotemManager totemManager;
    private DataManager dataManager;
    private SellManager sellManager;
    private OffsetManager offsetManager;
    private StatisticsManager statisticsManager;
    private VersionHelper versionHelper;
    private Scheduler scheduler;

    public void onLoad() {
        plugin = this;
        this.loadLibs();
    }

    public void onEnable() {
        adventure = BukkitAudiences.create((Plugin)this);
        protocolManager = ProtocolLibrary.getProtocolManager();
        this.versionHelper = new VersionHelper(this);
        this.fishingManager = new FishingManager(this);
        this.dataManager = new DataManager(this);
        this.statisticsManager = new StatisticsManager(this);
        this.integrationManager = new IntegrationManager(this);
        this.competitionManager = new CompetitionManager(this);
        this.effectManager = new EffectManager(this);
        this.lootManager = new LootManager(this);
        this.barMechanicManager = new BarMechanicManager(this);
        this.totemManager = new TotemManager(this);
        this.sellManager = new SellManager(this);
        this.bagDataManager = new BagDataManager(this);
        this.offsetManager = new OffsetManager(this);
        this.scheduler = new Scheduler(this);
        this.reload();
        this.registerCommands();
        this.registerQuests();
        Reflection.load();
        AdventureUtils.consoleMessage("[CustomFishing] Plugin Enabled!");
        if (ConfigManager.bStats) {
            new Metrics(this, 16648);
        }
        if (ConfigManager.updateChecker) {
            this.versionHelper.checkUpdate();
        }
    }

    public void onDisable() {
        if (this.fishingManager != null) {
            this.fishingManager.unload();
        }
        if (this.integrationManager != null) {
            this.integrationManager.unload();
        }
        if (this.competitionManager != null) {
            this.competitionManager.unload();
        }
        if (this.effectManager != null) {
            this.effectManager.unload();
        }
        if (this.lootManager != null) {
            this.lootManager.unload();
        }
        if (this.barMechanicManager != null) {
            this.barMechanicManager.unload();
        }
        if (this.totemManager != null) {
            this.totemManager.unload();
        }
        if (this.bagDataManager != null) {
            this.bagDataManager.disable();
        }
        if (this.sellManager != null) {
            this.sellManager.disable();
        }
        if (this.statisticsManager != null) {
            this.statisticsManager.disable();
        }
        if (this.dataManager != null) {
            this.dataManager.disable();
        }
        if (this.scheduler != null) {
            this.scheduler.disable();
        }
        if (adventure != null) {
            adventure.close();
        }
    }

    private void registerCommands() {
        MainCommand mainCommand = new MainCommand();
        PluginCommand cfCommand = Bukkit.getPluginCommand((String)"customfishing");
        if (cfCommand != null) {
            cfCommand.setExecutor((CommandExecutor)mainCommand);
            cfCommand.setTabCompleter((TabCompleter)mainCommand);
        }
        FishingBagCommand fishingBagCommand = new FishingBagCommand();
        PluginCommand fbCommand = Bukkit.getPluginCommand((String)"fishingbag");
        if (fbCommand != null) {
            fbCommand.setExecutor((CommandExecutor)fishingBagCommand);
            fbCommand.setTabCompleter((TabCompleter)fishingBagCommand);
        }
        SellFishCommand sellFishCommand = new SellFishCommand();
        PluginCommand sfCommand = Bukkit.getPluginCommand((String)"sellfish");
        if (sfCommand != null) {
            sfCommand.setExecutor((CommandExecutor)sellFishCommand);
            sfCommand.setTabCompleter((TabCompleter)sellFishCommand);
        }
    }

    private void loadLibs() {
        TimeZone timeZone = TimeZone.getDefault();
        String libRepo = timeZone.getID().startsWith("Asia") ? "https://maven.aliyun.com/repository/public/" : "https://repo.maven.apache.org/maven2/";
        LibraryLoader.load("org.apache.commons", "commons-pool2", "2.11.1", libRepo);
        LibraryLoader.load("redis.clients", "jedis", "4.3.2", libRepo);
        LibraryLoader.load("dev.dejvokep", "boosted-yaml", "1.3", libRepo);
        LibraryLoader.load("com.zaxxer", "HikariCP", "5.0.1", libRepo);
        LibraryLoader.load("net.objecthunter", "exp4j", "0.4.8", libRepo);
        LibraryLoader.load("org.mariadb.jdbc", "mariadb-java-client", "3.1.4", libRepo);
        LibraryLoader.load("mysql", "mysql-connector-java", "8.0.30", libRepo);
    }

    private void registerQuests() {
        this.integrationManager.registerQuests();
    }

    public IntegrationManager getIntegrationManager() {
        return this.integrationManager;
    }

    public FishingManager getFishingManager() {
        return this.fishingManager;
    }

    public CompetitionManager getCompetitionManager() {
        return this.competitionManager;
    }

    public EffectManager getEffectManager() {
        return this.effectManager;
    }

    public LootManager getLootManager() {
        return this.lootManager;
    }

    public TotemManager getTotemManager() {
        return this.totemManager;
    }

    public SellManager getSellManager() {
        return this.sellManager;
    }

    public BagDataManager getBagDataManager() {
        return this.bagDataManager;
    }

    public DataManager getDataManager() {
        return this.dataManager;
    }

    public VersionHelper getVersionHelper() {
        return this.versionHelper;
    }

    public BarMechanicManager getBarMechanicManager() {
        return this.barMechanicManager;
    }

    public StatisticsManager getStatisticsManager() {
        return this.statisticsManager;
    }

    public OffsetManager getOffsetManager() {
        return this.offsetManager;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public void reload() {
        ConfigManager.load();
        MessageManager.load();
        this.getDataManager().unload();
        this.getDataManager().load();
        this.getEffectManager().unload();
        this.getEffectManager().load();
        this.getIntegrationManager().unload();
        this.getIntegrationManager().load();
        this.getBarMechanicManager().unload();
        this.getBarMechanicManager().load();
        this.getOffsetManager().unload();
        this.getOffsetManager().load();
        this.getLootManager().unload();
        this.getLootManager().load();
        this.getTotemManager().unload();
        this.getTotemManager().load();
        this.getFishingManager().unload();
        this.getFishingManager().load();
        this.getSellManager().unload();
        this.getSellManager().load();
        this.getCompetitionManager().unload();
        this.getCompetitionManager().load();
        this.getBagDataManager().unload();
        this.getBagDataManager().load();
        this.getStatisticsManager().unload();
        this.getStatisticsManager().load();
        this.getScheduler().reload();
    }

    public static BukkitAudiences getAdventure() {
        return adventure;
    }

    public static ProtocolManager getProtocolManager() {
        return protocolManager;
    }

    public static CustomFishing getInstance() {
        return plugin;
    }
}

