/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customfishing.api;

import java.util.List;
import java.util.UUID;
import net.momirealms.customfishing.CustomFishing;
import net.momirealms.customfishing.fishing.FishingCondition;
import net.momirealms.customfishing.fishing.competition.Competition;
import net.momirealms.customfishing.fishing.loot.DroppedItem;
import net.momirealms.customfishing.fishing.loot.Item;
import net.momirealms.customfishing.fishing.loot.Loot;
import net.momirealms.customfishing.libs.de.tr7zw.changeme.nbtapi.NBTCompound;
import net.momirealms.customfishing.libs.de.tr7zw.changeme.nbtapi.NBTItem;
import net.momirealms.customfishing.manager.ConfigManager;
import net.momirealms.customfishing.util.ItemStackUtils;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomFishingAPI {
    public static CustomFishing getPluginInstance() {
        return CustomFishing.getInstance();
    }

    public static boolean isCompetitionGoingOn() {
        return Competition.getCurrentCompetition() != null;
    }

    @Nullable
    public static Competition getCurrentCompetition() {
        return Competition.getCurrentCompetition();
    }

    public static float getFishSize(ItemStack fish) {
        return CustomFishing.getInstance().getFishingManager().getSize(fish);
    }

    public static double getItemPrice(ItemStack itemStack) {
        return CustomFishing.getInstance().getSellManager().getSingleItemPrice(itemStack);
    }

    public static boolean doesItemExist(String type, String key) {
        return switch (type) {
            case "loot" -> CustomFishing.getInstance().getLootManager().hasLoot(key);
            case "rod" -> {
                if (CustomFishing.getInstance().getEffectManager().getRodItem(key) != null) {
                    yield true;
                }
                yield false;
            }
            case "bait" -> {
                if (CustomFishing.getInstance().getEffectManager().getBaitItem(key) != null) {
                    yield true;
                }
                yield false;
            }
            case "util" -> {
                if (CustomFishing.getInstance().getEffectManager().getUtilItem(key) != null) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    public static boolean isFishingWorld(World world) {
        return ConfigManager.getWorldsList().contains(world.getName());
    }

    public static List<Loot> getLootsAt(Location location, Player player) {
        return CustomFishing.getInstance().getFishingManager().getPossibleLootList(new FishingCondition(location, player, null, null), false, CustomFishing.getInstance().getLootManager().getAllLoots());
    }

    public static List<Loot> getLootsAt(Location location) {
        return CustomFishing.getInstance().getFishingManager().getPossibleLootList(new FishingCondition(location, null, null, null), false, CustomFishing.getInstance().getLootManager().getAllLoots());
    }

    public static Loot getLootByID(String id) {
        return CustomFishing.getInstance().getLootManager().getLoot(id);
    }

    @NotNull
    public static ItemStack getLootItemByID(String id) {
        return CustomFishing.getInstance().getIntegrationManager().build(id);
    }

    @NotNull
    public static ItemStack getLootItemByID(String id, @Nullable Player player) {
        Loot loot = CustomFishing.getInstance().getLootManager().getLoot(id);
        if (!(loot instanceof DroppedItem)) {
            return new ItemStack(Material.AIR);
        }
        DroppedItem droppedItem = (DroppedItem)loot;
        return CustomFishing.getInstance().getFishingManager().getCustomFishingLootItemStack(droppedItem, player);
    }

    public static ItemStack getRodItemByID(String id) {
        Item item = CustomFishing.getInstance().getEffectManager().getRodItem(id);
        return item == null ? null : ItemStackUtils.getFromItem(item);
    }

    public static ItemStack getBaitItemByID(String id) {
        Item item = CustomFishing.getInstance().getEffectManager().getBaitItem(id);
        return item == null ? null : ItemStackUtils.getFromItem(item);
    }

    public static ItemStack getUtilItemByID(String id) {
        Item item = CustomFishing.getInstance().getEffectManager().getUtilItem(id);
        return item == null ? null : ItemStackUtils.getFromItem(item);
    }

    public static int getCertainLootCatchAmount(String id, UUID uuid) {
        return CustomFishing.getInstance().getStatisticsManager().getFishAmount(uuid, id);
    }

    public static boolean isCustomFishingItem(ItemStack itemStack) {
        if (itemStack == null || itemStack.getType() == Material.AIR) {
            return false;
        }
        NBTItem nbtItem = new NBTItem(itemStack);
        NBTCompound nbtCompound = nbtItem.getCompound("CustomFishing");
        return nbtCompound != null;
    }

    public static void addCustomFishingTagToItem(ItemStack itemStack, String type, String id) {
        if (itemStack == null || itemStack.getType() == Material.AIR) {
            return;
        }
        NBTItem nbtItem = new NBTItem(itemStack);
        NBTCompound nbtCompound = nbtItem.addCompound("CustomFishing");
        nbtCompound.setString("type", type);
        nbtCompound.setString("id", id);
        itemStack.setItemMeta(nbtItem.getItem().getItemMeta());
    }

    public static double getTodayEarning(Player player) {
        return CustomFishing.getInstance().getSellManager().getTodayEarning(player);
    }

    public static String getRodID(ItemStack itemStack) {
        if (itemStack == null || itemStack.getType() == Material.AIR) {
            return null;
        }
        NBTItem nbtItem = new NBTItem(itemStack);
        NBTCompound nbtCompound = nbtItem.getCompound("CustomFishing");
        if (nbtCompound == null) {
            return null;
        }
        String type = nbtCompound.getString("type");
        if (!type.equals("rod")) {
            return null;
        }
        return nbtCompound.getString("id");
    }

    public static String getUtilID(ItemStack itemStack) {
        if (itemStack == null || itemStack.getType() == Material.AIR) {
            return null;
        }
        NBTItem nbtItem = new NBTItem(itemStack);
        NBTCompound nbtCompound = nbtItem.getCompound("CustomFishing");
        if (nbtCompound == null) {
            return null;
        }
        String type = nbtCompound.getString("type");
        if (!type.equals("util")) {
            return null;
        }
        return nbtCompound.getString("id");
    }

    public static String getBaitID(ItemStack itemStack) {
        if (itemStack == null || itemStack.getType() == Material.AIR) {
            return null;
        }
        NBTItem nbtItem = new NBTItem(itemStack);
        NBTCompound nbtCompound = nbtItem.getCompound("CustomFishing");
        if (nbtCompound == null) {
            return null;
        }
        String type = nbtCompound.getString("type");
        if (!type.equals("bait")) {
            return null;
        }
        return nbtCompound.getString("id");
    }

    public static String getLootID(ItemStack itemStack) {
        if (itemStack == null || itemStack.getType() == Material.AIR) {
            return null;
        }
        NBTItem nbtItem = new NBTItem(itemStack);
        NBTCompound nbtCompound = nbtItem.getCompound("CustomFishing");
        if (nbtCompound == null) {
            return null;
        }
        String type = nbtCompound.getString("type");
        if (!type.equals("loot")) {
            return null;
        }
        return nbtCompound.getString("id");
    }
}

