/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customfishing.commands.subcmd.item;

import java.util.ArrayList;
import java.util.List;
import net.momirealms.customfishing.CustomFishing;
import net.momirealms.customfishing.commands.AbstractSubCommand;
import net.momirealms.customfishing.manager.MessageManager;
import net.momirealms.customfishing.util.AdventureUtils;
import net.momirealms.customfishing.util.ItemStackUtils;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class RodCommand
extends AbstractSubCommand {
    public static final RodCommand INSTANCE = new RodCommand();

    public RodCommand() {
        super("rod");
        this.regSubCommand(GetCommand.INSTANCE);
        this.regSubCommand(GiveCommand.INSTANCE);
    }

    public static class GetCommand
    extends AbstractSubCommand {
        public static final GetCommand INSTANCE = new GetCommand();

        public GetCommand() {
            super("get");
        }

        @Override
        public boolean onCommand(CommandSender sender, List<String> args) {
            if (super.lackArgs(sender, 1, args.size()) || super.noConsoleExecute(sender) || super.itemNotExist(sender, "rod", args.get(0))) {
                return true;
            }
            if (args.size() == 1) {
                ItemStackUtils.givePlayerRod((Player)sender, args.get(0), 0);
                super.getItemMsg(sender, args.get(0), 1);
            } else {
                if (Integer.parseInt(args.get(1)) < 1) {
                    AdventureUtils.sendMessage(sender, MessageManager.prefix + MessageManager.wrongAmount);
                    return true;
                }
                ItemStackUtils.givePlayerRod((Player)sender, args.get(0), Integer.parseInt(args.get(1)));
                super.getItemMsg(sender, args.get(0), Integer.parseInt(args.get(1)));
            }
            return true;
        }

        @Override
        public List<String> onTabComplete(CommandSender sender, List<String> args) {
            if (args.size() == 1) {
                return this.filterStartingWith(new ArrayList<String>(CustomFishing.getInstance().getEffectManager().getRodItems().keySet()), args.get(0));
            }
            if (args.size() == 2) {
                return this.filterStartingWith(List.of("1", "2", "4", "8", "16", "32", "64"), args.get(1));
            }
            return null;
        }
    }

    public static class GiveCommand
    extends AbstractSubCommand {
        public static final GiveCommand INSTANCE = new GiveCommand();

        public GiveCommand() {
            super("give");
        }

        @Override
        public boolean onCommand(CommandSender sender, List<String> args) {
            if (super.lackArgs(sender, 2, args.size()) || this.playerNotOnline(sender, args.get(0)) || this.itemNotExist(sender, "rod", args.get(1))) {
                return true;
            }
            if (args.size() == 2) {
                ItemStackUtils.givePlayerRod(Bukkit.getPlayer((String)args.get(0)), args.get(1), 0);
                super.giveItemMsg(sender, args.get(0), args.get(1), 1);
            } else if (args.size() == 3) {
                if (Integer.parseInt(args.get(2)) < 1) {
                    AdventureUtils.sendMessage(sender, MessageManager.prefix + MessageManager.wrongAmount);
                    return true;
                }
                ItemStackUtils.givePlayerRod(Bukkit.getPlayer((String)args.get(0)), args.get(1), Integer.parseInt(args.get(2)));
                super.giveItemMsg(sender, args.get(0), args.get(1), Integer.parseInt(args.get(2)));
            }
            return true;
        }

        @Override
        public List<String> onTabComplete(CommandSender sender, List<String> args) {
            if (args.size() == 1) {
                return this.filterStartingWith(this.online_players(), args.get(0));
            }
            if (args.size() == 2) {
                return this.filterStartingWith(new ArrayList<String>(CustomFishing.getInstance().getEffectManager().getRodItems().keySet()), args.get(1));
            }
            if (args.size() == 3) {
                return this.filterStartingWith(List.of("1", "2", "4", "8", "16", "32", "64"), args.get(2));
            }
            return null;
        }
    }
}

