/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customfishing.fishing;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import net.momirealms.customfishing.CustomFishing;
import net.momirealms.customfishing.fishing.Effect;
import net.momirealms.customfishing.fishing.FishingCondition;
import net.momirealms.customfishing.fishing.LavaEffect;
import net.momirealms.customfishing.fishing.loot.Loot;
import net.momirealms.customfishing.libs.net.kyori.adventure.key.Key;
import net.momirealms.customfishing.libs.net.kyori.adventure.sound.Sound;
import net.momirealms.customfishing.manager.ConfigManager;
import net.momirealms.customfishing.manager.FishingManager;
import net.momirealms.customfishing.util.AdventureUtils;
import net.momirealms.customfishing.util.ArmorStandUtils;
import net.momirealms.customfishing.util.FakeItemUtils;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.FishHook;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class BobberCheckTask
implements Runnable {
    private final ScheduledFuture<?> bobberTask;
    private final FishHook fishHook;
    private final CustomFishing plugin;
    private int timer;
    private final Player player;
    private final Effect effect;
    private final FishingManager fishingManager;
    private boolean hooked;
    private boolean reserve;
    private int jump_timer;
    private final int lureLevel;
    private ScheduledFuture<?> getHookedTask;
    private ScheduledFuture<?> resetTask;
    private LavaEffect lavaEffect;
    private ArmorStand hookedEntity;
    private final int entityID;
    private boolean land;
    private boolean first;
    private final String rod;
    private final String bait;

    public BobberCheckTask(CustomFishing plugin, Player player, Effect effect, FishHook fishHook, FishingManager fishingManager, int lureLevel, int entityID, String rod, String bait) {
        this.fishHook = fishHook;
        this.plugin = plugin;
        this.fishingManager = fishingManager;
        this.player = player;
        this.timer = 0;
        this.effect = effect;
        this.reserve = true;
        this.jump_timer = 0;
        this.lureLevel = lureLevel;
        this.entityID = entityID;
        this.land = false;
        this.first = true;
        this.rod = rod;
        this.bait = bait;
        this.bobberTask = plugin.getScheduler().runTaskTimer(this, 50L, 50L, TimeUnit.MILLISECONDS);
    }

    @Override
    public void run() {
        ++this.timer;
        if (!this.land && this.entityID != 0) {
            CustomFishing.getProtocolManager().sendServerPacket(this.player, FakeItemUtils.getVelocity(this.entityID, this.fishHook.getVelocity()));
            CustomFishing.getProtocolManager().sendServerPacket(this.player, FakeItemUtils.getTpPacket(this.entityID, this.fishHook.getLocation()));
        }
        if (this.timer > 3600) {
            this.stop();
            return;
        }
        if (this.fishHook.getHookedEntity() != null && this.fishHook.getHookedEntity().getType() != EntityType.ARMOR_STAND) {
            this.stop();
            return;
        }
        if (!this.fishHook.isValid()) {
            this.stop();
            return;
        }
        if (this.fishHook.getLocation().getBlock().getType() == Material.LAVA) {
            this.land = true;
            if (!this.effect.canLavaFishing()) {
                this.stop();
                return;
            }
            if (this.first) {
                this.sendRemovePacket();
                ArmorStandUtils.sendAnimationToPlayer(this.fishHook.getLocation(), this.player, ConfigManager.lava_item, ConfigManager.lava_time);
                this.first = false;
            }
            if (this.hooked) {
                ++this.jump_timer;
                if (this.jump_timer < 4) {
                    return;
                }
                this.jump_timer = 0;
                this.fishHook.setVelocity(new Vector(0.0, 0.24, 0.0));
                return;
            }
            if (this.reserve) {
                if (this.jump_timer < 5) {
                    ++this.jump_timer;
                    this.fishHook.setVelocity(new Vector(0.0, 0.2 - (double)this.jump_timer * 0.02, 0.0));
                    return;
                }
                this.reserve = false;
                this.randomTime();
                if (this.plugin.getVersionHelper().isFolia()) {
                    this.plugin.getScheduler().runTask(() -> this.spawnArmorStand(this.fishHook.getLocation()), this.fishHook.getLocation());
                } else {
                    this.spawnArmorStand(this.fishHook.getLocation());
                }
            }
            return;
        }
        if (this.fishHook.isInWater()) {
            this.stop();
            this.plugin.getScheduler().runTaskAsync(() -> {
                List<Loot> possibleLoots = new ArrayList<Loot>();
                if (!ConfigManager.needRodForLoot || this.effect.hasSpecialRod()) {
                    possibleLoots = this.fishingManager.getPossibleLootList(new FishingCondition(this.fishHook.getLocation(), this.player, this.rod, this.bait), false, this.plugin.getLootManager().getWaterLoots().values());
                }
                this.fishingManager.getNextLoot(this.player, this.effect, possibleLoots);
                if (ConfigManager.enableWaterAnimation) {
                    ArmorStandUtils.sendAnimationToPlayer(this.fishHook.getLocation(), this.player, ConfigManager.water_item, ConfigManager.water_time);
                }
            });
            return;
        }
        if (this.fishHook.isOnGround()) {
            this.stop();
        }
    }

    public void stop() {
        this.bobberTask.cancel(false);
        this.cancelSubTask();
        this.fishingManager.removePlayerFromLavaFishing(this.player);
        if (this.hookedEntity != null && !this.hookedEntity.isDead()) {
            if (this.plugin.getVersionHelper().isFolia()) {
                this.plugin.getScheduler().runTask(() -> {
                    this.hookedEntity.remove();
                    this.hookedEntity = null;
                }, this.hookedEntity.getLocation());
            } else {
                this.hookedEntity.remove();
                this.hookedEntity = null;
            }
        }
        this.sendRemovePacket();
    }

    private void sendRemovePacket() {
        if (this.entityID == 0) {
            return;
        }
        CustomFishing.getProtocolManager().sendServerPacket(this.player, FakeItemUtils.getDestroyPacket(this.entityID));
    }

    public void cancelSubTask() {
        if (this.getHookedTask != null && !this.lavaEffect.isCancelled()) {
            this.getHookedTask.cancel(false);
            this.getHookedTask = null;
        }
        if (this.resetTask != null && !this.lavaEffect.isCancelled()) {
            this.resetTask.cancel(false);
            this.resetTask = null;
        }
        if (this.lavaEffect != null && !this.lavaEffect.isCancelled()) {
            this.lavaEffect.cancel();
            this.lavaEffect = null;
        }
    }

    private void randomTime() {
        this.plugin.getScheduler().runTaskAsync(() -> {
            List<Loot> possibleLoots = new ArrayList<Loot>();
            if (!ConfigManager.needRodForLoot || this.effect.hasSpecialRod()) {
                possibleLoots = this.fishingManager.getPossibleLootList(new FishingCondition(this.fishHook.getLocation(), this.player, this.rod, this.bait), false, this.plugin.getLootManager().getLavaLoots().values());
            }
            this.fishingManager.getNextLoot(this.player, this.effect, possibleLoots);
        });
        this.cancelSubTask();
        int random = new Random().nextInt(ConfigManager.lavaMaxTime) + ConfigManager.lavaMinTime;
        random -= this.lureLevel * 100;
        random = (int)((double)random * this.effect.getTimeModifier());
        if (random < ConfigManager.lavaMinTime) {
            random = ConfigManager.lavaMinTime;
        }
        this.getHookedTask = this.plugin.getScheduler().runTaskLater(() -> {
            this.hooked = true;
            if (this.hookedEntity != null && !this.hookedEntity.isDead()) {
                if (this.plugin.getVersionHelper().isFolia()) {
                    this.plugin.getScheduler().runTask(() -> this.hookedEntity.remove(), this.hookedEntity.getLocation());
                } else {
                    this.hookedEntity.remove();
                }
            }
            AdventureUtils.playerSound(this.player, Sound.Source.NEUTRAL, Key.key("minecraft:block.pointed_dripstone.drip_lava_into_cauldron"), 1.0f, 1.0f);
            if (ConfigManager.instantBar) {
                this.fishingManager.showBar(this.player);
            }
        }, (long)random * 50L, TimeUnit.MILLISECONDS);
        this.resetTask = this.plugin.getScheduler().runTaskAsyncLater(() -> {
            this.hooked = false;
            this.reserve = true;
        }, (long)(random + 40) * 50L, TimeUnit.MILLISECONDS);
        this.lavaEffect = new LavaEffect(this.fishHook.getLocation(), random - 60);
    }

    private void spawnArmorStand(Location armorLoc) {
        armorLoc.setY((double)armorLoc.getBlockY() + 0.2);
        if (this.hookedEntity != null && !this.hookedEntity.isDead()) {
            this.hookedEntity.remove();
        }
        this.hookedEntity = (ArmorStand)armorLoc.getWorld().spawn(armorLoc, ArmorStand.class, a -> {
            a.setInvisible(true);
            a.setCollidable(false);
            a.setInvulnerable(true);
            a.setVisible(false);
            a.setCustomNameVisible(false);
            a.setSmall(true);
            a.setGravity(false);
        });
        this.fishHook.setHookedEntity((Entity)this.hookedEntity);
    }

    public boolean isHooked() {
        return this.hooked;
    }
}

