/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customfishing.fishing;

import java.util.HashMap;
import net.momirealms.customfishing.CustomFishing;
import net.momirealms.customfishing.fishing.requirements.CustomPapi;
import net.momirealms.customfishing.integration.papi.PlaceholderManager;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;

public class FishingCondition {
    private final Location location;
    private final Player player;
    private final String rodID;
    private final String baitID;
    private final HashMap<String, String> papiMap;

    public FishingCondition(Location location, Player player, @Nullable String rodID, @Nullable String baitID) {
        this.location = location;
        this.player = player;
        this.rodID = rodID;
        this.baitID = baitID;
        this.papiMap = new HashMap();
        if (player != null) {
            PlaceholderManager placeholderManager = CustomFishing.getInstance().getIntegrationManager().getPlaceholderManager();
            for (String papi : CustomPapi.allPapi) {
                this.papiMap.put(papi, placeholderManager.parse((OfflinePlayer)player, papi));
            }
        }
    }

    public HashMap<String, String> getPapiMap() {
        return this.papiMap;
    }

    public Location getLocation() {
        return this.location;
    }

    public Player getPlayer() {
        return this.player;
    }

    public String getRodID() {
        return this.rodID;
    }

    public String getBaitID() {
        return this.baitID;
    }

    public String toString() {
        return "FishingCondition{location=" + this.location + ", player=" + this.player + ", papiMap=" + this.papiMap + "}";
    }
}

