/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customfishing.fishing.competition;

import java.time.LocalTime;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import net.momirealms.customfishing.CustomFishing;
import net.momirealms.customfishing.fishing.competition.Competition;
import net.momirealms.customfishing.fishing.competition.CompetitionConfig;
import net.momirealms.customfishing.object.Function;

public class CompetitionSchedule
extends Function {
    private ScheduledFuture<?> checkTimeTask;
    private int doubleCheckTime;

    @Override
    public void load() {
        this.checkTime();
    }

    @Override
    public void unload() {
        this.stopCheck();
        CompetitionSchedule.cancelCompetition();
    }

    public static boolean startCompetition(String competitionName) {
        CompetitionConfig competitionConfig = CustomFishing.getInstance().getCompetitionManager().getCompetitionsC().get(competitionName);
        if (competitionConfig == null) {
            return false;
        }
        if (Competition.currentCompetition != null) {
            Competition.currentCompetition.end();
        }
        Competition.currentCompetition = new Competition(competitionConfig);
        Competition.currentCompetition.begin(true);
        return true;
    }

    public static void cancelCompetition() {
        if (Competition.currentCompetition != null) {
            Competition.currentCompetition.cancel();
        }
    }

    public static void endCompetition() {
        if (Competition.currentCompetition != null) {
            Competition.currentCompetition.end();
        }
    }

    public void startCompetition(CompetitionConfig competitionConfig) {
        if (Competition.currentCompetition != null) {
            Competition.currentCompetition.end();
        }
        Competition.currentCompetition = new Competition(competitionConfig);
        Competition.currentCompetition.begin(false);
    }

    public void checkTime() {
        this.checkTimeTask = CustomFishing.getInstance().getScheduler().runTaskTimerAsync(() -> {
            CompetitionConfig competitionConfig;
            if (this.isANewMinute() && (competitionConfig = CustomFishing.getInstance().getCompetitionManager().getCompetitionsT().get(this.getCurrentTime())) != null && competitionConfig.canStart()) {
                this.startCompetition(competitionConfig);
            }
        }, 1L, 1L, TimeUnit.SECONDS);
    }

    public void stopCheck() {
        if (this.checkTimeTask != null && !this.checkTimeTask.isCancelled()) {
            this.checkTimeTask.cancel(false);
        }
    }

    public String getCurrentTime() {
        return LocalTime.now().getHour() + ":" + String.format("%02d", LocalTime.now().getMinute());
    }

    private boolean isANewMinute() {
        int minute = LocalTime.now().getMinute();
        if (this.doubleCheckTime != minute) {
            this.doubleCheckTime = minute;
            return true;
        }
        return false;
    }
}

