/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customfishing.fishing.competition.bossbar;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.events.InternalStructure;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import java.lang.reflect.InvocationTargetException;
import java.util.UUID;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import net.momirealms.customfishing.CustomFishing;
import net.momirealms.customfishing.fishing.competition.Competition;
import net.momirealms.customfishing.fishing.competition.bossbar.BossBarConfig;
import net.momirealms.customfishing.fishing.competition.bossbar.BossBarOverlay;
import net.momirealms.customfishing.libs.net.kyori.adventure.text.minimessage.MiniMessage;
import net.momirealms.customfishing.libs.net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.momirealms.customfishing.object.DynamicText;
import net.momirealms.customfishing.object.Reflection;
import net.momirealms.customfishing.util.AdventureUtils;
import org.bukkit.boss.BarColor;
import org.bukkit.entity.Player;

public class BossBarSender {
    private final Player player;
    private int timer_1;
    private int timer_2;
    private int counter;
    private final int size;
    private final DynamicText[] texts;
    private DynamicText text;
    private ScheduledFuture<?> senderTask;
    private final UUID uuid;
    private boolean force;
    private final BossBarConfig config;
    private boolean isShown;
    private boolean hasClaimedJoin;

    public void setText(int position) {
        this.text = this.texts[position];
        this.force = true;
    }

    public BossBarSender(Player player, BossBarConfig config) {
        String[] str = config.getText();
        this.size = str.length;
        this.texts = new DynamicText[str.length];
        for (int i = 0; i < str.length; ++i) {
            this.texts[i] = new DynamicText(player, str[i]);
        }
        this.text = this.texts[0];
        this.player = player;
        this.uuid = UUID.randomUUID();
        this.config = config;
        this.isShown = false;
    }

    public void show() {
        this.isShown = true;
        CustomFishing.getProtocolManager().sendServerPacket(this.player, this.getCreatePacket());
        this.senderTask = CustomFishing.getInstance().getScheduler().runTaskTimerAsync(() -> {
            if (this.size != 1) {
                ++this.timer_2;
                if (this.timer_2 > this.config.getInterval()) {
                    this.timer_2 = 0;
                    ++this.counter;
                    if (this.counter == this.size) {
                        this.counter = 0;
                    }
                    this.setText(this.counter);
                }
            }
            if (this.timer_1 < this.config.getRate()) {
                ++this.timer_1;
            } else {
                this.timer_1 = 0;
                if (this.text.update() || this.force) {
                    this.force = false;
                    CustomFishing.getProtocolManager().sendServerPacket(this.player, this.getUpdatePacket());
                    CustomFishing.getProtocolManager().sendServerPacket(this.player, this.getProgressPacket());
                }
            }
        }, 50L, 50L, TimeUnit.MILLISECONDS);
    }

    public boolean isVisible() {
        return this.isShown;
    }

    public BossBarConfig getConfig() {
        return this.config;
    }

    public void hide() {
        this.sendRemovePacket();
        if (this.senderTask != null && !this.senderTask.isCancelled()) {
            this.senderTask.cancel(false);
        }
        this.isShown = false;
    }

    private PacketContainer getUpdatePacket() {
        PacketContainer packet = new PacketContainer(PacketType.Play.Server.BOSS);
        packet.getModifier().write(0, (Object)this.uuid);
        try {
            Object chatComponent = Reflection.iChatComponentMethod.invoke(null, GsonComponentSerializer.gson().serialize(MiniMessage.miniMessage().deserialize(AdventureUtils.replaceLegacy(this.text.getLatestValue()))));
            Object updatePacket = Reflection.updateConstructor.newInstance(chatComponent);
            packet.getModifier().write(1, updatePacket);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    private PacketContainer getProgressPacket() {
        PacketContainer packet = new PacketContainer(PacketType.Play.Server.BOSS);
        packet.getModifier().write(0, (Object)this.uuid);
        try {
            Object updatePacket = Reflection.progressConstructor.newInstance(Float.valueOf(Competition.currentCompetition.getProgress()));
            packet.getModifier().write(1, updatePacket);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    private PacketContainer getCreatePacket() {
        PacketContainer packet = new PacketContainer(PacketType.Play.Server.BOSS);
        packet.getModifier().write(0, (Object)this.uuid);
        InternalStructure internalStructure = (InternalStructure)packet.getStructures().read(1);
        internalStructure.getChatComponents().write(0, (Object)WrappedChatComponent.fromJson((String)((String)GsonComponentSerializer.gson().serialize(MiniMessage.miniMessage().deserialize(this.text.getLatestValue())))));
        internalStructure.getFloat().write(0, (Object)Float.valueOf(Competition.currentCompetition.getProgress()));
        internalStructure.getEnumModifier(BarColor.class, 2).write(0, (Object)this.config.getColor());
        internalStructure.getEnumModifier(BossBarOverlay.class, 3).write(0, (Object)this.config.getOverlay());
        internalStructure.getModifier().write(4, (Object)false);
        internalStructure.getModifier().write(5, (Object)false);
        internalStructure.getModifier().write(6, (Object)false);
        return packet;
    }

    private void sendRemovePacket() {
        PacketContainer packet = new PacketContainer(PacketType.Play.Server.BOSS);
        packet.getModifier().write(0, (Object)this.uuid);
        packet.getModifier().write(1, Reflection.removeBossBarPacket);
        CustomFishing.getProtocolManager().sendServerPacket(this.player, packet);
    }

    public boolean hasClaimedJoin() {
        return this.hasClaimedJoin;
    }

    public void setHasClaimedJoinReward(boolean hasClaimedJoin) {
        this.hasClaimedJoin = hasClaimedJoin;
    }
}

