/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customfishing.fishing.loot;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.momirealms.customfishing.object.LeveledEnchantment;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemFlag;

public class Item {
    private final String key;
    private final int amount;
    private final Material material;
    private String name;
    private List<String> lore;
    private List<ItemFlag> itemFlags;
    private int customModelData;
    private boolean unbreakable;
    private String head64;
    private List<LeveledEnchantment> enchantment;
    private Map<String, Object> nbt;
    private String totem;
    private boolean headStackable;
    private String[] cfTag;

    public Item(Material material, String key) {
        this.material = material;
        this.key = key;
        this.amount = 1;
    }

    public Item(ConfigurationSection section, String key) {
        this.key = key;
        this.material = Material.valueOf((String)section.getString("material", "cod").toUpperCase());
        this.amount = section.getInt("amount", 1);
        this.setUnbreakable(section.getBoolean("unbreakable", false));
        if (section.contains("display.lore")) {
            this.setLore(section.getStringList("display.lore"));
        }
        if (section.contains("display.name")) {
            this.setName(section.getString("display.name"));
        }
        if (section.contains("custom-model-data")) {
            this.setCustomModelData(section.getInt("custom-model-data"));
        }
        if (section.contains("enchantments")) {
            ArrayList<LeveledEnchantment> enchantmentList = new ArrayList<LeveledEnchantment>();
            Objects.requireNonNull(section.getConfigurationSection("enchantments")).getKeys(false).forEach(enchant -> {
                LeveledEnchantment leveledEnchantment = new LeveledEnchantment(NamespacedKey.fromString((String)enchant), section.getInt("enchantments." + enchant), 1.0);
                enchantmentList.add(leveledEnchantment);
            });
            this.setEnchantment(enchantmentList);
        }
        if (section.contains("item_flags")) {
            ArrayList<ItemFlag> itemFlags = new ArrayList<ItemFlag>();
            section.getStringList("item_flags").forEach(flag -> itemFlags.add(ItemFlag.valueOf((String)flag)));
            this.setItemFlags(itemFlags);
        }
        if (section.contains("nbt")) {
            ConfigurationSection nbtSection = section.getConfigurationSection(".nbt");
            if (nbtSection == null) {
                return;
            }
            this.setNbt(nbtSection.getValues(false));
        }
        if (section.contains("head64")) {
            this.setHead64(section.getString("head64"));
            this.setHeadStackable(section.getBoolean("head-stackable", false));
        }
        if (section.contains("totem")) {
            this.setTotem(section.getString("totem"));
        }
    }

    public Material getMaterial() {
        return this.material;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<String> getLore() {
        return this.lore;
    }

    public void setLore(List<String> lore) {
        this.lore = lore;
    }

    public List<ItemFlag> getItemFlags() {
        return this.itemFlags;
    }

    public void setItemFlags(List<ItemFlag> itemFlags) {
        this.itemFlags = itemFlags;
    }

    public int getCustomModelData() {
        return this.customModelData;
    }

    public void setCustomModelData(int customModelData) {
        this.customModelData = customModelData;
    }

    public boolean isUnbreakable() {
        return this.unbreakable;
    }

    public void setUnbreakable(boolean unbreakable) {
        this.unbreakable = unbreakable;
    }

    public List<LeveledEnchantment> getEnchantment() {
        return this.enchantment;
    }

    public void setEnchantment(List<LeveledEnchantment> enchantment) {
        this.enchantment = enchantment;
    }

    public Map<String, Object> getNbt() {
        return this.nbt;
    }

    public void setNbt(Map<String, Object> nbt) {
        this.nbt = nbt;
    }

    public String getHead64() {
        return this.head64;
    }

    public void setHead64(String head64) {
        this.head64 = head64;
    }

    public String getKey() {
        return this.key;
    }

    public int getAmount() {
        return this.amount;
    }

    public String getTotem() {
        return this.totem;
    }

    public void setTotem(String totem) {
        this.totem = totem;
    }

    public boolean isHeadStackable() {
        return this.headStackable;
    }

    public void setHeadStackable(boolean headStackable) {
        this.headStackable = headStackable;
    }

    public String[] getCfTag() {
        return this.cfTag;
    }

    public void setCfTag(String[] cfTag) {
        this.cfTag = cfTag;
    }

    public Item cloneWithPrice(double price) {
        Item newItem = new Item(this.material, this.key);
        if (this.lore != null) {
            ArrayList<String> lore = new ArrayList<String>();
            for (String text : this.lore) {
                lore.add(text.replace("{money}", String.format("%.2f", price)));
            }
            newItem.setLore(lore);
        }
        if (this.name != null) {
            newItem.setName(this.name.replace("{money}", String.format("%.2f", price)));
        }
        newItem.setCustomModelData(this.customModelData);
        return newItem;
    }
}

