/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customfishing.fishing.mode;

import java.util.concurrent.ScheduledFuture;
import net.momirealms.customfishing.CustomFishing;
import net.momirealms.customfishing.fishing.bar.FishingBar;
import net.momirealms.customfishing.manager.FishingManager;
import net.momirealms.customfishing.manager.MessageManager;
import net.momirealms.customfishing.manager.OffsetManager;
import net.momirealms.customfishing.util.AdventureUtils;
import org.bukkit.Material;
import org.bukkit.entity.FishHook;
import org.bukkit.entity.Player;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.potion.PotionEffectType;

public abstract class FishingGame
implements Runnable {
    protected OffsetManager offsetManager;
    protected long deadline;
    protected FishingManager fishingManager;
    protected CustomFishing plugin;
    protected Player player;
    protected int difficulty;
    protected String title;
    protected FishHook fishHook;
    protected ScheduledFuture<?> gameTask;

    public FishingGame(CustomFishing plugin, FishingManager fishingManager, long deadline, Player player, int difficulty, FishingBar fishingBar) {
        this.offsetManager = plugin.getOffsetManager();
        this.fishingManager = fishingManager;
        this.player = player;
        this.deadline = deadline;
        this.difficulty = difficulty;
        this.title = fishingBar.getRandomTitle();
        this.fishHook = fishingManager.getHook(player.getUniqueId());
    }

    @Override
    public void run() {
        this.timeOutCheck();
        this.switchItemCheck();
        this.invalidHookCheck();
    }

    public void showBar() {
    }

    public boolean isSuccess() {
        return false;
    }

    protected void timeOutCheck() {
        if (System.currentTimeMillis() > this.deadline) {
            AdventureUtils.playerMessage(this.player, MessageManager.prefix + MessageManager.escape);
            this.cancel();
            this.fishingManager.removeFishingPlayer(this.player);
            this.fishingManager.removeHook(this.player.getUniqueId());
            this.fishingManager.fail(this.player, null, true);
        }
    }

    protected void switchItemCheck() {
        PlayerInventory playerInventory = this.player.getInventory();
        if (playerInventory.getItemInMainHand().getType() != Material.FISHING_ROD && playerInventory.getItemInOffHand().getType() != Material.FISHING_ROD) {
            this.cancel();
            this.fishingManager.removeFishingPlayer(this.player);
            this.player.removePotionEffect(PotionEffectType.SLOW);
        }
    }

    protected void invalidHookCheck() {
        if (this.fishHook == null || !this.fishHook.isValid()) {
            this.cancel();
            this.fishingManager.removeFishingPlayer(this.player);
            this.player.removePotionEffect(PotionEffectType.SLOW);
        }
    }

    public void cancel() {
        if (!this.gameTask.isCancelled()) {
            this.gameTask.cancel(false);
        }
    }
}

