/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customfishing.fishing.requirements;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.momirealms.customfishing.fishing.FishingCondition;
import net.momirealms.customfishing.fishing.requirements.Requirement;
import net.momirealms.customfishing.fishing.requirements.RequirementInterface;
import net.momirealms.customfishing.fishing.requirements.papi.ExpressionAnd;
import net.momirealms.customfishing.fishing.requirements.papi.ExpressionOr;
import net.momirealms.customfishing.fishing.requirements.papi.PapiEquals;
import net.momirealms.customfishing.fishing.requirements.papi.PapiGreater;
import net.momirealms.customfishing.fishing.requirements.papi.PapiNoLarger;
import net.momirealms.customfishing.fishing.requirements.papi.PapiNoLess;
import net.momirealms.customfishing.fishing.requirements.papi.PapiNotEquals;
import net.momirealms.customfishing.fishing.requirements.papi.PapiRequirement;
import net.momirealms.customfishing.fishing.requirements.papi.PapiSmaller;
import org.bukkit.configuration.MemorySection;
import org.bukkit.entity.Player;

public class CustomPapi
extends Requirement
implements RequirementInterface {
    public static HashSet<String> allPapi = new HashSet();
    private final List<PapiRequirement> papiRequirement;

    public CustomPapi(String[] msg, Map<String, Object> expressions) {
        super(msg);
        this.papiRequirement = this.getRequirements(expressions);
    }

    @Override
    public boolean isConditionMet(FishingCondition fishingCondition) {
        Player player = fishingCondition.getPlayer();
        if (fishingCondition.getPlayer() == null) {
            return true;
        }
        HashMap<String, String> papiMap = fishingCondition.getPapiMap();
        for (PapiRequirement requirement : this.papiRequirement) {
            if (requirement.isMet(papiMap, player)) continue;
            this.notMetMessage(player);
            return false;
        }
        return true;
    }

    private List<PapiRequirement> getRequirements(Map<String, Object> map) {
        ArrayList<PapiRequirement> papiRequirements = new ArrayList<PapiRequirement>();
        map.keySet().forEach(key -> {
            if (key.startsWith("&&")) {
                Object patt2096$temp = map.get(key);
                if (patt2096$temp instanceof MemorySection) {
                    MemorySection map2 = (MemorySection)patt2096$temp;
                    papiRequirements.add(new ExpressionAnd(this.getRequirements(map2.getValues(false))));
                }
            } else if (key.startsWith("||")) {
                Object patt2328$temp = map.get(key);
                if (patt2328$temp instanceof MemorySection) {
                    MemorySection map2 = (MemorySection)patt2328$temp;
                    papiRequirements.add(new ExpressionOr(this.getRequirements(map2.getValues(false))));
                }
            } else {
                Object patt2533$temp = map.get(key);
                if (patt2533$temp instanceof MemorySection) {
                    MemorySection map2 = (MemorySection)patt2533$temp;
                    String type = map2.getString("type");
                    String papi = map2.getString("papi");
                    String value = map2.getString("value");
                    if (value == null || papi == null || type == null) {
                        return;
                    }
                    allPapi.add(papi);
                    switch (type) {
                        case "==": {
                            papiRequirements.add(new PapiEquals(papi, value));
                            break;
                        }
                        case "!=": {
                            papiRequirements.add(new PapiNotEquals(papi, value));
                            break;
                        }
                        case ">=": {
                            papiRequirements.add(new PapiNoLess(papi, value));
                            break;
                        }
                        case "<=": {
                            papiRequirements.add(new PapiNoLarger(papi, value));
                            break;
                        }
                        case "<": {
                            papiRequirements.add(new PapiSmaller(papi, value));
                            break;
                        }
                        case ">": {
                            papiRequirements.add(new PapiGreater(papi, value));
                        }
                    }
                }
            }
        });
        return papiRequirements;
    }
}

