/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customfishing.fishing.totem;

import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import net.momirealms.customfishing.CustomFishing;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.World;

public class TotemParticle
implements Runnable {
    private final Location bottomLoc;
    private final int radius;
    private final double angle_1;
    private final double angle_2;
    private int timer;
    private final Particle particle;
    private final World world;
    private final ScheduledFuture<?> task;

    public TotemParticle(Location bottomLoc, int radius, Particle particle) {
        this.bottomLoc = bottomLoc.clone().add(0.5, 0.0, 0.5);
        this.radius = radius;
        this.particle = particle;
        this.angle_1 = 360.0 / (double)radius;
        this.angle_2 = 72.0 / (double)radius;
        this.world = bottomLoc.getWorld();
        this.task = CustomFishing.getInstance().getScheduler().runTaskTimerAsync(this, 200L, 200L, TimeUnit.MILLISECONDS);
    }

    @Override
    public void run() {
        ++this.timer;
        if (this.timer > 4) {
            this.timer = 0;
        }
        for (int i = 0; i < this.radius; ++i) {
            double temp_angle = this.angle_1 * (double)i + this.angle_2 * (double)this.timer;
            double angle = temp_angle * Math.PI / 180.0;
            this.world.spawnParticle(this.particle, this.bottomLoc.clone().add(Math.cos(angle) * (double)this.radius, 0.5, Math.sin(angle) * (double)this.radius), 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public void cancel() {
        this.task.cancel(false);
    }

    public boolean isCancelled() {
        return this.task.isCancelled();
    }
}

