/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customfishing.integration.block;

import dev.lone.itemsadder.api.CustomBlock;
import net.momirealms.customfishing.CustomFishing;
import net.momirealms.customfishing.integration.BlockInterface;
import net.momirealms.customfishing.util.AdventureUtils;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.jetbrains.annotations.Nullable;

public class ItemsAdderBlockImpl
implements BlockInterface {
    @Override
    public void removeBlock(Block block) {
        if (CustomBlock.byAlreadyPlaced((Block)block) != null) {
            CustomBlock.remove((Location)block.getLocation());
        } else {
            block.setType(Material.AIR);
        }
    }

    @Override
    public void placeBlock(String id, Location location) {
        String blockID = CustomFishing.getInstance().getTotemManager().getInvertedBlock(id);
        if (blockID == null) {
            AdventureUtils.consoleMessage(id + " does not exist in default.yml");
            return;
        }
        if (BlockInterface.isVanillaItem(blockID)) {
            BlockInterface.placeVanillaBlock(blockID, location);
        } else {
            CustomBlock.place((String)blockID, (Location)location);
        }
    }

    @Override
    @Nullable
    public String getID(Block block) {
        CustomBlock customBlock = CustomBlock.byAlreadyPlaced((Block)block);
        String id = customBlock == null ? block.getType().name() : customBlock.getNamespacedID();
        return CustomFishing.getInstance().getTotemManager().getBlockID(id);
    }
}

