/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customfishing.integration.papi;

import java.util.Optional;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import net.momirealms.customfishing.fishing.competition.Competition;
import net.momirealms.customfishing.fishing.competition.ranking.RankingInterface;
import net.momirealms.customfishing.manager.MessageManager;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompetitionPapi
extends PlaceholderExpansion {
    @NotNull
    public String getIdentifier() {
        return "competition";
    }

    @NotNull
    public String getAuthor() {
        return "XiaoMoMi";
    }

    @NotNull
    public String getVersion() {
        return "1.3";
    }

    public boolean persist() {
        return true;
    }

    @Nullable
    public String onPlaceholderRequest(Player player, @NotNull String params) {
        if (Competition.currentCompetition == null) {
            return "";
        }
        RankingInterface ranking = Competition.currentCompetition.getRanking();
        switch (params) {
            case "rank": {
                return Competition.currentCompetition.getPlayerRank((OfflinePlayer)player);
            }
            case "score": {
                return String.format("%.1f", Competition.currentCompetition.getScore((OfflinePlayer)player));
            }
            case "time": {
                return String.valueOf(Competition.currentCompetition.getRemainingTime());
            }
            case "minute": {
                return String.format("%02d", Competition.currentCompetition.getRemainingTime() / 60L);
            }
            case "second": {
                return String.format("%02d", Competition.currentCompetition.getRemainingTime() % 60L);
            }
            case "goal": {
                return Competition.currentCompetition.getGoal().getDisplay();
            }
            case "1st_score": {
                return ranking.getScoreAt(1) <= 0.0f ? MessageManager.noScore : String.format("%.1f", Float.valueOf(ranking.getScoreAt(1)));
            }
            case "1st_player": {
                return Optional.ofNullable(ranking.getPlayerAt(1)).orElse(MessageManager.noPlayer);
            }
            case "2nd_score": {
                return ranking.getScoreAt(2) <= 0.0f ? MessageManager.noScore : String.format("%.1f", Float.valueOf(ranking.getScoreAt(2)));
            }
            case "2nd_player": {
                return Optional.ofNullable(ranking.getPlayerAt(2)).orElse(MessageManager.noPlayer);
            }
            case "3rd_score": {
                return ranking.getScoreAt(3) <= 0.0f ? MessageManager.noScore : String.format("%.1f", Float.valueOf(ranking.getScoreAt(3)));
            }
            case "3rd_player": {
                return Optional.ofNullable(ranking.getPlayerAt(3)).orElse(MessageManager.noPlayer);
            }
        }
        return "null";
    }
}

