/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customfishing.integration.papi;

import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import net.momirealms.customfishing.CustomFishing;
import net.momirealms.customfishing.manager.StatisticsManager;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StatisticsPapi
extends PlaceholderExpansion {
    private final StatisticsManager statisticsManager;

    public StatisticsPapi(CustomFishing plugin) {
        this.statisticsManager = plugin.getStatisticsManager();
    }

    @NotNull
    public String getIdentifier() {
        return "fishingstats";
    }

    @NotNull
    public String getAuthor() {
        return "XiaoMoMi";
    }

    @NotNull
    public String getVersion() {
        return "1.3";
    }

    public boolean persist() {
        return true;
    }

    @Nullable
    public String onRequest(OfflinePlayer player, @NotNull String params) {
        String[] args = params.split("_", 2);
        switch (args[0]) {
            case "total": {
                return String.valueOf(this.statisticsManager.getTotalFishAmount(player.getUniqueId()));
            }
            case "amount": {
                if (args[1].equals("")) {
                    return "lack args";
                }
                return String.valueOf(this.statisticsManager.getFishAmount(player.getUniqueId(), args[1]));
            }
            case "hascaught": {
                if (args[1].equals("")) {
                    return "lack args";
                }
                return String.valueOf(this.statisticsManager.hasFished(player.getUniqueId(), args[1]));
            }
            case "category": {
                String[] moreArgs = args[1].split("_", 2);
                if (moreArgs[1].equals("")) {
                    return "lack args";
                }
                switch (moreArgs[0]) {
                    case "total": {
                        return String.valueOf(this.statisticsManager.getCategoryTotalFishAmount(player.getUniqueId(), moreArgs[1]));
                    }
                    case "progress": {
                        String progress = String.format("%.1f", this.statisticsManager.getCategoryUnlockProgress(player.getUniqueId(), moreArgs[1]));
                        return progress.equals("100.0") ? "100" : progress;
                    }
                }
            }
        }
        return "null";
    }
}

