/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customfishing.util;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.wrappers.WrappedDataWatcher;
import java.util.List;
import java.util.UUID;
import net.momirealms.customfishing.CustomFishing;
import net.momirealms.customfishing.util.ArmorStandUtils;
import org.bukkit.Location;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

public class FakeItemUtils {
    public static PacketContainer getDestroyPacket(int id) {
        PacketContainer destroyPacket = new PacketContainer(PacketType.Play.Server.ENTITY_DESTROY);
        destroyPacket.getIntLists().write(0, List.of(Integer.valueOf(id)));
        return destroyPacket;
    }

    public static PacketContainer getSpawnPacket(int id, Location location) {
        PacketContainer entityPacket = new PacketContainer(PacketType.Play.Server.SPAWN_ENTITY);
        entityPacket.getModifier().write(0, (Object)id);
        entityPacket.getModifier().write(1, (Object)UUID.randomUUID());
        entityPacket.getEntityTypeModifier().write(0, (Object)EntityType.DROPPED_ITEM);
        entityPacket.getDoubles().write(0, (Object)location.getX());
        entityPacket.getDoubles().write(1, (Object)(location.getY() - 0.5));
        entityPacket.getDoubles().write(2, (Object)location.getZ());
        return entityPacket;
    }

    public static PacketContainer getMetaPacket(int id, ItemStack itemStack) {
        PacketContainer metaPacket = new PacketContainer(PacketType.Play.Server.ENTITY_METADATA);
        metaPacket.getIntegers().write(0, (Object)id);
        if (CustomFishing.getInstance().getVersionHelper().isVersionNewerThan1_19_R2()) {
            WrappedDataWatcher wrappedDataWatcher = FakeItemUtils.createDataWatcher(itemStack);
            ArmorStandUtils.setValueList(metaPacket, wrappedDataWatcher);
        } else {
            metaPacket.getWatchableCollectionModifier().write(0, (Object)FakeItemUtils.createDataWatcher(itemStack).getWatchableObjects());
        }
        return metaPacket;
    }

    public static PacketContainer getTpPacket(int id, Location location) {
        PacketContainer tpPacket = new PacketContainer(PacketType.Play.Server.ENTITY_TELEPORT);
        tpPacket.getModifier().write(0, (Object)id);
        tpPacket.getDoubles().write(0, (Object)location.getX());
        tpPacket.getDoubles().write(1, (Object)(location.getY() - 0.5));
        tpPacket.getDoubles().write(2, (Object)location.getZ());
        return tpPacket;
    }

    public static PacketContainer getVelocity(int id, Vector vector) {
        PacketContainer entityPacket = new PacketContainer(PacketType.Play.Server.ENTITY_VELOCITY);
        entityPacket.getModifier().write(0, (Object)id);
        entityPacket.getIntegers().write(1, (Object)((int)(vector.getX() * 8000.0)));
        entityPacket.getIntegers().write(2, (Object)((int)(vector.getY() * 8000.0)));
        entityPacket.getIntegers().write(3, (Object)((int)(vector.getZ() * 8000.0)));
        return entityPacket;
    }

    public static WrappedDataWatcher createDataWatcher(ItemStack itemStack) {
        WrappedDataWatcher wrappedDataWatcher = new WrappedDataWatcher();
        wrappedDataWatcher.setObject(new WrappedDataWatcher.WrappedDataWatcherObject(8, WrappedDataWatcher.Registry.getItemStackSerializer((boolean)false)), (Object)itemStack);
        wrappedDataWatcher.setObject(new WrappedDataWatcher.WrappedDataWatcherObject(5, WrappedDataWatcher.Registry.get(Boolean.class)), (Object)true);
        return wrappedDataWatcher;
    }
}

