/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customfishing.util;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.momirealms.customfishing.CustomFishing;
import net.momirealms.customfishing.fishing.loot.DroppedItem;
import net.momirealms.customfishing.fishing.loot.Item;
import net.momirealms.customfishing.fishing.loot.Loot;
import net.momirealms.customfishing.libs.de.tr7zw.changeme.nbtapi.NBTCompound;
import net.momirealms.customfishing.libs.de.tr7zw.changeme.nbtapi.NBTItem;
import net.momirealms.customfishing.libs.de.tr7zw.changeme.nbtapi.NBTListCompound;
import net.momirealms.customfishing.libs.de.tr7zw.changeme.nbtapi.iface.ReadWriteNBTList;
import net.momirealms.customfishing.libs.net.kyori.adventure.text.minimessage.MiniMessage;
import net.momirealms.customfishing.libs.net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.momirealms.customfishing.object.LeveledEnchantment;
import net.momirealms.customfishing.util.AdventureUtils;
import net.momirealms.customfishing.util.ConfigUtils;
import net.momirealms.customfishing.util.NBTUtils;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemStackUtils {
    public static ItemStack getFromItem(Item item) {
        NBTCompound display;
        ItemStack itemStack = new ItemStack(item.getMaterial());
        if (item.getMaterial() == Material.AIR) {
            return itemStack;
        }
        itemStack.setAmount(item.getAmount());
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (item.getCustomModelData() != 0) {
            itemMeta.setCustomModelData(Integer.valueOf(item.getCustomModelData()));
        }
        if (item.isUnbreakable()) {
            itemMeta.setUnbreakable(true);
        }
        if (item.getItemFlags() != null) {
            item.getItemFlags().forEach(xva$0 -> itemMeta.addItemFlags(new ItemFlag[]{xva$0}));
        }
        if (item.getEnchantment() != null) {
            if (itemStack.getType() == Material.ENCHANTED_BOOK) {
                EnchantmentStorageMeta meta = (EnchantmentStorageMeta)itemMeta;
                item.getEnchantment().forEach(enchantment -> meta.addStoredEnchant(Objects.requireNonNull(Enchantment.getByKey((NamespacedKey)enchantment.key())), enchantment.level(), true));
                itemStack.setItemMeta((ItemMeta)meta);
            } else {
                item.getEnchantment().forEach(enchantment -> itemMeta.addEnchant(Objects.requireNonNull(Enchantment.getByKey((NamespacedKey)enchantment.key())), enchantment.level(), true));
                itemStack.setItemMeta(itemMeta);
            }
        } else {
            itemStack.setItemMeta(itemMeta);
        }
        NBTItem nbtItem = new NBTItem(itemStack);
        if (item.getName() != null) {
            display = nbtItem.addCompound("display");
            String name = item.getName();
            if (name.contains("&") || name.contains("\u00a7")) {
                name = AdventureUtils.replaceLegacy(name);
            }
            display.setString("Name", (String)GsonComponentSerializer.gson().serialize(MiniMessage.miniMessage().deserialize("<!i>" + name)));
        }
        if (item.getLore() != null) {
            display = nbtItem.addCompound("display");
            ReadWriteNBTList lore = display.getStringList("Lore");
            item.getLore().forEach(arg_0 -> ItemStackUtils.lambda$getFromItem$3((List)((Object)lore), arg_0));
        }
        if (item.getCfTag() != null) {
            NBTCompound cfCompound = nbtItem.addCompound("CustomFishing");
            cfCompound.setString("type", item.getCfTag()[0]);
            cfCompound.setString("id", item.getCfTag()[1]);
        }
        if (item.getHead64() != null) {
            NBTCompound nbtCompound = nbtItem.addCompound("SkullOwner");
            nbtCompound.setUUID("Id", item.isHeadStackable() ? UUID.nameUUIDFromBytes(item.getKey().getBytes()) : UUID.randomUUID());
            NBTListCompound texture = nbtCompound.addCompound("Properties").getCompoundList("textures").addCompound();
            texture.setString("Value", item.getHead64());
        }
        if (item.getTotem() != null) {
            nbtItem.setString("Totem", item.getTotem());
        }
        if (item.getNbt() != null) {
            NBTUtils.setTags(item.getNbt(), nbtItem);
        }
        return nbtItem.getItem();
    }

    public static void addRandomDamage(ItemStack itemStack) {
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta instanceof Damageable) {
            Damageable damageable = (Damageable)itemMeta;
            damageable.setDamage((int)((double)itemStack.getType().getMaxDurability() * Math.random()));
            itemStack.setItemMeta((ItemMeta)damageable);
        }
    }

    public static void addOwner(ItemStack itemStack, String name) {
        NBTItem nbtItem = new NBTItem(itemStack);
        nbtItem.setString("TempOwner", name);
        itemStack.setItemMeta(nbtItem.getItem().getItemMeta());
    }

    public static void addRandomEnchants(ItemStack itemStack, LeveledEnchantment[] enchantments) {
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemStack.getType() == Material.ENCHANTED_BOOK) {
            EnchantmentStorageMeta meta = (EnchantmentStorageMeta)itemMeta;
            for (LeveledEnchantment enchantment : enchantments) {
                if (!(enchantment.chance() > Math.random())) continue;
                meta.addStoredEnchant(Objects.requireNonNull(Enchantment.getByKey((NamespacedKey)enchantment.key())), enchantment.level(), true);
            }
            itemStack.setItemMeta((ItemMeta)meta);
        } else {
            for (LeveledEnchantment enchantment : enchantments) {
                if (!(enchantment.chance() > Math.random())) continue;
                itemMeta.addEnchant(Objects.requireNonNull(Enchantment.getByKey((NamespacedKey)enchantment.key())), enchantment.level(), true);
            }
            itemStack.setItemMeta(itemMeta);
        }
    }

    public static void addIdentifier(ItemStack itemStack, String type, String id) {
        NBTItem nbtItem = new NBTItem(itemStack);
        NBTCompound nbtCompound = nbtItem.addCompound("CustomFishing");
        nbtCompound.setString("type", type);
        nbtCompound.setString("id", id);
        itemStack.setItemMeta(nbtItem.getItem().getItemMeta());
    }

    public static int givePlayerLoot(Player player, String key, int amount) {
        Loot loot = CustomFishing.getInstance().getLootManager().getLoot(key);
        if (!(loot instanceof DroppedItem)) {
            return 0;
        }
        DroppedItem droppedItem = (DroppedItem)loot;
        ItemStack itemStack = CustomFishing.getInstance().getFishingManager().getCustomFishingLootItemStack(droppedItem, player);
        if (itemStack.getType() == Material.AIR) {
            return 0;
        }
        if (amount != 0) {
            itemStack.setAmount(amount);
        }
        player.getInventory().addItem(new ItemStack[]{itemStack});
        return itemStack.getAmount();
    }

    public static void givePlayerRod(Player player, String rodKey, int amount) {
        Item item = CustomFishing.getInstance().getEffectManager().getRodItem(rodKey);
        if (item == null) {
            return;
        }
        ItemStack itemStack = ItemStackUtils.getFromItem(item);
        if (amount != 0) {
            for (int i = 0; i < amount; ++i) {
                player.getInventory().addItem(new ItemStack[]{itemStack});
            }
        } else {
            player.getInventory().addItem(new ItemStack[]{itemStack});
        }
    }

    public static void givePlayerBait(Player player, String baitKey, int amount) {
        Item item = CustomFishing.getInstance().getEffectManager().getBaitItem(baitKey);
        if (item == null) {
            return;
        }
        ItemStack itemStack = ItemStackUtils.getFromItem(item);
        if (amount != 0) {
            itemStack.setAmount(amount);
        }
        player.getInventory().addItem(new ItemStack[]{itemStack});
    }

    public static void givePlayerUtil(Player player, String utilKey, int amount) {
        Item item = CustomFishing.getInstance().getEffectManager().getUtilItem(utilKey);
        if (item == null) {
            return;
        }
        ItemStack itemStack = ItemStackUtils.getFromItem(item);
        if (amount != 0) {
            itemStack.setAmount(amount);
        }
        player.getInventory().addItem(new ItemStack[]{itemStack});
    }

    public static boolean saveToFile(ItemStack itemStack, String key) {
        if (itemStack == null || itemStack.getType() == Material.AIR || CustomFishing.getInstance().getLootManager().hasLoot(key)) {
            return false;
        }
        File file = new File(CustomFishing.getInstance().getDataFolder(), File.separator + "loots" + File.separator + "imported.yml");
        YamlConfiguration data = ConfigUtils.readData(file);
        data.set(key + ".material", (Object)itemStack.getType().toString());
        data.set(key + ".amount", (Object)itemStack.getAmount());
        NBTItem nbtItem = new NBTItem(itemStack);
        Map<String, Object> map0 = NBTUtils.compoundToMap(nbtItem);
        if (map0.size() != 0) {
            data.createSection(key + ".nbt", map0);
        }
        try {
            data.save(file);
            CustomFishing.getInstance().getLootManager().unload();
            CustomFishing.getInstance().getLootManager().load();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return true;
    }

    public static void addExtraMeta(ItemStack itemStack, DroppedItem droppedItem, double sizeMultiplier) {
        NBTCompound fishMetaCompound;
        NBTItem nbtItem = new NBTItem(itemStack);
        boolean changed = ItemStackUtils.replaceSizeLore(droppedItem.getSize(), nbtItem, sizeMultiplier);
        if (droppedItem.getBasicPrice() != 0.0f) {
            fishMetaCompound = nbtItem.addCompound("FishMeta");
            fishMetaCompound.setFloat("base", Float.valueOf(droppedItem.getBasicPrice()));
            changed = true;
        }
        if (droppedItem.getSizeBonus() != 0.0f) {
            fishMetaCompound = nbtItem.addCompound("FishMeta");
            fishMetaCompound.setFloat("bonus", Float.valueOf(droppedItem.getSizeBonus()));
            changed = true;
        }
        if (changed) {
            itemStack.setItemMeta(nbtItem.getItem().getItemMeta());
        }
    }

    private static boolean replaceSizeLore(String[] sizes, NBTItem nbtItem, double sizeMultiplier) {
        if (sizes == null) {
            return false;
        }
        float min = Float.parseFloat(sizes[0]);
        float max = Float.parseFloat(sizes[1]);
        if (max - min < 0.0f) {
            return false;
        }
        float size = (float)(((double)min + Math.random() * (double)(max - min)) * sizeMultiplier);
        String sizeText = String.format("%.1f", Float.valueOf(size));
        NBTCompound nbtCompound = nbtItem.getCompound("display");
        if (nbtCompound == null || !nbtCompound.hasTag("Lore")) {
            return false;
        }
        ReadWriteNBTList lore = nbtCompound.getStringList("Lore");
        lore.replaceAll(s -> s.replace("{size}", sizeText));
        NBTCompound fishMetaCompound = nbtItem.addCompound("FishMeta");
        fishMetaCompound.setFloat("size", Float.valueOf(size));
        return true;
    }

    private static /* synthetic */ void lambda$getFromItem$3(List lore, String line) {
        if (line.contains("&") || line.contains("\u00a7")) {
            line = AdventureUtils.replaceLegacy(line);
        }
        lore.add((String)GsonComponentSerializer.gson().serialize(MiniMessage.miniMessage().deserialize("<!i>" + line)));
    }
}

