/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.bukkit.generator;

import com.plotsquared.bukkit.generator.BlockStatePopulator;
import com.plotsquared.bukkit.generator.BukkitAugmentedGenerator;
import com.plotsquared.bukkit.generator.DelegatePlotGenerator;
import com.plotsquared.bukkit.generator.LegacyBlockStatePopulator;
import com.plotsquared.bukkit.queue.GenChunk;
import com.plotsquared.bukkit.util.BukkitUtil;
import com.plotsquared.bukkit.util.BukkitWorld;
import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.annotations.annotations.NotNull;
import com.plotsquared.core.annotations.annotations.Nullable;
import com.plotsquared.core.generator.ClassicPlotWorld;
import com.plotsquared.core.generator.GeneratorWrapper;
import com.plotsquared.core.generator.IndependentPlotGenerator;
import com.plotsquared.core.generator.SingleWorldGenerator;
import com.plotsquared.core.location.ChunkWrapper;
import com.plotsquared.core.location.UncheckedWorldLocation;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.world.PlotAreaManager;
import com.plotsquared.core.queue.ZeroedDelegateScopedQueueCoordinator;
import com.plotsquared.core.util.ChunkManager;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.math.BlockVector2;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.world.biome.BiomeType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bukkit.HeightMap;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.generator.BiomeProvider;
import org.bukkit.generator.BlockPopulator;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.generator.WorldInfo;
import org.checkerframework.checker.nullness.qual.NonNull;

public class BukkitPlotGenerator
extends ChunkGenerator
implements GeneratorWrapper<ChunkGenerator> {
    private static final Logger LOGGER = LogManager.getLogger((String)("PlotSquared/" + BukkitPlotGenerator.class.getSimpleName()));
    public final boolean PAPER_ASYNC_SAFE = true;
    private final PlotAreaManager plotAreaManager;
    private final IndependentPlotGenerator plotGenerator;
    private final ChunkGenerator platformGenerator;
    private final boolean full;
    private final String levelName;
    private final boolean useNewGenerationMethods;
    private final BiomeProvider biomeProvider;
    private List<BlockPopulator> populators;
    private boolean loaded = false;
    private PlotArea lastPlotArea;
    private int lastChunkX = Integer.MIN_VALUE;
    private int lastChunkZ = Integer.MIN_VALUE;

    public BukkitPlotGenerator(@NonNull String string, @NonNull IndependentPlotGenerator independentPlotGenerator, @NonNull PlotAreaManager plotAreaManager) {
        this.plotAreaManager = plotAreaManager;
        this.levelName = string;
        this.plotGenerator = independentPlotGenerator;
        this.platformGenerator = this;
        this.populators = new ArrayList<BlockPopulator>();
        int n = PlotSquared.platform().serverVersion()[1];
        if (n >= 17) {
            this.populators.add(new BlockStatePopulator(this.plotGenerator));
        } else {
            this.populators.add(new LegacyBlockStatePopulator(this.plotGenerator));
        }
        this.full = true;
        this.useNewGenerationMethods = PlotSquared.platform().serverVersion()[1] >= 19;
        this.biomeProvider = new BukkitPlotBiomeProvider();
    }

    public BukkitPlotGenerator(String string, ChunkGenerator chunkGenerator, @NonNull PlotAreaManager plotAreaManager) {
        if (chunkGenerator instanceof BukkitPlotGenerator) {
            throw new IllegalArgumentException("ChunkGenerator: " + chunkGenerator.getClass().getName() + " is already a BukkitPlotGenerator!");
        }
        this.plotAreaManager = plotAreaManager;
        this.levelName = string;
        this.full = false;
        this.platformGenerator = chunkGenerator;
        this.plotGenerator = new DelegatePlotGenerator(chunkGenerator, string);
        this.useNewGenerationMethods = PlotSquared.platform().serverVersion()[1] >= 19;
        this.biomeProvider = null;
    }

    @Override
    public void augment(PlotArea plotArea) {
        BukkitAugmentedGenerator.get(BukkitUtil.getWorld(plotArea.getWorldName()));
    }

    @Override
    public boolean isFull() {
        return this.full;
    }

    @Override
    public IndependentPlotGenerator getPlotGenerator() {
        return this.plotGenerator;
    }

    @Override
    public ChunkGenerator getPlatformGenerator() {
        return this.platformGenerator;
    }

    public @NonNull List<BlockPopulator> getDefaultPopulators(@NonNull World world) {
        try {
            this.checkLoaded(world);
        }
        catch (Exception exception) {
            LOGGER.error("Error attempting to load world into PlotSquared.", (Throwable)exception);
        }
        ArrayList<BlockPopulator> arrayList = new ArrayList<BlockPopulator>();
        List list = world.getPopulators();
        if (this.populators == null && this.platformGenerator != null) {
            this.populators = new ArrayList<BlockPopulator>(this.platformGenerator.getDefaultPopulators(world));
        }
        if (this.populators != null) {
            for (BlockPopulator blockPopulator : this.populators) {
                if (list.contains(blockPopulator)) continue;
                arrayList.add(blockPopulator);
            }
        }
        return arrayList;
    }

    private synchronized void checkLoaded(@NonNull World world) {
        if (!PlotSquared.get().isWeInitialised()) {
            return;
        }
        if (!this.loaded) {
            String string = world.getName();
            PlotSquared.get().loadWorld(string, this);
            Set<PlotArea> set = this.plotAreaManager.getPlotAreasSet(string);
            if (!set.isEmpty()) {
                PlotArea plotArea = set.iterator().next();
                if (!plotArea.isMobSpawning()) {
                    if (!plotArea.isSpawnEggs()) {
                        world.setSpawnFlags(false, false);
                    }
                    this.setSpawnLimits(world, 0);
                } else {
                    world.setSpawnFlags(true, true);
                    this.setSpawnLimits(world, -1);
                }
            }
            this.loaded = true;
        }
    }

    private void setSpawnLimits(@NonNull World world, int n) {
        world.setAmbientSpawnLimit(n);
        world.setAnimalSpawnLimit(n);
        world.setMonsterSpawnLimit(n);
        world.setWaterAnimalSpawnLimit(n);
    }

    public void generateNoise(@NotNull WorldInfo worldInfo, @NotNull Random random, int n, int n2, @NotNull ChunkGenerator.ChunkData chunkData) {
        if (this.platformGenerator != this) {
            this.platformGenerator.generateNoise(worldInfo, random, n, n2, chunkData);
            return;
        }
        int n3 = chunkData.getMinHeight();
        int n4 = chunkData.getMaxHeight();
        GenChunk genChunk = new GenChunk(n3, n4);
        genChunk.setChunk(new ChunkWrapper(worldInfo.getName(), n, n2));
        genChunk.setChunkData(chunkData);
        genChunk.result = null;
        try {
            this.generate(BlockVector2.at((int)n, (int)n2), worldInfo.getName(), genChunk, false);
        }
        catch (Throwable throwable) {
            LOGGER.error("Error attempting to generate chunk.", throwable);
        }
    }

    public void generateSurface(@NotNull WorldInfo worldInfo, @NotNull Random random, int n, int n2, @NotNull ChunkGenerator.ChunkData chunkData) {
        if (this.platformGenerator != this) {
            this.platformGenerator.generateSurface(worldInfo, random, n, n2, chunkData);
        }
    }

    public void generateBedrock(@NotNull WorldInfo worldInfo, @NotNull Random random, int n, int n2, @NotNull ChunkGenerator.ChunkData chunkData) {
        if (this.platformGenerator != this) {
            this.platformGenerator.generateBedrock(worldInfo, random, n, n2, chunkData);
        }
    }

    public void generateCaves(@NotNull WorldInfo worldInfo, @NotNull Random random, int n, int n2, @NotNull ChunkGenerator.ChunkData chunkData) {
        if (this.platformGenerator != this) {
            this.platformGenerator.generateCaves(worldInfo, random, n, n2, chunkData);
        }
    }

    @Nullable
    public BiomeProvider getDefaultBiomeProvider(@NotNull WorldInfo worldInfo) {
        if (this.platformGenerator != this) {
            return this.platformGenerator.getDefaultBiomeProvider(worldInfo);
        }
        return this.biomeProvider;
    }

    public int getBaseHeight(@NotNull WorldInfo worldInfo, @NotNull Random random, int n, int n2, @NotNull HeightMap heightMap) {
        PlotArea plotArea = this.getPlotArea(worldInfo.getName(), n, n2);
        if (plotArea instanceof ClassicPlotWorld) {
            ClassicPlotWorld classicPlotWorld = (ClassicPlotWorld)plotArea;
            return classicPlotWorld.PLOT_HEIGHT;
        }
        return super.getBaseHeight(worldInfo, random, n, n2, heightMap);
    }

    @Deprecated(since="7.0.0")
    public // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull ChunkGenerator.ChunkData generateChunkData(@NonNull World world, @NonNull Random random, int n, int n2, // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull ChunkGenerator.BiomeGrid biomeGrid) {
        if (this.useNewGenerationMethods) {
            if (this.platformGenerator != this) {
                return this.platformGenerator.generateChunkData(world, random, n, n2, biomeGrid);
            }
            throw new UnsupportedOperationException("Using new generation methods. This method is unsupported.");
        }
        int n3 = BukkitWorld.getMinWorldHeight(world);
        int n4 = BukkitWorld.getMaxWorldHeight(world);
        GenChunk genChunk = new GenChunk(n3, n4);
        if (this.getPlotGenerator() instanceof SingleWorldGenerator && genChunk.getChunkData() != null) {
            for (int i = 0; i < 16; ++i) {
                for (int j = 0; j < 16; ++j) {
                    for (int k = n3; k < n4; ++k) {
                        biomeGrid.setBiome(i, k, j, Biome.PLAINS);
                    }
                }
            }
            return genChunk.getChunkData();
        }
        genChunk.setChunk(new ChunkWrapper(world.getName(), n, n2));
        genChunk.setChunkData(this.createChunkData(world));
        genChunk.biomeGrid = biomeGrid;
        genChunk.result = null;
        try {
            if (this.platformGenerator != this) {
                return this.platformGenerator.generateChunkData(world, random, n, n2, biomeGrid);
            }
            this.generate(BlockVector2.at((int)n, (int)n2), world.getName(), genChunk, true);
        }
        catch (Throwable throwable) {
            LOGGER.error("Error attempting to load world into PlotSquared.", throwable);
        }
        return genChunk.getChunkData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generate(BlockVector2 blockVector2, String string, ZeroedDelegateScopedQueueCoordinator zeroedDelegateScopedQueueCoordinator, boolean bl) {
        Object object;
        if (!this.loaded) {
            object = this;
            synchronized (object) {
                PlotSquared.get().loadWorld(string, this);
            }
        }
        if (ChunkManager.preProcessChunk(blockVector2, zeroedDelegateScopedQueueCoordinator)) {
            return;
        }
        object = this.getPlotArea(string, blockVector2.getX(), blockVector2.getZ());
        try {
            this.plotGenerator.generateChunk(zeroedDelegateScopedQueueCoordinator, (PlotArea)object, bl);
        }
        catch (Throwable throwable) {
            LOGGER.error("Error attempting to generate chunk.", throwable);
        }
        ChunkManager.postProcessChunk(blockVector2, zeroedDelegateScopedQueueCoordinator);
    }

    public boolean canSpawn(@NonNull World world, int n, int n2) {
        return true;
    }

    public boolean shouldGenerateCaves() {
        return false;
    }

    public boolean shouldGenerateDecorations() {
        return false;
    }

    public boolean isParallelCapable() {
        return true;
    }

    public boolean shouldGenerateMobs() {
        return false;
    }

    public boolean shouldGenerateStructures() {
        return true;
    }

    @Override
    public String toString() {
        if (this.platformGenerator == this) {
            return this.plotGenerator.getName();
        }
        if (this.platformGenerator == null) {
            return "null";
        }
        return this.platformGenerator.getClass().getName();
    }

    @Override
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        return this.toString().equals(object.toString()) || this.toString().equals(object.getClass().getName());
    }

    public String getLevelName() {
        return this.levelName;
    }

    private synchronized PlotArea getPlotArea(String string, int n, int n2) {
        if (!this.loaded) {
            PlotSquared.get().loadWorld(string, this);
        }
        if (this.lastPlotArea != null && string.equals(this.levelName) && n == this.lastChunkX && n2 == this.lastChunkZ) {
            return this.lastPlotArea;
        }
        BlockVector3 blockVector3 = BlockVector3.at((int)(n << 4), (int)0, (int)(n2 << 4));
        if (this.lastPlotArea != null && this.lastPlotArea.getRegion().contains(blockVector3) && this.lastPlotArea.getRegion().contains(blockVector3)) {
            return this.lastPlotArea;
        }
        PlotArea plotArea = UncheckedWorldLocation.at(string, blockVector3).getPlotArea();
        if (plotArea == null) {
            throw new IllegalStateException(String.format("Cannot generate chunk that does not belong to a plot area. World: %s", string));
        }
        this.lastChunkX = n;
        this.lastChunkZ = n2;
        this.lastPlotArea = plotArea;
        return this.lastPlotArea;
    }

    private final class BukkitPlotBiomeProvider
    extends BiomeProvider {
        private static final List<Biome> BIOMES;

        private BukkitPlotBiomeProvider() {
        }

        @NotNull
        public Biome getBiome(@NotNull WorldInfo worldInfo, int n, int n2, int n3) {
            PlotArea plotArea = BukkitPlotGenerator.this.getPlotArea(worldInfo.getName(), n >> 4, n3 >> 4);
            return BukkitAdapter.adapt((BiomeType)BukkitPlotGenerator.this.plotGenerator.getBiome(plotArea, n, n2, n3));
        }

        @NotNull
        public List<Biome> getBiomes(@NotNull WorldInfo worldInfo) {
            return BIOMES;
        }

        static {
            Biome biome;
            EnumSet<Biome> enumSet = EnumSet.of(Biome.CUSTOM);
            if (PlotSquared.platform().serverVersion()[1] <= 19 && (biome = (Biome)Registry.BIOME.get(NamespacedKey.minecraft((String)"cherry_grove"))) != null) {
                enumSet.add(biome);
            }
            BIOMES = Arrays.stream(Biome.values()).filter(Predicate.not(enumSet::contains)).toList();
        }
    }
}

