/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.bukkit.generator;

import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.generator.HybridPlotWorld;
import com.plotsquared.core.generator.IndependentPlotGenerator;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.location.UncheckedWorldLocation;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.world.SinglePlotArea;
import com.plotsquared.core.queue.QueueCoordinator;
import com.plotsquared.core.queue.ZeroedDelegateScopedQueueCoordinator;
import com.sk89q.worldedit.bukkit.BukkitWorld;
import com.sk89q.worldedit.util.SideEffectSet;
import com.sk89q.worldedit.world.World;
import java.util.Random;
import org.bukkit.Chunk;
import org.bukkit.generator.BlockPopulator;
import org.checkerframework.checker.nullness.qual.NonNull;

final class LegacyBlockStatePopulator
extends BlockPopulator {
    private final IndependentPlotGenerator plotGenerator;

    public LegacyBlockStatePopulator(@NonNull IndependentPlotGenerator independentPlotGenerator) {
        this.plotGenerator = independentPlotGenerator;
    }

    public void populate(@NonNull org.bukkit.World world, @NonNull Random random, @NonNull Chunk chunk) {
        Object object;
        int n = chunk.getX() << 4;
        int n2 = chunk.getZ() << 4;
        PlotArea plotArea = Location.at(world.getName(), n, 0, n2).getPlotArea();
        if (plotArea == null || plotArea instanceof HybridPlotWorld && !((HybridPlotWorld)(object = (HybridPlotWorld)plotArea)).populationNeeded() || plotArea instanceof SinglePlotArea) {
            return;
        }
        object = PlotSquared.platform().globalBlockQueue().getNewQueue((World)new BukkitWorld(world));
        ((QueueCoordinator)object).setForceSync(true);
        ((QueueCoordinator)object).setSideEffectSet(SideEffectSet.none());
        ((QueueCoordinator)object).setBiomesEnabled(false);
        ((QueueCoordinator)object).setChunkObject(chunk);
        UncheckedWorldLocation uncheckedWorldLocation = UncheckedWorldLocation.at(world.getName(), n, world.getMinHeight(), n2);
        UncheckedWorldLocation uncheckedWorldLocation2 = UncheckedWorldLocation.at(world.getName(), n + 15, world.getMaxHeight(), n2 + 15);
        ZeroedDelegateScopedQueueCoordinator zeroedDelegateScopedQueueCoordinator = new ZeroedDelegateScopedQueueCoordinator((QueueCoordinator)object, uncheckedWorldLocation, uncheckedWorldLocation2);
        this.plotGenerator.populateChunk(zeroedDelegateScopedQueueCoordinator, plotArea);
        ((QueueCoordinator)object).enqueue();
    }
}

