/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.bukkit.listener;

import com.plotsquared.bukkit.listener.BlockEventListener;
import com.plotsquared.bukkit.player.BukkitPlayer;
import com.plotsquared.bukkit.util.BukkitEntityUtil;
import com.plotsquared.bukkit.util.BukkitUtil;
import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.listener.PlayerBlockEventType;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.permissions.Permission;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.PlotHandler;
import com.plotsquared.core.plot.flag.implementations.DisablePhysicsFlag;
import com.plotsquared.core.plot.flag.implementations.EntityChangeBlockFlag;
import com.plotsquared.core.plot.flag.implementations.ExplosionFlag;
import com.plotsquared.core.plot.flag.implementations.InvincibleFlag;
import com.plotsquared.core.plot.world.PlotAreaManager;
import com.plotsquared.core.util.EventDispatcher;
import com.plotsquared.core.util.PlotFlagUtil;
import com.plotsquared.google.Inject;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.world.block.BlockType;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.Boat;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.EntityCombustByEntityEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.ExplosionPrimeEvent;
import org.bukkit.event.vehicle.VehicleCreateEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.projectiles.BlockProjectileSource;
import org.bukkit.projectiles.ProjectileSource;
import org.checkerframework.checker.nullness.qual.NonNull;

public class EntityEventListener
implements Listener {
    private final PlotAreaManager plotAreaManager;
    private final EventDispatcher eventDispatcher;
    private float lastRadius;

    @Inject
    public EntityEventListener(@NonNull PlotAreaManager plotAreaManager, @NonNull EventDispatcher eventDispatcher) {
        this.plotAreaManager = plotAreaManager;
        this.eventDispatcher = eventDispatcher;
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onEntityCombustByEntity(EntityCombustByEntityEvent entityCombustByEntityEvent) {
        EntityDamageByEntityEvent entityDamageByEntityEvent = new EntityDamageByEntityEvent(entityCombustByEntityEvent.getCombuster(), entityCombustByEntityEvent.getEntity(), EntityDamageEvent.DamageCause.FIRE_TICK, (double)entityCombustByEntityEvent.getDuration());
        this.onEntityDamageByEntityEvent(entityDamageByEntityEvent);
        if (entityDamageByEntityEvent.isCancelled()) {
            entityCombustByEntityEvent.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onEntityDamageByEntityEvent(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        Entity entity = entityDamageByEntityEvent.getDamager();
        Location location = BukkitUtil.adapt(entity.getLocation());
        if (!this.plotAreaManager.hasPlotArea(location.getWorldName())) {
            return;
        }
        Entity entity2 = entityDamageByEntityEvent.getEntity();
        if (!BukkitEntityUtil.entityDamage(entity, entity2, entityDamageByEntityEvent.getCause())) {
            Ageable ageable;
            if (entityDamageByEntityEvent.isCancelled() && entity2 instanceof Ageable && (ageable = (Ageable)entity2).getAge() == -24000) {
                ageable.setAge(0);
                ageable.setAdult();
            }
            entityDamageByEntityEvent.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void creatureSpawnEvent(CreatureSpawnEvent creatureSpawnEvent) {
        LivingEntity livingEntity = creatureSpawnEvent.getEntity();
        Location location = BukkitUtil.adapt(livingEntity.getLocation());
        PlotArea plotArea = location.getPlotArea();
        if (plotArea == null) {
            return;
        }
        CreatureSpawnEvent.SpawnReason spawnReason = creatureSpawnEvent.getSpawnReason();
        switch (spawnReason.toString()) {
            case "DISPENSE_EGG": 
            case "EGG": 
            case "OCELOT_BABY": 
            case "SPAWNER_EGG": {
                if (plotArea.isSpawnEggs()) break;
                creatureSpawnEvent.setCancelled(true);
                return;
            }
            case "REINFORCEMENTS": 
            case "NATURAL": 
            case "MOUNT": 
            case "PATROL": 
            case "RAID": 
            case "SHEARED": 
            case "SILVERFISH_BLOCK": 
            case "ENDER_PEARL": 
            case "TRAP": 
            case "VILLAGE_DEFENSE": 
            case "VILLAGE_INVASION": 
            case "BEEHIVE": 
            case "CHUNK_GEN": 
            case "NETHER_PORTAL": 
            case "DUPLICATION": 
            case "FROZEN": 
            case "SPELL": {
                if (plotArea.isMobSpawning()) break;
                creatureSpawnEvent.setCancelled(true);
                return;
            }
            case "BREEDING": {
                if (plotArea.isSpawnBreeding()) break;
                creatureSpawnEvent.setCancelled(true);
                return;
            }
            case "BUILD_IRONGOLEM": 
            case "BUILD_SNOWMAN": 
            case "BUILD_WITHER": 
            case "CUSTOM": {
                if (plotArea.isSpawnCustom() || livingEntity.getType() == EntityType.ARMOR_STAND) break;
                creatureSpawnEvent.setCancelled(true);
                return;
            }
            case "SPAWNER": {
                if (plotArea.isMobSpawnerSpawning()) break;
                creatureSpawnEvent.setCancelled(true);
                return;
            }
        }
        Object object = plotArea.getOwnedPlotAbs(location);
        if (object == null) {
            if (!plotArea.isMobSpawning()) {
                creatureSpawnEvent.setCancelled(true);
            }
            return;
        }
        if (BukkitEntityUtil.checkEntity((Entity)livingEntity, ((Plot)object).getBasePlot(false))) {
            creatureSpawnEvent.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void onEntityFall(EntityChangeBlockEvent entityChangeBlockEvent) {
        if (entityChangeBlockEvent.getEntityType() != EntityType.FALLING_BLOCK) {
            return;
        }
        Block block = entityChangeBlockEvent.getBlock();
        World world = block.getWorld();
        String string = world.getName();
        if (!this.plotAreaManager.hasPlotArea(string)) {
            return;
        }
        Location location = BukkitUtil.adapt(block.getLocation());
        PlotArea plotArea = location.getPlotArea();
        if (plotArea == null) {
            return;
        }
        Plot plot = plotArea.getOwnedPlotAbs(location);
        if (plot == null || ((Boolean)plot.getFlag(DisablePhysicsFlag.class)).booleanValue()) {
            entityChangeBlockEvent.setCancelled(true);
            if (plot != null) {
                if (block.getType().hasGravity()) {
                    BlockEventListener.sendBlockChange(block.getLocation(), block.getBlockData());
                }
                plot.debug("Falling block event was cancelled because disable-physics = true");
            }
            return;
        }
        if (entityChangeBlockEvent.getTo().hasGravity()) {
            Entity entity = entityChangeBlockEvent.getEntity();
            List list = entity.getMetadata("plot");
            if (list.isEmpty()) {
                return;
            }
            Plot plot2 = (Plot)((MetadataValue)list.get(0)).value();
            if (plot2 != null && !plot2.equals(plot)) {
                entityChangeBlockEvent.setCancelled(true);
                entity.remove();
            }
        } else if (entityChangeBlockEvent.getTo() == Material.AIR) {
            entityChangeBlockEvent.getEntity().setMetadata("plot", (MetadataValue)new FixedMetadataValue((Plugin)PlotSquared.platform(), (Object)plot));
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onDamage(EntityDamageEvent entityDamageEvent) {
        if (entityDamageEvent.getEntityType() != EntityType.PLAYER) {
            return;
        }
        Location location = BukkitUtil.adapt(entityDamageEvent.getEntity().getLocation());
        PlotArea plotArea = location.getPlotArea();
        if (plotArea == null) {
            return;
        }
        Plot plot = location.getOwnedPlot();
        if (plot == null) {
            if (PlotFlagUtil.isAreaRoadFlagsAndFlagEquals(plotArea, InvincibleFlag.class, true)) {
                entityDamageEvent.setCancelled(true);
            }
            return;
        }
        if (((Boolean)plot.getFlag(InvincibleFlag.class)).booleanValue()) {
            plot.debug(entityDamageEvent.getEntity().getName() + " could not take damage because invincible = true");
            entityDamageEvent.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBigBoom(EntityExplodeEvent entityExplodeEvent) {
        Location location = BukkitUtil.adapt(entityExplodeEvent.getLocation());
        PlotArea plotArea = location.getPlotArea();
        boolean bl = location.isPlotArea();
        if (!bl) {
            if (!this.plotAreaManager.hasPlotArea(location.getWorldName())) {
                return;
            }
            return;
        }
        Plot plot = plotArea.getOwnedPlot(location);
        if (plot != null) {
            if (((Boolean)plot.getFlag(ExplosionFlag.class)).booleanValue()) {
                Object object;
                Object object2;
                List list = entityExplodeEvent.getEntity().getMetadata("plot");
                Plot plot2 = list.isEmpty() ? plot : (Plot)((MetadataValue)list.get(0)).value();
                if (this.lastRadius != 0.0f) {
                    object2 = entityExplodeEvent.getEntity().getNearbyEntities((double)this.lastRadius, (double)this.lastRadius, (double)this.lastRadius);
                    object = object2.iterator();
                    while (object.hasNext()) {
                        Entity entity = (Entity)object.next();
                        if (!(entity instanceof TNTPrimed) && !entity.getType().equals((Object)EntityType.MINECART_TNT) || entity.hasMetadata("plot")) continue;
                        entity.setMetadata("plot", (MetadataValue)new FixedMetadataValue((Plugin)PlotSquared.platform(), (Object)plot));
                    }
                    this.lastRadius = 0.0f;
                }
                object2 = entityExplodeEvent.blockList().iterator();
                while (object2.hasNext()) {
                    object = (Block)object2.next();
                    location = BukkitUtil.adapt(object.getLocation());
                    if (plotArea.contains(location.getX(), location.getZ()) && plot2.equals(plotArea.getOwnedPlot(location))) continue;
                    object2.remove();
                }
                return;
            }
            plot.debug("Explosion was cancelled because explosion = false");
        }
        entityExplodeEvent.setCancelled(true);
        if (Settings.General.ALWAYS_SHOW_EXPLOSIONS) {
            entityExplodeEvent.getLocation().getWorld().spawnParticle(Particle.EXPLOSION_HUGE, entityExplodeEvent.getLocation(), 0);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPeskyMobsChangeTheWorldLikeWTFEvent(EntityChangeBlockEvent entityChangeBlockEvent) {
        Plot plot;
        Entity entity = entityChangeBlockEvent.getEntity();
        Material material = entityChangeBlockEvent.getBlock().getType();
        Location location = BukkitUtil.adapt(entityChangeBlockEvent.getBlock().getLocation());
        PlotArea plotArea = location.getPlotArea();
        if (plotArea == null) {
            return;
        }
        if (entity instanceof FallingBlock) {
            return;
        }
        if (entity instanceof Boat) {
            if (material == Material.LILY_PAD) {
                return;
            }
        } else {
            if (entity instanceof Player) {
                Player player = (Player)entity;
                BukkitPlayer bukkitPlayer = BukkitUtil.adapt(player);
                if (material.toString().equals("POWDER_SNOW")) {
                    BlockType blockType = BukkitAdapter.asBlockType((Material)material);
                    if (!this.eventDispatcher.checkPlayerBlockEvent(bukkitPlayer, PlayerBlockEventType.TRIGGER_PHYSICAL, location, blockType, true)) {
                        entityChangeBlockEvent.setCancelled(true);
                    }
                    return;
                }
                return;
            }
            if (entity instanceof Projectile) {
                Projectile projectile = (Projectile)entity;
                Plot plot2 = plotArea.getPlot(location);
                ProjectileSource projectileSource = projectile.getShooter();
                if (projectileSource instanceof Player) {
                    BukkitPlayer bukkitPlayer = BukkitUtil.adapt((Player)projectileSource);
                    if (plot2 == null) {
                        if (!bukkitPlayer.hasPermission(Permission.PERMISSION_ADMIN_PROJECTILE_UNOWNED)) {
                            projectile.remove();
                            entityChangeBlockEvent.setCancelled(true);
                        }
                        return;
                    }
                    if (plot2.isAdded(((PlotPlayer)bukkitPlayer).getUUID()) || bukkitPlayer.hasPermission(Permission.PERMISSION_ADMIN_PROJECTILE_OTHER)) {
                        return;
                    }
                    projectile.remove();
                    entityChangeBlockEvent.setCancelled(true);
                    return;
                }
                if (!(projectileSource instanceof Entity) && projectileSource != null) {
                    if (plot2 == null) {
                        projectile.remove();
                        entityChangeBlockEvent.setCancelled(true);
                        return;
                    }
                    Location location2 = BukkitUtil.adapt(((BlockProjectileSource)projectileSource).getBlock().getLocation());
                    if (!plotArea.contains(location2.getX(), location2.getZ())) {
                        projectile.remove();
                        entityChangeBlockEvent.setCancelled(true);
                        return;
                    }
                    Plot plot3 = plotArea.getOwnedPlotAbs(location2);
                    if (plot3 == null || !PlotHandler.sameOwners(plot2, plot3)) {
                        projectile.remove();
                        entityChangeBlockEvent.setCancelled(true);
                    }
                    return;
                }
            }
        }
        if ((plot = plotArea.getOwnedPlot(location)) != null && !((Boolean)plot.getFlag(EntityChangeBlockFlag.class)).booleanValue()) {
            plot.debug(entity.getType() + " could not change block because entity-change-block = false");
            entityChangeBlockEvent.setCancelled(true);
        }
    }

    @EventHandler
    public void onPrime(ExplosionPrimeEvent explosionPrimeEvent) {
        this.lastRadius = explosionPrimeEvent.getRadius() + 1.0f;
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onVehicleCreate(VehicleCreateEvent vehicleCreateEvent) {
        Vehicle vehicle = vehicleCreateEvent.getVehicle();
        Location location = BukkitUtil.adapt(vehicle.getLocation());
        PlotArea plotArea = location.getPlotArea();
        if (plotArea == null) {
            return;
        }
        Plot plot = plotArea.getOwnedPlotAbs(location);
        if (plot == null || BukkitEntityUtil.checkEntity((Entity)vehicle, plot)) {
            vehicle.remove();
            return;
        }
        if (Settings.Enabled_Components.KILL_ROAD_VEHICLES) {
            vehicle.setMetadata("plot", (MetadataValue)new FixedMetadataValue((Plugin)PlotSquared.platform(), (Object)plot));
        }
    }
}

