/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.bukkit.listener;

import com.destroystokyo.paper.MaterialTags;
import com.google.common.base.Charsets;
import com.plotsquared.bukkit.listener.EntitySpawnListener;
import com.plotsquared.bukkit.listener.ForceFieldListener;
import com.plotsquared.bukkit.paperlib.PaperLib;
import com.plotsquared.bukkit.player.BukkitPlayer;
import com.plotsquared.bukkit.util.BukkitEntityUtil;
import com.plotsquared.bukkit.util.BukkitUtil;
import com.plotsquared.bukkit.util.UpdateUtility;
import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.configuration.adventure.text.Component;
import com.plotsquared.core.configuration.adventure.text.minimessage.MiniMessage;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.resolver.TagResolver;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.standard.StandardTags;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.listener.PlayerBlockEventType;
import com.plotsquared.core.listener.PlotListener;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.permissions.Permission;
import com.plotsquared.core.player.ConsolePlayer;
import com.plotsquared.core.player.MetaDataAccess;
import com.plotsquared.core.player.PlayerMetaDataKeys;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.PlotId;
import com.plotsquared.core.plot.PlotInventory;
import com.plotsquared.core.plot.flag.FlagContainer;
import com.plotsquared.core.plot.flag.implementations.AnimalInteractFlag;
import com.plotsquared.core.plot.flag.implementations.BlockedCmdsFlag;
import com.plotsquared.core.plot.flag.implementations.ChatFlag;
import com.plotsquared.core.plot.flag.implementations.DenyPortalTravelFlag;
import com.plotsquared.core.plot.flag.implementations.DenyPortalsFlag;
import com.plotsquared.core.plot.flag.implementations.DenyTeleportFlag;
import com.plotsquared.core.plot.flag.implementations.DoneFlag;
import com.plotsquared.core.plot.flag.implementations.DropProtectionFlag;
import com.plotsquared.core.plot.flag.implementations.HangingBreakFlag;
import com.plotsquared.core.plot.flag.implementations.HangingPlaceFlag;
import com.plotsquared.core.plot.flag.implementations.HostileInteractFlag;
import com.plotsquared.core.plot.flag.implementations.ItemDropFlag;
import com.plotsquared.core.plot.flag.implementations.KeepInventoryFlag;
import com.plotsquared.core.plot.flag.implementations.LecternReadBookFlag;
import com.plotsquared.core.plot.flag.implementations.MiscInteractFlag;
import com.plotsquared.core.plot.flag.implementations.PlayerInteractFlag;
import com.plotsquared.core.plot.flag.implementations.PreventCreativeCopyFlag;
import com.plotsquared.core.plot.flag.implementations.TamedInteractFlag;
import com.plotsquared.core.plot.flag.implementations.UntrustedVisitFlag;
import com.plotsquared.core.plot.flag.implementations.VehicleBreakFlag;
import com.plotsquared.core.plot.flag.implementations.VehicleUseFlag;
import com.plotsquared.core.plot.flag.implementations.VillagerInteractFlag;
import com.plotsquared.core.plot.world.PlotAreaManager;
import com.plotsquared.core.util.EventDispatcher;
import com.plotsquared.core.util.MathMan;
import com.plotsquared.core.util.PlotFlagUtil;
import com.plotsquared.core.util.PremiumVerification;
import com.plotsquared.core.util.entity.EntityCategories;
import com.plotsquared.core.util.task.TaskManager;
import com.plotsquared.core.util.task.TaskTime;
import com.plotsquared.google.Inject;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.world.block.BlockType;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.Waterlogged;
import org.bukkit.command.PluginCommand;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Boat;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Tameable;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.entity.EntityPlaceEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.hanging.HangingBreakByEntityEvent;
import org.bukkit.event.hanging.HangingPlaceEvent;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.AsyncPlayerPreLoginEvent;
import org.bukkit.event.player.PlayerBucketEmptyEvent;
import org.bukkit.event.player.PlayerBucketFillEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerLocaleChangeEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerPortalEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerTakeLecternBookEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.vehicle.VehicleDestroyEvent;
import org.bukkit.event.vehicle.VehicleEntityCollisionEvent;
import org.bukkit.event.vehicle.VehicleMoveEvent;
import org.bukkit.event.world.PortalCreateEvent;
import org.bukkit.help.HelpTopic;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.util.Vector;
import org.checkerframework.checker.nullness.qual.NonNull;

public class PlayerEventListener
implements Listener {
    private static final Set<Material> MINECARTS = Set.of(Material.MINECART, Material.TNT_MINECART, Material.CHEST_MINECART, Material.COMMAND_BLOCK_MINECART, Material.FURNACE_MINECART, Material.HOPPER_MINECART);
    private static final Set<Material> BOOKS = Set.of(Material.BOOK, Material.KNOWLEDGE_BOOK, Material.WRITABLE_BOOK, Material.WRITTEN_BOOK);
    private final EventDispatcher eventDispatcher;
    private final WorldEdit worldEdit;
    private final PlotAreaManager plotAreaManager;
    private final PlotListener plotListener;
    private boolean tmpTeleport = true;
    private Field fieldPlayer;
    private PlayerMoveEvent moveTmp;
    private String internalVersion;

    @Inject
    public PlayerEventListener(@NonNull PlotAreaManager plotAreaManager, @NonNull EventDispatcher eventDispatcher, @NonNull WorldEdit worldEdit, @NonNull PlotListener plotListener) {
        try {
            this.fieldPlayer = PlayerEvent.class.getDeclaredField("player");
            this.fieldPlayer.setAccessible(true);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            noSuchFieldException.printStackTrace();
        }
        this.eventDispatcher = eventDispatcher;
        this.worldEdit = worldEdit;
        this.plotAreaManager = plotAreaManager;
        this.plotListener = plotListener;
    }

    @EventHandler(ignoreCancelled=true)
    public void onEffect(@NonNull EntityPotionEffectEvent entityPotionEffectEvent) {
        Object object;
        if (Settings.Enabled_Components.DISABLE_BEACON_EFFECT_OVERFLOW || entityPotionEffectEvent.getCause() != EntityPotionEffectEvent.Cause.BEACON || !((object = entityPotionEffectEvent.getEntity()) instanceof Player)) {
            return;
        }
        Player player = (Player)object;
        object = player.getUniqueId();
        PotionEffect potionEffect = entityPotionEffectEvent.getNewEffect();
        if (potionEffect == null) {
            PotionEffect potionEffect2 = entityPotionEffectEvent.getOldEffect();
            if (potionEffect2 != null) {
                String string = potionEffect2.getType().getName();
                this.plotListener.addEffect((UUID)object, string, -1L);
            }
        } else {
            long l = System.currentTimeMillis() + (long)potionEffect.getDuration() * 50L;
            String string = potionEffect.getType().getName();
            this.plotListener.addEffect((UUID)object, string, l);
        }
    }

    @EventHandler
    public void onVehicleEntityCollision(VehicleEntityCollisionEvent vehicleEntityCollisionEvent) {
        Location location;
        if (vehicleEntityCollisionEvent.getVehicle().getType() == EntityType.BOAT && (location = BukkitUtil.adapt(vehicleEntityCollisionEvent.getEntity().getLocation())).isPlotArea()) {
            if (vehicleEntityCollisionEvent.getEntity() instanceof Player) {
                BukkitPlayer bukkitPlayer = BukkitUtil.adapt((Player)vehicleEntityCollisionEvent.getEntity());
                Plot plot = bukkitPlayer.getCurrentPlot();
                if (plot != null) {
                    if (!plot.isAdded(((PlotPlayer)bukkitPlayer).getUUID())) {
                        vehicleEntityCollisionEvent.setCancelled(true);
                    }
                } else {
                    vehicleEntityCollisionEvent.setCancelled(true);
                }
            } else {
                vehicleEntityCollisionEvent.setCancelled(true);
            }
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void playerCommand(PlayerCommandPreprocessEvent playerCommandPreprocessEvent) {
        Object object;
        Object object2;
        String string = playerCommandPreprocessEvent.getMessage().replace("/", "").toLowerCase(Locale.ROOT).trim();
        if (string.isEmpty()) {
            return;
        }
        Player player = playerCommandPreprocessEvent.getPlayer();
        BukkitPlayer bukkitPlayer = BukkitUtil.adapt(player);
        Location location = bukkitPlayer.getLocation();
        PlotArea plotArea = location.getPlotArea();
        if (plotArea == null) {
            return;
        }
        String[] stringArray = string.split(" ");
        Plot plot = bukkitPlayer.getCurrentPlot();
        switch (stringArray[0]) {
            case "up": 
            case "worldedit:up": {
                if (plot != null && (plot.isAdded(((PlotPlayer)bukkitPlayer).getUUID()) || bukkitPlayer.hasPermission(Permission.PERMISSION_ADMIN_BUILD_OTHER, true))) break;
                playerCommandPreprocessEvent.setCancelled(true);
                return;
            }
        }
        if (plot == null && !plotArea.isRoadFlags()) {
            return;
        }
        Object object3 = object2 = plot != null ? (List)plot.getFlag(BlockedCmdsFlag.class) : (List)plotArea.getFlag(BlockedCmdsFlag.class);
        if (object2.isEmpty()) {
            return;
        }
        if (bukkitPlayer.hasPermission(Permission.PERMISSION_ADMIN_INTERACT_BLOCKED_CMDS)) {
            return;
        }
        String string2 = stringArray[0];
        if (string2.contains(":")) {
            object = string2.split(":");
            string2 = object[1];
            string = string.substring(((String)object[0]).length() + 1);
        }
        string = this.replaceAliases(string, string2);
        object = object2.iterator();
        while (object.hasNext()) {
            String string3 = (String)object.next();
            if (!string3.equalsIgnoreCase(string)) continue;
            String string4 = plot != null && plot.isAdded(((PlotPlayer)bukkitPlayer).getUUID()) ? "plots.admin.command.blocked-cmds.shared" : "plots.admin.command.blocked-cmds.road";
            if (!bukkitPlayer.hasPermission(string4)) {
                bukkitPlayer.sendMessage((Caption)TranslatableCaption.of("blockedcmds.command_blocked"), new TagResolver[0]);
                playerCommandPreprocessEvent.setCancelled(true);
            }
            return;
        }
    }

    private String replaceAliases(String string, String string2) {
        HelpTopic helpTopic;
        String string3 = string2;
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = Bukkit.getServer().getHelpMap().getHelpTopics().iterator();
        block0: while (iterator.hasNext() && !string2.equals((helpTopic = (HelpTopic)iterator.next()).getName())) {
            PluginCommand pluginCommand;
            String string4 = helpTopic.getName().replaceFirst("/", "");
            if (hashSet.contains(string4) || (pluginCommand = Bukkit.getPluginCommand((String)string4)) == null) continue;
            for (String string5 : pluginCommand.getAliases()) {
                if (hashSet.contains(string5)) continue;
                hashSet.add(string5);
                if ((string5 = string5.replaceFirst("/", "")).equals(string4) || !string5.equals(string2)) continue;
                string2 = string4;
                continue block0;
            }
        }
        if (!string3.equals(string2)) {
            string = string.replace(string3, string2);
        }
        return string;
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPreLogin(AsyncPlayerPreLoginEvent asyncPlayerPreLoginEvent) {
        UUID uUID = Settings.UUID.OFFLINE ? (Settings.UUID.FORCE_LOWERCASE ? UUID.nameUUIDFromBytes(("OfflinePlayer:" + asyncPlayerPreLoginEvent.getName().toLowerCase()).getBytes(Charsets.UTF_8)) : UUID.nameUUIDFromBytes(("OfflinePlayer:" + asyncPlayerPreLoginEvent.getName()).getBytes(Charsets.UTF_8))) : asyncPlayerPreLoginEvent.getUniqueId();
        PlotSquared.get().getImpromptuUUIDPipeline().storeImmediately(asyncPlayerPreLoginEvent.getName(), uUID);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onConnect(PlayerJoinEvent playerJoinEvent) {
        Object object;
        Player player = playerJoinEvent.getPlayer();
        PlotSquared.platform().playerManager().removePlayer(player.getUniqueId());
        BukkitPlayer bukkitPlayer = BukkitUtil.adapt(player);
        bukkitPlayer.setLocale(Locale.forLanguageTag(player.getLocale().substring(0, 2)));
        Location location = bukkitPlayer.getLocation();
        PlotArea plotArea = location.getPlotArea();
        if (plotArea != null && (object = plotArea.getPlot(location)) != null) {
            this.plotListener.plotEntry(bukkitPlayer, (Plot)object);
        }
        TaskManager.runTaskLaterAsync(() -> {
            if (!player.hasPlayedBefore() && player.isOnline()) {
                player.saveData();
            }
            this.eventDispatcher.doJoinTask(bukkitPlayer);
        }, TaskTime.seconds(1L));
        if (bukkitPlayer.hasPermission(Permission.PERMISSION_ADMIN_UPDATE_NOTIFICATION.toString()) && Settings.Enabled_Components.UPDATE_NOTIFICATIONS && PremiumVerification.isPremium().booleanValue() && UpdateUtility.hasUpdate) {
            object = TranslatableCaption.of("update.update_boundary");
            TranslatableCaption translatableCaption = TranslatableCaption.of("update.update_notification");
            bukkitPlayer.sendMessage((Caption)object, new TagResolver[0]);
            bukkitPlayer.sendMessage((Caption)translatableCaption, TagResolver.builder().tag("p2version", com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag.inserting(Component.text(UpdateUtility.internalVersion.versionString()))).tag("spigotversion", com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag.inserting(Component.text(UpdateUtility.spigotVersion))).tag("downloadurl", com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag.preProcessParsed("https://www.spigotmc.org/resources/77506/updates")).build());
            bukkitPlayer.sendMessage((Caption)object, new TagResolver[0]);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void playerRespawn(PlayerRespawnEvent playerRespawnEvent) {
        Player player = playerRespawnEvent.getPlayer();
        BukkitPlayer bukkitPlayer = BukkitUtil.adapt(player);
        this.eventDispatcher.doRespawnTask(bukkitPlayer);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onTeleport(PlayerTeleportEvent playerTeleportEvent) {
        block17: {
            Player player = playerTeleportEvent.getPlayer();
            if (!player.isOnline()) {
                return;
            }
            BukkitPlayer bukkitPlayer = BukkitUtil.adapt(player);
            try (MetaDataAccess<Plot> metaDataAccess = bukkitPlayer.accessTemporaryMetaData(PlayerMetaDataKeys.TEMPORARY_LAST_PLOT);){
                boolean bl;
                Plot plot = metaDataAccess.get().orElse(null);
                org.bukkit.Location location = playerTeleportEvent.getTo();
                if (location == null) break block17;
                Location location2 = BukkitUtil.adapt(location);
                PlotArea plotArea = location2.getPlotArea();
                if (plotArea == null) {
                    if (plot != null) {
                        this.plotListener.plotExit(bukkitPlayer, plot);
                        metaDataAccess.remove();
                    }
                    try (MetaDataAccess<Location> metaDataAccess2 = bukkitPlayer.accessTemporaryMetaData(PlayerMetaDataKeys.TEMPORARY_LOCATION);){
                        metaDataAccess2.remove();
                    }
                    return;
                }
                Plot plot2 = plotArea.getPlot(location2);
                if (!(plot2 == null || (bl = DenyTeleportFlag.allowsTeleport(bukkitPlayer, plot2)) || ((Boolean)plot2.getFlag(UntrustedVisitFlag.class)).booleanValue() && plot2.getHomeSynchronous().equals(BukkitUtil.adaptComplete(location)))) {
                    bukkitPlayer.sendMessage((Caption)TranslatableCaption.of("deny.no_enter"), TagResolver.resolver("plot", com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag.inserting(Component.text(plot2.toString()))));
                    playerTeleportEvent.setCancelled(true);
                }
            }
        }
        this.playerMove((PlayerMoveEvent)playerTeleportEvent);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void vehicleMove(VehicleMoveEvent vehicleMoveEvent) {
        Vehicle vehicle;
        int n;
        org.bukkit.Location location = vehicleMoveEvent.getFrom();
        org.bukkit.Location location2 = vehicleMoveEvent.getTo();
        int n2 = MathMan.roundInt(location2.getX());
        if (n2 != MathMan.roundInt(location.getX()) | (n = MathMan.roundInt(location2.getZ())) != MathMan.roundInt(location.getZ()) && !(vehicle = vehicleMoveEvent.getVehicle()).getPassengers().isEmpty()) {
            Object object;
            List list;
            Player player;
            Entity entity = (Entity)vehicle.getPassengers().get(0);
            if (entity instanceof Player) {
                player = (Player)entity;
                if (this.moveTmp == null) {
                    this.moveTmp = new PlayerMoveEvent(null, location, location2);
                }
                this.moveTmp.setFrom(location);
                this.moveTmp.setTo(location2);
                this.moveTmp.setCancelled(false);
                this.fieldPlayer.set(this.moveTmp, player);
                list = vehicle.getPassengers();
                this.playerMove(this.moveTmp);
                object = this.moveTmp.isCancelled() ? location : (MathMan.roundInt(this.moveTmp.getTo().getX()) != n2 || MathMan.roundInt(this.moveTmp.getTo().getZ()) != n ? location2 : null);
                if (object != null) {
                    vehicle.eject();
                    vehicle.setVelocity(new Vector(0.0, 0.0, 0.0));
                    PaperLib.teleportAsync((Entity)vehicle, (org.bukkit.Location)object);
                    list.forEach(arg_0 -> ((Vehicle)vehicle).addPassenger(arg_0));
                    return;
                }
            }
            if (Settings.Enabled_Components.KILL_ROAD_VEHICLES && EntityCategories.VEHICLE.contains((com.sk89q.worldedit.registry.Keyed)(player = BukkitAdapter.adapt((EntityType)vehicle.getType()))) && !EntityCategories.ANIMAL.contains((com.sk89q.worldedit.registry.Keyed)player)) {
                list = vehicle.getMetadata("plot");
                object = BukkitUtil.adapt(location2).getPlot();
                if (!list.isEmpty()) {
                    Plot plot = (Plot)((MetadataValue)list.get(0)).value();
                    if (plot != null && !plot.getBasePlot(false).equals(object)) {
                        vehicle.remove();
                    }
                } else if (object != null) {
                    vehicle.setMetadata("plot", (MetadataValue)new FixedMetadataValue((Plugin)PlotSquared.platform(), object));
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void playerMove(PlayerMoveEvent playerMoveEvent) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        BukkitPlayer bukkitPlayer;
        org.bukkit.Location location = playerMoveEvent.getFrom();
        org.bukkit.Location location2 = playerMoveEvent.getTo();
        int n = MathMan.roundInt(location2.getX());
        if (MathMan.roundInt(location.getX()) != n) {
            Player player;
            block93: {
                player = playerMoveEvent.getPlayer();
                bukkitPlayer = BukkitUtil.adapt(player);
                if (TaskManager.removeFromTeleportQueue(bukkitPlayer.getName())) {
                    bukkitPlayer.sendMessage((Caption)TranslatableCaption.of("teleport.teleport_failed"), new TagResolver[0]);
                }
                object4 = BukkitUtil.adapt(location2);
                object3 = bukkitPlayer.accessTemporaryMetaData(PlayerMetaDataKeys.TEMPORARY_LOCATION);
                try {
                    ((MetaDataAccess)object3).remove();
                }
                finally {
                    if (object3 != null) {
                        ((MetaDataAccess)object3).close();
                    }
                }
                object3 = ((Location)object4).getPlotArea();
                if (object3 == null) {
                    try (MetaDataAccess<Plot> metaDataAccess = bukkitPlayer.accessTemporaryMetaData(PlayerMetaDataKeys.TEMPORARY_LAST_PLOT);){
                        metaDataAccess.remove();
                    }
                    return;
                }
                object2 = ((PlotArea)object3).getPlot((Location)object4);
                try (MetaDataAccess<Object> metaDataAccess = bukkitPlayer.accessTemporaryMetaData(PlayerMetaDataKeys.TEMPORARY_LAST_PLOT);){
                    object = metaDataAccess.get().orElse(null);
                }
                if (object2 == null) {
                    metaDataAccess = bukkitPlayer.accessTemporaryMetaData(PlayerMetaDataKeys.TEMPORARY_KICK);
                    try {
                        if (object != null && !this.plotListener.plotExit(bukkitPlayer, (Plot)object) && this.tmpTeleport && !((Boolean)metaDataAccess.get().orElse(false)).booleanValue()) {
                            bukkitPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_permission_event"), TagResolver.resolver("node", com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag.inserting(Permission.PERMISSION_ADMIN_EXIT_DENIED)));
                            this.tmpTeleport = false;
                            if (((Plot)object).equals(BukkitUtil.adapt(location).getPlot())) {
                                player.teleport(location);
                            } else {
                                player.teleport(player.getWorld().getSpawnLocation());
                            }
                            this.tmpTeleport = true;
                            playerMoveEvent.setCancelled(true);
                            return;
                        }
                        break block93;
                    }
                    finally {
                        if (metaDataAccess != null) {
                            metaDataAccess.close();
                        }
                    }
                }
                if (((Plot)object2).equals(object)) {
                    ForceFieldListener.handleForcefield(player, bukkitPlayer, (Plot)object2);
                } else if (!this.plotListener.plotEntry(bukkitPlayer, (Plot)object2) && this.tmpTeleport) {
                    bukkitPlayer.sendMessage((Caption)TranslatableCaption.of("deny.no_enter"), TagResolver.resolver("plot", com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag.inserting(Component.text(((Plot)object2).toString()))));
                    this.tmpTeleport = false;
                    location2.setX((double)location.getBlockX());
                    location2.setY((double)location.getBlockY());
                    location2.setZ((double)location.getBlockZ());
                    player.teleport(playerMoveEvent.getTo());
                    this.tmpTeleport = true;
                    return;
                }
            }
            int n2 = ((PlotArea)object3).getBorder(true);
            if (n > n2 && this.tmpTeleport) {
                if (!bukkitPlayer.hasPermission(Permission.PERMISSION_ADMIN_BYPASS_BORDER)) {
                    location2.setX((double)(n2 - 1));
                    this.tmpTeleport = false;
                    player.teleport(playerMoveEvent.getTo());
                    this.tmpTeleport = true;
                    bukkitPlayer.sendMessage((Caption)TranslatableCaption.of("border.denied"), new TagResolver[0]);
                } else if (MathMan.roundInt(location.getX()) <= n2) {
                    bukkitPlayer.sendMessage((Caption)TranslatableCaption.of("border.bypass.exited"), new TagResolver[0]);
                }
            } else if (n < -n2 && this.tmpTeleport) {
                if (!bukkitPlayer.hasPermission(Permission.PERMISSION_ADMIN_BYPASS_BORDER)) {
                    location2.setX((double)(-n2 + 1));
                    this.tmpTeleport = false;
                    player.teleport(playerMoveEvent.getTo());
                    this.tmpTeleport = true;
                    bukkitPlayer.sendMessage((Caption)TranslatableCaption.of("border.denied"), new TagResolver[0]);
                } else if (MathMan.roundInt(location.getX()) >= -n2) {
                    bukkitPlayer.sendMessage((Caption)TranslatableCaption.of("border.bypass.exited"), new TagResolver[0]);
                }
            } else {
                int n3 = MathMan.roundInt(location.getX());
                if ((n3 >= n2 && n <= n2 || n3 <= -n2 && n >= -n2) && bukkitPlayer.hasPermission(Permission.PERMISSION_ADMIN_BYPASS_BORDER)) {
                    bukkitPlayer.sendMessage((Caption)TranslatableCaption.of("border.bypass.entered"), new TagResolver[0]);
                }
            }
        }
        int n4 = MathMan.roundInt(location2.getZ());
        if (MathMan.roundInt(location.getZ()) != n4) {
            block97: {
                Plot plot;
                bukkitPlayer = playerMoveEvent.getPlayer();
                object4 = BukkitUtil.adapt((Player)bukkitPlayer);
                if (TaskManager.removeFromTeleportQueue(((BukkitPlayer)object4).getName())) {
                    ((PlotPlayer)object4).sendMessage((Caption)TranslatableCaption.of("teleport.teleport_failed"), new TagResolver[0]);
                }
                object3 = BukkitUtil.adapt(location2);
                object2 = ((PlotPlayer)object4).accessTemporaryMetaData(PlayerMetaDataKeys.TEMPORARY_LOCATION);
                try {
                    ((MetaDataAccess)object2).set((Location)object3);
                }
                finally {
                    if (object2 != null) {
                        ((MetaDataAccess)object2).close();
                    }
                }
                object2 = ((Location)object3).getPlotArea();
                if (object2 == null) {
                    object = ((PlotPlayer)object4).accessTemporaryMetaData(PlayerMetaDataKeys.TEMPORARY_LAST_PLOT);
                    try {
                        ((MetaDataAccess)object).remove();
                    }
                    finally {
                        if (object != null) {
                            ((MetaDataAccess)object).close();
                        }
                    }
                    return;
                }
                object = ((PlotArea)object2).getPlot((Location)object3);
                try (MetaDataAccess<Object> metaDataAccess = ((PlotPlayer)object4).accessTemporaryMetaData(PlayerMetaDataKeys.TEMPORARY_LAST_PLOT);){
                    plot = metaDataAccess.get().orElse(null);
                }
                if (object == null) {
                    metaDataAccess = ((PlotPlayer)object4).accessTemporaryMetaData(PlayerMetaDataKeys.TEMPORARY_KICK);
                    try {
                        if (plot != null && !this.plotListener.plotExit((PlotPlayer<?>)object4, plot) && this.tmpTeleport && !((Boolean)metaDataAccess.get().orElse(false)).booleanValue()) {
                            ((PlotPlayer)object4).sendMessage((Caption)TranslatableCaption.of("permission.no_permission_event"), TagResolver.resolver("node", com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag.inserting(Permission.PERMISSION_ADMIN_EXIT_DENIED)));
                            this.tmpTeleport = false;
                            if (plot.equals(BukkitUtil.adapt(location).getPlot())) {
                                bukkitPlayer.teleport(location);
                            } else {
                                bukkitPlayer.teleport(bukkitPlayer.getWorld().getSpawnLocation());
                            }
                            this.tmpTeleport = true;
                            playerMoveEvent.setCancelled(true);
                            return;
                        }
                        break block97;
                    }
                    finally {
                        if (metaDataAccess != null) {
                            metaDataAccess.close();
                        }
                    }
                }
                if (((Plot)object).equals(plot)) {
                    ForceFieldListener.handleForcefield((Player)bukkitPlayer, object4, (Plot)object);
                } else if (!this.plotListener.plotEntry((PlotPlayer<?>)object4, (Plot)object) && this.tmpTeleport) {
                    ((PlotPlayer)object4).sendMessage((Caption)TranslatableCaption.of("deny.no_enter"), TagResolver.resolver("plot", com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag.inserting(Component.text(((Plot)object).toString()))));
                    this.tmpTeleport = false;
                    bukkitPlayer.teleport(location);
                    location2.setX((double)location.getBlockX());
                    location2.setY((double)location.getBlockY());
                    location2.setZ((double)location.getBlockZ());
                    bukkitPlayer.teleport(playerMoveEvent.getTo());
                    this.tmpTeleport = true;
                    return;
                }
            }
            int n5 = ((PlotArea)object2).getBorder(true);
            if (n4 > n5 && this.tmpTeleport) {
                if (!object4.hasPermission(Permission.PERMISSION_ADMIN_BYPASS_BORDER)) {
                    location2.setZ((double)(n5 - 1));
                    this.tmpTeleport = false;
                    bukkitPlayer.teleport(playerMoveEvent.getTo());
                    this.tmpTeleport = true;
                    ((PlotPlayer)object4).sendMessage((Caption)TranslatableCaption.of("border.denied"), new TagResolver[0]);
                } else if (MathMan.roundInt(location.getZ()) <= n5) {
                    ((PlotPlayer)object4).sendMessage((Caption)TranslatableCaption.of("border.bypass.exited"), new TagResolver[0]);
                }
            } else if (n4 < -n5 && this.tmpTeleport) {
                if (!object4.hasPermission(Permission.PERMISSION_ADMIN_BYPASS_BORDER)) {
                    location2.setZ((double)(-n5 + 1));
                    this.tmpTeleport = false;
                    bukkitPlayer.teleport(playerMoveEvent.getTo());
                    this.tmpTeleport = true;
                    ((PlotPlayer)object4).sendMessage((Caption)TranslatableCaption.of("border.denied"), new TagResolver[0]);
                } else if (MathMan.roundInt(location.getZ()) >= -n5) {
                    ((PlotPlayer)object4).sendMessage((Caption)TranslatableCaption.of("border.bypass.exited"), new TagResolver[0]);
                }
            } else {
                int n6 = MathMan.roundInt(location.getZ());
                if ((n6 >= n5 && n4 <= n5 || n6 <= -n5 && n4 >= -n5) && object4.hasPermission(Permission.PERMISSION_ADMIN_BYPASS_BORDER)) {
                    ((PlotPlayer)object4).sendMessage((Caption)TranslatableCaption.of("border.bypass.entered"), new TagResolver[0]);
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onChat(AsyncPlayerChatEvent asyncPlayerChatEvent) {
        Object object;
        Object object2;
        PlotPlayer<?> plotPlayer22;
        if (asyncPlayerChatEvent.isCancelled()) {
            return;
        }
        BukkitPlayer bukkitPlayer = BukkitUtil.adapt(asyncPlayerChatEvent.getPlayer());
        Location location = bukkitPlayer.getLocation();
        PlotArea plotArea = location.getPlotArea();
        if (plotArea == null) {
            return;
        }
        Plot plot = plotArea.getPlot(location);
        if (plot == null) {
            return;
        }
        if (!(((Boolean)plot.getFlag(ChatFlag.class)).booleanValue() && plotArea.isPlotChat() && bukkitPlayer.getAttribute("chat") || plotArea.isForcingPlotChat())) {
            return;
        }
        if (plot.isDenied(bukkitPlayer.getUUID()) && !bukkitPlayer.hasPermission(Permission.PERMISSION_ADMIN_CHAT_BYPASS)) {
            return;
        }
        asyncPlayerChatEvent.setCancelled(true);
        Set set = asyncPlayerChatEvent.getRecipients();
        set.clear();
        HashSet<Object> hashSet = new HashSet<Object>();
        HashSet<Object> hashSet2 = new HashSet<Object>();
        for (PlotPlayer<?> plotPlayer22 : PlotSquared.platform().playerManager().getPlayers()) {
            if (plotPlayer22.getAttribute("chatspy")) {
                hashSet.add(plotPlayer22);
                continue;
            }
            object2 = plotPlayer22.getCurrentPlot();
            if (object2 == null || !((Plot)object2).getBasePlot(false).equals(plot)) continue;
            hashSet2.add(plotPlayer22);
        }
        String string = asyncPlayerChatEvent.getMessage();
        plotPlayer22 = asyncPlayerChatEvent.getPlayer().getDisplayName();
        object2 = plot.getId();
        String string2 = plot.getWorldName();
        TranslatableCaption translatableCaption = TranslatableCaption.of("chat.plot_chat_format");
        TagResolver.Builder builder = TagResolver.builder();
        builder.tag("world", com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag.inserting(Component.text(string2)));
        builder.tag("plot_id", com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag.inserting(Component.text(((PlotId)object2).toString())));
        builder.tag("sender", com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag.inserting(Component.text((String)((Object)plotPlayer22))));
        if (bukkitPlayer.hasPermission("plots.chat.color")) {
            builder.tag("msg", com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag.inserting(MiniMessage.miniMessage().deserialize(string, TagResolver.resolver(StandardTags.color(), StandardTags.gradient(), StandardTags.rainbow(), StandardTags.decorations()))));
        } else {
            builder.tag("msg", com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag.inserting(Component.text(string)));
        }
        for (Object object3 : hashSet2) {
            ((PlotPlayer)object3).sendMessage((Caption)translatableCaption, builder.build());
        }
        if (!hashSet.isEmpty()) {
            object = TranslatableCaption.of("chat.plot_chat_spy_format");
            for (PlotPlayer plotPlayer3 : hashSet) {
                plotPlayer3.sendMessage((Caption)object, builder.tag("message", com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag.inserting(Component.text(string))).build());
            }
        }
        if (Settings.Chat.LOG_PLOTCHAT_TO_CONSOLE) {
            object = TranslatableCaption.of("chat.plot_chat_spy_format");
            ConsolePlayer.getConsole().sendMessage((Caption)object, builder.tag("message", com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag.inserting(Component.text(string))).build());
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onWorldChanged(PlayerChangedWorldEvent playerChangedWorldEvent) {
        Plot plot;
        Player player = playerChangedWorldEvent.getPlayer();
        BukkitPlayer bukkitPlayer = BukkitUtil.adapt(player);
        try (Object object = bukkitPlayer.accessTemporaryMetaData(PlayerMetaDataKeys.TEMPORARY_LAST_PLOT);){
            plot = ((MetaDataAccess)object).remove();
        }
        object = bukkitPlayer.accessTemporaryMetaData(PlayerMetaDataKeys.TEMPORARY_LOCATION);
        try {
            ((MetaDataAccess)object).remove();
        }
        finally {
            if (object != null) {
                ((MetaDataAccess)object).close();
            }
        }
        if (plot != null) {
            this.plotListener.plotExit(bukkitPlayer, plot);
        }
        if (this.worldEdit != null && !bukkitPlayer.hasPermission(Permission.PERMISSION_WORLDEDIT_BYPASS) && bukkitPlayer.getAttribute("worldedit")) {
            bukkitPlayer.removeAttribute("worldedit");
        }
        object = bukkitPlayer.getLocation();
        PlotArea plotArea = ((Location)object).getPlotArea();
        if (((Location)object).isPlotArea() && (plot = ((Location)object).getPlot()) != null) {
            this.plotListener.plotEntry(bukkitPlayer, plot);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onInventoryClick(InventoryClickEvent inventoryClickEvent) {
        Location location;
        PlotArea plotArea;
        List list;
        Object object;
        PlayerInventory playerInventory;
        int n;
        HumanEntity humanEntity = inventoryClickEvent.getWhoClicked();
        if (!(humanEntity instanceof Player) || !this.plotAreaManager.hasPlotArea(humanEntity.getWorld().getName())) {
            return;
        }
        HumanEntity humanEntity2 = inventoryClickEvent.getWhoClicked();
        if (!(humanEntity2 instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity2;
        BukkitPlayer bukkitPlayer = BukkitUtil.adapt(player);
        PlotInventory plotInventory = PlotInventory.getOpenPlotInventory(bukkitPlayer);
        if (plotInventory != null && inventoryClickEvent.getRawSlot() == inventoryClickEvent.getSlot() && !plotInventory.onClick(inventoryClickEvent.getSlot())) {
            inventoryClickEvent.setResult(Event.Result.DENY);
            inventoryClickEvent.setCancelled(true);
            plotInventory.close();
        }
        if ((n = (playerInventory = player.getInventory()).getHeldItemSlot()) > 8 || !inventoryClickEvent.getEventName().equals("InventoryCreativeEvent")) {
            return;
        }
        ItemStack itemStack = playerInventory.getItemInHand();
        ItemMeta itemMeta = itemStack.getItemMeta();
        ItemStack itemStack2 = inventoryClickEvent.getCursor();
        ItemMeta itemMeta2 = itemStack2.getItemMeta();
        if (inventoryClickEvent.getClick() == ClickType.CREATIVE) {
            Plot plot = bukkitPlayer.getCurrentPlot();
            if (plot != null) {
                if (((Boolean)plot.getFlag(PreventCreativeCopyFlag.class)).booleanValue() && !plot.isAdded(player.getUniqueId()) && !bukkitPlayer.hasPermission(Permission.PERMISSION_ADMIN_INTERACT_OTHER)) {
                    ItemStack itemStack3 = new ItemStack(itemStack2.getType(), itemStack2.getAmount());
                    inventoryClickEvent.setCursor(itemStack3);
                    plot.debug(player.getName() + " could not creative-copy an item because prevent-creative-copy = true");
                }
            } else {
                PlotArea plotArea2 = bukkitPlayer.getPlotAreaAbs();
                if (plotArea2 != null && PlotFlagUtil.isAreaRoadFlagsAndFlagEquals(plotArea2, PreventCreativeCopyFlag.class, true)) {
                    ItemStack itemStack4 = new ItemStack(itemStack2.getType(), itemStack2.getAmount());
                    inventoryClickEvent.setCursor(itemStack4);
                }
            }
            return;
        }
        String string = "";
        if (itemMeta2 != null && (object = itemMeta2.getLore()) != null) {
            string = object.toString();
        }
        object = "";
        if (itemMeta != null && (list = itemMeta.getLore()) != null) {
            object = list.toString();
        }
        list = itemStack2.getType();
        if ((!"[(+NBT)]".equals(string) || itemStack.equals((Object)itemStack2) && string.equals(object)) && (itemMeta2 == null || list != Material.LEGACY_BANNER && list != Material.PLAYER_HEAD)) {
            return;
        }
        Block block = player.getTargetBlock(null, 7);
        BlockState blockState = block.getState();
        Material material = blockState.getType();
        if (material != list) {
            if (material == Material.LEGACY_WALL_BANNER || material == Material.LEGACY_STANDING_BANNER) {
                if (list != Material.LEGACY_BANNER) {
                    return;
                }
            } else if (material == Material.LEGACY_SKULL) {
                if (list != Material.LEGACY_SKULL_ITEM) {
                    return;
                }
            } else {
                return;
            }
        }
        if ((plotArea = (location = BukkitUtil.adapt(blockState.getLocation())).getPlotArea()) == null) {
            return;
        }
        Plot plot = plotArea.getPlotAbs(location);
        boolean bl = false;
        if (plot == null) {
            if (!bukkitPlayer.hasPermission(Permission.PERMISSION_ADMIN_INTERACT_ROAD)) {
                bukkitPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_permission_event"), TagResolver.resolver("node", com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag.inserting(Permission.PERMISSION_ADMIN_INTERACT_ROAD)));
                bl = true;
            }
        } else if (!plot.hasOwner()) {
            if (!bukkitPlayer.hasPermission(Permission.PERMISSION_ADMIN_INTERACT_UNOWNED)) {
                bukkitPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_permission_event"), TagResolver.resolver("node", com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag.inserting(Permission.PERMISSION_ADMIN_INTERACT_UNOWNED)));
                bl = true;
            }
        } else {
            UUID uUID = bukkitPlayer.getUUID();
            if (!plot.isAdded(uUID) && !bukkitPlayer.hasPermission(Permission.PERMISSION_ADMIN_INTERACT_OTHER)) {
                bukkitPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_permission_event"), TagResolver.resolver("node", com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag.inserting(Permission.PERMISSION_ADMIN_INTERACT_OTHER)));
                bl = true;
            }
        }
        if (bl) {
            if (itemStack.getType() == itemStack2.getType() && itemStack.getDurability() == itemStack2.getDurability()) {
                inventoryClickEvent.setCursor(new ItemStack(itemStack2.getType(), itemStack2.getAmount(), itemStack2.getDurability()));
                inventoryClickEvent.setCancelled(true);
                return;
            }
            inventoryClickEvent.setCursor(new ItemStack(itemStack2.getType(), itemStack2.getAmount(), itemStack2.getDurability()));
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onInteract(PlayerInteractAtEntityEvent playerInteractAtEntityEvent) {
        Entity entity = playerInteractAtEntityEvent.getRightClicked();
        if (!(entity instanceof ArmorStand) && !(entity instanceof ItemFrame)) {
            return;
        }
        Location location = BukkitUtil.adapt(playerInteractAtEntityEvent.getRightClicked().getLocation());
        PlotArea plotArea = location.getPlotArea();
        if (plotArea == null) {
            return;
        }
        EntitySpawnListener.testNether(entity);
        Plot plot = location.getPlotAbs();
        BukkitPlayer bukkitPlayer = BukkitUtil.adapt(playerInteractAtEntityEvent.getPlayer());
        if (plot == null) {
            if (!PlotFlagUtil.isAreaRoadFlagsAndFlagEquals(plotArea, MiscInteractFlag.class, true) && !bukkitPlayer.hasPermission(Permission.PERMISSION_ADMIN_INTERACT_ROAD)) {
                bukkitPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_permission_event"), TagResolver.resolver("node", com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag.inserting(Permission.PERMISSION_ADMIN_INTERACT_ROAD)));
                playerInteractAtEntityEvent.setCancelled(true);
            }
        } else {
            if (Settings.Done.RESTRICT_BUILDING && DoneFlag.isDone(plot) && !bukkitPlayer.hasPermission(Permission.PERMISSION_ADMIN_BUILD_OTHER)) {
                bukkitPlayer.sendMessage((Caption)TranslatableCaption.of("done.building_restricted"), new TagResolver[0]);
                playerInteractAtEntityEvent.setCancelled(true);
                return;
            }
            if (!plot.hasOwner()) {
                if (!bukkitPlayer.hasPermission("plots.admin.interact.unowned")) {
                    bukkitPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_permission_event"), TagResolver.resolver("node", com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag.inserting(Permission.PERMISSION_ADMIN_INTERACT_UNOWNED)));
                    playerInteractAtEntityEvent.setCancelled(true);
                }
            } else {
                UUID uUID = bukkitPlayer.getUUID();
                if (plot.isAdded(uUID)) {
                    return;
                }
                if (((Boolean)plot.getFlag(MiscInteractFlag.class)).booleanValue()) {
                    return;
                }
                if (!bukkitPlayer.hasPermission(Permission.PERMISSION_ADMIN_INTERACT_OTHER)) {
                    bukkitPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_permission_event"), TagResolver.resolver("node", com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag.inserting(Permission.PERMISSION_ADMIN_INTERACT_OTHER)));
                    playerInteractAtEntityEvent.setCancelled(true);
                    plot.debug(bukkitPlayer.getName() + " could not interact with " + entity.getType() + " because misc-interact = false");
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onCancelledInteract(PlayerInteractEvent playerInteractEvent) {
        if (playerInteractEvent.isCancelled() && playerInteractEvent.getAction() == Action.RIGHT_CLICK_AIR) {
            Location location;
            Block block;
            Material material;
            Player player = playerInteractEvent.getPlayer();
            BukkitPlayer bukkitPlayer = BukkitUtil.adapt(player);
            PlotArea plotArea = bukkitPlayer.getPlotAreaAbs();
            if (plotArea == null) {
                return;
            }
            if (playerInteractEvent.getAction() == Action.RIGHT_CLICK_AIR && (material = playerInteractEvent.getMaterial()).toString().toLowerCase().endsWith("_egg")) {
                playerInteractEvent.setCancelled(true);
                playerInteractEvent.setUseItemInHand(Event.Result.DENY);
            }
            material = player.getInventory().getItemInMainHand();
            ItemStack itemStack = player.getInventory().getItemInOffHand();
            Material material2 = material.getType();
            Material material3 = itemStack.getType();
            if (material2 == Material.AIR) {
                material2 = material3;
            }
            if (material2.toString().toLowerCase().endsWith("_egg") && (block = player.getTargetBlockExact(5, FluidCollisionMode.SOURCE_ONLY)) != null && block.getType() != Material.AIR && !this.eventDispatcher.checkPlayerBlockEvent(bukkitPlayer, PlayerBlockEventType.SPAWN_MOB, location = BukkitUtil.adapt(block.getLocation()), null, true)) {
                playerInteractEvent.setCancelled(true);
                playerInteractEvent.setUseItemInHand(Event.Result.DENY);
            }
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onInteract(PlayerInteractEvent playerInteractEvent) {
        BlockType blockType;
        PlayerBlockEventType playerBlockEventType;
        Player player = playerInteractEvent.getPlayer();
        BukkitPlayer bukkitPlayer = BukkitUtil.adapt(player);
        PlotArea plotArea = bukkitPlayer.getPlotAreaAbs();
        if (plotArea == null) {
            return;
        }
        Block block = playerInteractEvent.getClickedBlock();
        if (block == null) {
            return;
        }
        Location location = BukkitUtil.adapt(block.getLocation());
        Action action = playerInteractEvent.getAction();
        switch (action) {
            case PHYSICAL: {
                playerBlockEventType = PlayerBlockEventType.TRIGGER_PHYSICAL;
                blockType = BukkitAdapter.asBlockType((Material)block.getType());
                break;
            }
            case RIGHT_CLICK_BLOCK: {
                Material material;
                Material material2 = block.getType();
                playerBlockEventType = PlayerBlockEventType.INTERACT_BLOCK;
                blockType = BukkitAdapter.asBlockType((Material)block.getType());
                if (material2.isInteractable()) {
                    if (!player.isSneaking()) break;
                    material = player.getInventory().getItemInMainHand();
                    String string = player.getInventory().getItemInOffHand();
                    if (material.getType() == Material.AIR && string.getType() == Material.AIR) break;
                }
                material = playerInteractEvent.getMaterial();
                switch (material.toString()) {
                    case "REDSTONE": 
                    case "STRING": 
                    case "PUMPKIN_SEEDS": 
                    case "MELON_SEEDS": 
                    case "COCOA_BEANS": 
                    case "WHEAT_SEEDS": 
                    case "BEETROOT_SEEDS": 
                    case "SWEET_BERRIES": 
                    case "GLOW_BERRIES": {
                        return;
                    }
                }
                if (material.isBlock()) {
                    return;
                }
                if (PaperLib.isPaper()) {
                    if (MaterialTags.SPAWN_EGGS.isTagged(material) || Material.EGG.equals((Object)material)) {
                        playerBlockEventType = PlayerBlockEventType.SPAWN_MOB;
                        break;
                    }
                } else if (material.toString().toLowerCase().endsWith("egg")) {
                    playerBlockEventType = PlayerBlockEventType.SPAWN_MOB;
                    break;
                }
                if (material.isEdible()) {
                    return;
                }
                if (material == Material.ARMOR_STAND) {
                    location = BukkitUtil.adapt(block.getRelative(playerInteractEvent.getBlockFace()).getLocation());
                    playerBlockEventType = PlayerBlockEventType.PLACE_MISC;
                }
                if (Tag.ITEMS_BOATS.isTagged((Keyed)material) || MINECARTS.contains(material)) {
                    playerBlockEventType = PlayerBlockEventType.PLACE_VEHICLE;
                    break;
                }
                if (material == Material.FIREWORK_ROCKET || material == Material.FIREWORK_STAR) {
                    playerBlockEventType = PlayerBlockEventType.SPAWN_MOB;
                    break;
                }
                if (!BOOKS.contains(material)) break;
                playerBlockEventType = PlayerBlockEventType.READ;
                break;
            }
            case LEFT_CLICK_BLOCK: {
                Material material = block.getType();
                if (material != Material.DRAGON_EGG) {
                    return;
                }
                playerBlockEventType = PlayerBlockEventType.INTERACT_BLOCK;
                blockType = BukkitAdapter.asBlockType((Material)block.getType());
                break;
            }
            default: {
                return;
            }
        }
        if (this.worldEdit != null && bukkitPlayer.getAttribute("worldedit") && playerInteractEvent.getMaterial() == Material.getMaterial((String)this.worldEdit.getConfiguration().wandItem)) {
            return;
        }
        if (!this.eventDispatcher.checkPlayerBlockEvent(bukkitPlayer, playerBlockEventType, location, blockType, true)) {
            playerInteractEvent.setCancelled(true);
            playerInteractEvent.setUseInteractedBlock(Event.Result.DENY);
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onBoatPlace(EntityPlaceEvent entityPlaceEvent) {
        Player player = entityPlaceEvent.getPlayer();
        if (player == null) {
            return;
        }
        Entity entity = entityPlaceEvent.getEntity();
        if (!(entity instanceof Boat)) {
            return;
        }
        BukkitPlayer bukkitPlayer = BukkitUtil.adapt(entityPlaceEvent.getPlayer());
        PlotArea plotArea = bukkitPlayer.getPlotAreaAbs();
        if (plotArea == null) {
            return;
        }
        PlayerBlockEventType playerBlockEventType = PlayerBlockEventType.PLACE_VEHICLE;
        Block block = entityPlaceEvent.getBlock();
        BlockType blockType = BukkitAdapter.asBlockType((Material)block.getType());
        Location location = BukkitUtil.adapt(block.getLocation());
        if (!PlotSquared.get().getEventDispatcher().checkPlayerBlockEvent(bukkitPlayer, playerBlockEventType, location, blockType, true)) {
            entityPlaceEvent.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBucketEmpty(PlayerBucketEmptyEvent playerBucketEmptyEvent) {
        Object object;
        BlockFace blockFace = playerBucketEmptyEvent.getBlockFace();
        Object object2 = playerBucketEmptyEvent.getBlockClicked().getBlockData();
        Block block = object2 instanceof Waterlogged && !(object = (Waterlogged)object2).isWaterlogged() && playerBucketEmptyEvent.getBucket() != Material.LAVA_BUCKET ? playerBucketEmptyEvent.getBlockClicked() : playerBucketEmptyEvent.getBlockClicked().getLocation().add((double)blockFace.getModX(), (double)blockFace.getModY(), (double)blockFace.getModZ()).getBlock();
        object = BukkitUtil.adapt(block.getLocation());
        object2 = ((Location)object).getPlotArea();
        if (object2 == null) {
            return;
        }
        BukkitPlayer bukkitPlayer = BukkitUtil.adapt(playerBucketEmptyEvent.getPlayer());
        Plot plot = ((PlotArea)object2).getPlot((Location)object);
        if (plot == null) {
            if (bukkitPlayer.hasPermission(Permission.PERMISSION_ADMIN_BUILD_ROAD)) {
                return;
            }
            bukkitPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_permission_event"), TagResolver.resolver("node", com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag.inserting(Permission.PERMISSION_ADMIN_BUILD_ROAD)));
            playerBucketEmptyEvent.setCancelled(true);
        } else if (!plot.hasOwner()) {
            if (bukkitPlayer.hasPermission(Permission.PERMISSION_ADMIN_BUILD_UNOWNED)) {
                return;
            }
            bukkitPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_permission_event"), TagResolver.resolver("node", com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag.inserting(Permission.PERMISSION_ADMIN_BUILD_UNOWNED)));
            playerBucketEmptyEvent.setCancelled(true);
        } else if (!plot.isAdded(bukkitPlayer.getUUID())) {
            if (bukkitPlayer.hasPermission(Permission.PERMISSION_ADMIN_BUILD_OTHER)) {
                return;
            }
            bukkitPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_permission_event"), TagResolver.resolver("node", com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag.inserting(Permission.PERMISSION_ADMIN_BUILD_OTHER)));
            playerBucketEmptyEvent.setCancelled(true);
        } else if (Settings.Done.RESTRICT_BUILDING && DoneFlag.isDone(plot) && !bukkitPlayer.hasPermission(Permission.PERMISSION_ADMIN_BUILD_OTHER)) {
            bukkitPlayer.sendMessage((Caption)TranslatableCaption.of("done.building_restricted"), new TagResolver[0]);
            playerBucketEmptyEvent.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onInventoryClose(InventoryCloseEvent inventoryCloseEvent) {
        HumanEntity humanEntity = inventoryCloseEvent.getPlayer();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        PlotInventory.removePlotInventoryOpen(BukkitUtil.adapt(player));
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onLeave(PlayerQuitEvent playerQuitEvent) {
        TaskManager.removeFromTeleportQueue(playerQuitEvent.getPlayer().getName());
        BukkitPlayer bukkitPlayer = BukkitUtil.adapt(playerQuitEvent.getPlayer());
        bukkitPlayer.unregister();
        this.plotListener.logout(bukkitPlayer.getUUID());
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBucketFill(PlayerBucketFillEvent playerBucketFillEvent) {
        Block block = playerBucketFillEvent.getBlockClicked();
        Location location = BukkitUtil.adapt(block.getLocation());
        PlotArea plotArea = location.getPlotArea();
        if (plotArea == null) {
            return;
        }
        Player player = playerBucketFillEvent.getPlayer();
        BukkitPlayer bukkitPlayer = BukkitUtil.adapt(player);
        Plot plot = plotArea.getPlot(location);
        if (plot == null) {
            if (bukkitPlayer.hasPermission(Permission.PERMISSION_ADMIN_BUILD_ROAD)) {
                return;
            }
            bukkitPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_permission_event"), TagResolver.resolver("node", com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag.inserting(Permission.PERMISSION_ADMIN_BUILD_ROAD)));
            playerBucketFillEvent.setCancelled(true);
        } else if (!plot.hasOwner()) {
            if (bukkitPlayer.hasPermission(Permission.PERMISSION_ADMIN_BUILD_UNOWNED)) {
                return;
            }
            bukkitPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_permission_event"), TagResolver.resolver("node", com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag.inserting(Permission.PERMISSION_ADMIN_BUILD_UNOWNED)));
            playerBucketFillEvent.setCancelled(true);
        } else if (!plot.isAdded(bukkitPlayer.getUUID())) {
            if (bukkitPlayer.hasPermission(Permission.PERMISSION_ADMIN_BUILD_OTHER)) {
                return;
            }
            bukkitPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_permission_event"), TagResolver.resolver("node", com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag.inserting(Permission.PERMISSION_ADMIN_BUILD_OTHER)));
            playerBucketFillEvent.setCancelled(true);
        } else if (Settings.Done.RESTRICT_BUILDING && DoneFlag.isDone(plot) && !bukkitPlayer.hasPermission(Permission.PERMISSION_ADMIN_BUILD_OTHER)) {
            bukkitPlayer.sendMessage((Caption)TranslatableCaption.of("done.building_restricted"), new TagResolver[0]);
            playerBucketFillEvent.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onHangingPlace(HangingPlaceEvent hangingPlaceEvent) {
        Block block = hangingPlaceEvent.getBlock().getRelative(hangingPlaceEvent.getBlockFace());
        Location location = BukkitUtil.adapt(block.getLocation());
        PlotArea plotArea = location.getPlotArea();
        if (plotArea == null) {
            return;
        }
        Player player = hangingPlaceEvent.getPlayer();
        if (player == null) {
            hangingPlaceEvent.setCancelled(true);
            return;
        }
        BukkitPlayer bukkitPlayer = BukkitUtil.adapt(player);
        Plot plot = plotArea.getPlot(location);
        if (plot == null) {
            if (!bukkitPlayer.hasPermission(Permission.PERMISSION_ADMIN_BUILD_ROAD)) {
                bukkitPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_permission_event"), TagResolver.resolver("node", com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag.inserting(Permission.PERMISSION_ADMIN_BUILD_ROAD)));
                hangingPlaceEvent.setCancelled(true);
            }
        } else {
            if (!plot.hasOwner()) {
                if (!bukkitPlayer.hasPermission(Permission.PERMISSION_ADMIN_BUILD_UNOWNED)) {
                    bukkitPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_permission_event"), TagResolver.resolver("node", com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag.inserting(Permission.PERMISSION_ADMIN_BUILD_UNOWNED)));
                    hangingPlaceEvent.setCancelled(true);
                }
                return;
            }
            if (!plot.isAdded(bukkitPlayer.getUUID()) && !((Boolean)plot.getFlag(HangingPlaceFlag.class)).booleanValue()) {
                if (!bukkitPlayer.hasPermission(Permission.PERMISSION_ADMIN_BUILD_OTHER)) {
                    bukkitPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_permission_event"), TagResolver.resolver("node", com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag.inserting(Permission.PERMISSION_ADMIN_BUILD_OTHER)));
                    hangingPlaceEvent.setCancelled(true);
                }
                return;
            }
            if (BukkitEntityUtil.checkEntity((Entity)hangingPlaceEvent.getEntity(), plot)) {
                hangingPlaceEvent.setCancelled(true);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onHangingBreakByEntity(HangingBreakByEntityEvent hangingBreakByEntityEvent) {
        Entity entity = hangingBreakByEntityEvent.getRemover();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            Location location = BukkitUtil.adapt(hangingBreakByEntityEvent.getEntity().getLocation());
            PlotArea plotArea = location.getPlotArea();
            if (plotArea == null) {
                return;
            }
            BukkitPlayer bukkitPlayer = BukkitUtil.adapt(player);
            Plot plot = plotArea.getPlot(location);
            if (plot == null) {
                if (!bukkitPlayer.hasPermission(Permission.PERMISSION_ADMIN_DESTROY_ROAD)) {
                    bukkitPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_permission_event"), TagResolver.resolver("node", com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag.inserting(Permission.PERMISSION_ADMIN_DESTROY_ROAD)));
                    hangingBreakByEntityEvent.setCancelled(true);
                }
            } else if (!plot.hasOwner()) {
                if (!bukkitPlayer.hasPermission(Permission.PERMISSION_ADMIN_DESTROY_UNOWNED)) {
                    bukkitPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_permission_event"), TagResolver.resolver("node", com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag.inserting(Permission.PERMISSION_ADMIN_DESTROY_UNOWNED)));
                    hangingBreakByEntityEvent.setCancelled(true);
                }
            } else if (!plot.isAdded(bukkitPlayer.getUUID())) {
                if (((Boolean)plot.getFlag(HangingBreakFlag.class)).booleanValue()) {
                    return;
                }
                if (!bukkitPlayer.hasPermission(Permission.PERMISSION_ADMIN_DESTROY_OTHER)) {
                    bukkitPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_permission_event"), TagResolver.resolver("node", com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag.inserting(Permission.PERMISSION_ADMIN_DESTROY_OTHER)));
                    hangingBreakByEntityEvent.setCancelled(true);
                    plot.debug(player.getName() + " could not break hanging entity because hanging-break = false");
                }
            }
        } else if (entity instanceof Projectile) {
            Projectile projectile = (Projectile)entity;
            Object object = projectile.getShooter();
            if (object instanceof Player) {
                Player player = (Player)object;
                object = BukkitUtil.adapt(hangingBreakByEntityEvent.getEntity().getLocation());
                PlotArea plotArea = ((Location)object).getPlotArea();
                if (plotArea == null) {
                    return;
                }
                BukkitPlayer bukkitPlayer = BukkitUtil.adapt(player);
                Plot plot = plotArea.getPlot(BukkitUtil.adapt(hangingBreakByEntityEvent.getEntity().getLocation()));
                if (plot != null) {
                    if (!plot.hasOwner()) {
                        if (!bukkitPlayer.hasPermission(Permission.PERMISSION_ADMIN_DESTROY_UNOWNED)) {
                            bukkitPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_permission_event"), TagResolver.resolver("node", com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag.inserting(Permission.PERMISSION_ADMIN_DESTROY_UNOWNED)));
                            hangingBreakByEntityEvent.setCancelled(true);
                        }
                    } else if (!(plot.isAdded(bukkitPlayer.getUUID()) || ((Boolean)plot.getFlag(HangingBreakFlag.class)).booleanValue() || bukkitPlayer.hasPermission(Permission.PERMISSION_ADMIN_DESTROY_OTHER))) {
                        bukkitPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_permission_event"), TagResolver.resolver("node", com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag.inserting(Permission.PERMISSION_ADMIN_DESTROY_OTHER)));
                        hangingBreakByEntityEvent.setCancelled(true);
                        plot.debug(bukkitPlayer.getName() + " could not break hanging entity because hanging-break = false");
                    }
                }
            }
        } else {
            hangingBreakByEntityEvent.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerInteractEntity(PlayerInteractEntityEvent playerInteractEntityEvent) {
        if (playerInteractEntityEvent.getRightClicked().getType() == EntityType.UNKNOWN) {
            return;
        }
        Location location = BukkitUtil.adapt(playerInteractEntityEvent.getRightClicked().getLocation());
        PlotArea plotArea = location.getPlotArea();
        if (plotArea == null) {
            return;
        }
        Player player = playerInteractEntityEvent.getPlayer();
        BukkitPlayer bukkitPlayer = BukkitUtil.adapt(player);
        Plot plot = plotArea.getPlot(location);
        if (plot == null && !plotArea.isRoadFlags()) {
            if (!bukkitPlayer.hasPermission(Permission.PERMISSION_ADMIN_INTERACT_ROAD)) {
                bukkitPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_permission_event"), TagResolver.resolver("node", com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag.inserting(Permission.PERMISSION_ADMIN_INTERACT_ROAD)));
                playerInteractEntityEvent.setCancelled(true);
            }
        } else if (plot != null && !plot.hasOwner()) {
            if (!bukkitPlayer.hasPermission(Permission.PERMISSION_ADMIN_INTERACT_UNOWNED)) {
                bukkitPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_permission_event"), TagResolver.resolver("node", com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag.inserting(Permission.PERMISSION_ADMIN_INTERACT_UNOWNED)));
                playerInteractEntityEvent.setCancelled(true);
            }
        } else if (plot != null && !plot.isAdded(bukkitPlayer.getUUID()) || plot == null && plotArea.isRoadFlags()) {
            Entity entity = playerInteractEntityEvent.getRightClicked();
            com.sk89q.worldedit.world.entity.EntityType entityType = BukkitAdapter.adapt((EntityType)entity.getType());
            FlagContainer flagContainer = plot == null ? plotArea.getRoadFlagContainer() : plot.getFlagContainer();
            if (EntityCategories.HOSTILE.contains((com.sk89q.worldedit.registry.Keyed)entityType) && ((Boolean)flagContainer.getFlag(HostileInteractFlag.class).getValue()).booleanValue()) {
                return;
            }
            if (EntityCategories.ANIMAL.contains((com.sk89q.worldedit.registry.Keyed)entityType) && ((Boolean)flagContainer.getFlag(AnimalInteractFlag.class).getValue()).booleanValue()) {
                return;
            }
            if (entity instanceof Tameable && ((Tameable)entity).isTamed() && ((Boolean)flagContainer.getFlag(TamedInteractFlag.class).getValue()).booleanValue()) {
                return;
            }
            if (EntityCategories.VEHICLE.contains((com.sk89q.worldedit.registry.Keyed)entityType) && ((Boolean)flagContainer.getFlag(VehicleUseFlag.class).getValue()).booleanValue()) {
                return;
            }
            if (EntityCategories.PLAYER.contains((com.sk89q.worldedit.registry.Keyed)entityType) && ((Boolean)flagContainer.getFlag(PlayerInteractFlag.class).getValue()).booleanValue()) {
                return;
            }
            if (EntityCategories.VILLAGER.contains((com.sk89q.worldedit.registry.Keyed)entityType) && ((Boolean)flagContainer.getFlag(VillagerInteractFlag.class).getValue()).booleanValue()) {
                return;
            }
            if ((EntityCategories.HANGING.contains((com.sk89q.worldedit.registry.Keyed)entityType) || EntityCategories.OTHER.contains((com.sk89q.worldedit.registry.Keyed)entityType)) && ((Boolean)flagContainer.getFlag(MiscInteractFlag.class).getValue()).booleanValue()) {
                return;
            }
            if (!bukkitPlayer.hasPermission(Permission.PERMISSION_ADMIN_INTERACT_OTHER)) {
                bukkitPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_permission_event"), TagResolver.resolver("node", com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag.inserting(Permission.PERMISSION_ADMIN_INTERACT_OTHER)));
                playerInteractEntityEvent.setCancelled(true);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onVehicleDestroy(VehicleDestroyEvent vehicleDestroyEvent) {
        Location location = BukkitUtil.adapt(vehicleDestroyEvent.getVehicle().getLocation());
        PlotArea plotArea = location.getPlotArea();
        if (plotArea == null) {
            return;
        }
        Entity entity = vehicleDestroyEvent.getAttacker();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            BukkitPlayer bukkitPlayer = BukkitUtil.adapt(player);
            Plot plot = plotArea.getPlot(location);
            if (plot == null) {
                if (!PlotFlagUtil.isAreaRoadFlagsAndFlagEquals(plotArea, VehicleBreakFlag.class, true) && !bukkitPlayer.hasPermission(Permission.PERMISSION_ADMIN_DESTROY_VEHICLE_ROAD)) {
                    bukkitPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_permission_event"), TagResolver.resolver("node", com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag.inserting(Permission.PERMISSION_ADMIN_DESTROY_VEHICLE_ROAD)));
                    vehicleDestroyEvent.setCancelled(true);
                }
            } else {
                if (!plot.hasOwner()) {
                    if (!bukkitPlayer.hasPermission(Permission.PERMISSION_ADMIN_DESTROY_VEHICLE_UNOWNED)) {
                        bukkitPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_permission_event"), TagResolver.resolver("node", com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag.inserting(Permission.PERMISSION_ADMIN_DESTROY_VEHICLE_UNOWNED)));
                        vehicleDestroyEvent.setCancelled(true);
                        return;
                    }
                    return;
                }
                if (!plot.isAdded(bukkitPlayer.getUUID())) {
                    if (((Boolean)plot.getFlag(VehicleBreakFlag.class)).booleanValue()) {
                        return;
                    }
                    if (!bukkitPlayer.hasPermission(Permission.PERMISSION_ADMIN_DESTROY_VEHICLE_OTHER)) {
                        bukkitPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_permission_event"), TagResolver.resolver("node", com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag.inserting(Permission.PERMISSION_ADMIN_DESTROY_VEHICLE_OTHER)));
                        vehicleDestroyEvent.setCancelled(true);
                        plot.debug(bukkitPlayer.getName() + " could not break vehicle because vehicle-break = false");
                    }
                }
            }
        }
    }

    @EventHandler
    public void onItemDrop(PlayerDropItemEvent playerDropItemEvent) {
        Player player = playerDropItemEvent.getPlayer();
        BukkitPlayer bukkitPlayer = BukkitUtil.adapt(player);
        Location location = bukkitPlayer.getLocation();
        PlotArea plotArea = location.getPlotArea();
        if (plotArea == null) {
            return;
        }
        Plot plot = location.getOwnedPlot();
        if (plot == null) {
            if (PlotFlagUtil.isAreaRoadFlagsAndFlagEquals(plotArea, ItemDropFlag.class, false)) {
                playerDropItemEvent.setCancelled(true);
            }
            return;
        }
        UUID uUID = bukkitPlayer.getUUID();
        if (!plot.isAdded(uUID) && !((Boolean)plot.getFlag(ItemDropFlag.class)).booleanValue()) {
            plot.debug(player.getName() + " could not drop item because of item-drop = false");
            playerDropItemEvent.setCancelled(true);
        }
    }

    @EventHandler
    public void onItemPickup(EntityPickupItemEvent entityPickupItemEvent) {
        LivingEntity livingEntity = entityPickupItemEvent.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            BukkitPlayer bukkitPlayer = BukkitUtil.adapt(player);
            Location location = bukkitPlayer.getLocation();
            PlotArea plotArea = location.getPlotArea();
            if (plotArea == null) {
                return;
            }
            Plot plot = location.getOwnedPlot();
            if (plot == null) {
                if (PlotFlagUtil.isAreaRoadFlagsAndFlagEquals(plotArea, DropProtectionFlag.class, true)) {
                    entityPickupItemEvent.setCancelled(true);
                }
                return;
            }
            UUID uUID = bukkitPlayer.getUUID();
            if (!plot.isAdded(uUID) && ((Boolean)plot.getFlag(DropProtectionFlag.class)).booleanValue()) {
                plot.debug(player.getName() + " could not pick up item because of drop-protection = true");
                entityPickupItemEvent.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void onDeath(PlayerDeathEvent playerDeathEvent) {
        Location location = BukkitUtil.adapt(playerDeathEvent.getEntity().getLocation());
        PlotArea plotArea = location.getPlotArea();
        if (plotArea == null) {
            return;
        }
        Plot plot = location.getOwnedPlot();
        if (plot == null) {
            if (PlotFlagUtil.isAreaRoadFlagsAndFlagEquals(plotArea, KeepInventoryFlag.class, true)) {
                playerDeathEvent.setCancelled(true);
            }
            return;
        }
        if (((Boolean)plot.getFlag(KeepInventoryFlag.class)).booleanValue()) {
            plot.debug(playerDeathEvent.getEntity().getName() + " kept their inventory because of keep-inventory = true");
            playerDeathEvent.getDrops().clear();
            playerDeathEvent.setKeepInventory(true);
        }
    }

    @EventHandler
    public void onLocaleChange(PlayerLocaleChangeEvent playerLocaleChangeEvent) {
        if (!playerLocaleChangeEvent.getPlayer().isOnline()) {
            return;
        }
        BukkitPlayer bukkitPlayer = BukkitUtil.adapt(playerLocaleChangeEvent.getPlayer());
        bukkitPlayer.setLocale(Locale.forLanguageTag(playerLocaleChangeEvent.getLocale().substring(0, 2)));
    }

    @EventHandler
    public void onPortalEnter(PlayerPortalEvent playerPortalEvent) {
        Location location = BukkitUtil.adapt(playerPortalEvent.getPlayer().getLocation());
        PlotArea plotArea = location.getPlotArea();
        if (plotArea == null) {
            return;
        }
        Plot plot = location.getOwnedPlot();
        if (plot == null) {
            if (PlotFlagUtil.isAreaRoadFlagsAndFlagEquals(plotArea, DenyPortalTravelFlag.class, true)) {
                playerPortalEvent.setCancelled(true);
            }
            return;
        }
        if (((Boolean)plot.getFlag(DenyPortalTravelFlag.class)).booleanValue()) {
            plot.debug(playerPortalEvent.getPlayer().getName() + " did not travel thru a portal because of deny-portal-travel = true");
            playerPortalEvent.setCancelled(true);
        }
    }

    @EventHandler
    public void onPortalCreation(PortalCreateEvent portalCreateEvent) {
        BukkitPlayer bukkitPlayer;
        String string = portalCreateEvent.getWorld().getName();
        if (PlotSquared.get().getPlotAreaManager().getPlotAreasSet(string).size() == 0) {
            return;
        }
        Entity entity = portalCreateEvent.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            bukkitPlayer = BukkitUtil.adapt(player);
        } else {
            bukkitPlayer = null;
        }
        BukkitPlayer bukkitPlayer2 = bukkitPlayer;
        int n = Integer.MAX_VALUE;
        int n2 = Integer.MIN_VALUE;
        int n3 = Integer.MAX_VALUE;
        int n4 = Integer.MIN_VALUE;
        for (Object object : portalCreateEvent.getBlocks()) {
            n = Math.min(object.getX(), n);
            n2 = Math.max(object.getX(), n2);
            n3 = Math.min(object.getZ(), n3);
            n4 = Math.max(object.getZ(), n4);
        }
        int n5 = ((BlockState)portalCreateEvent.getBlocks().get(0)).getY();
        for (Location location : List.of(Location.at(string, n, n5, n3), Location.at(string, n, n5, n4), Location.at(string, n2, n5, n3), Location.at(string, n2, n5, n4))) {
            PlotArea plotArea = location.getPlotArea();
            if (plotArea == null) continue;
            if (plotArea.notifyIfOutsideBuildArea(bukkitPlayer2, location.getY())) {
                portalCreateEvent.setCancelled(true);
                return;
            }
            Plot plot = location.getOwnedPlot();
            if (plot == null) {
                if (!PlotFlagUtil.isAreaRoadFlagsAndFlagEquals(plotArea, DenyPortalsFlag.class, true)) continue;
                portalCreateEvent.setCancelled(true);
                return;
            }
            if (!((Boolean)plot.getFlag(DenyPortalsFlag.class)).booleanValue()) continue;
            StringBuilder stringBuilder = new StringBuilder();
            if (portalCreateEvent.getEntity() != null) {
                stringBuilder.append(portalCreateEvent.getEntity().getName()).append(" did not create a portal");
            } else {
                stringBuilder.append("Portal creation cancelled");
            }
            plot.debug(stringBuilder.append(" because of deny-portals = true").toString());
            portalCreateEvent.setCancelled(true);
            return;
        }
    }

    @EventHandler
    public void onPlayerTakeLecternBook(PlayerTakeLecternBookEvent playerTakeLecternBookEvent) {
        Location location = BukkitUtil.adapt(playerTakeLecternBookEvent.getPlayer().getLocation());
        PlotArea plotArea = location.getPlotArea();
        if (plotArea == null) {
            return;
        }
        Plot plot = location.getOwnedPlot();
        if (plot == null) {
            if (PlotFlagUtil.isAreaRoadFlagsAndFlagEquals(plotArea, LecternReadBookFlag.class, true)) {
                playerTakeLecternBookEvent.setCancelled(true);
            }
            return;
        }
        if (((Boolean)plot.getFlag(LecternReadBookFlag.class)).booleanValue()) {
            plot.debug(playerTakeLecternBookEvent.getPlayer().getName() + " could not take the book because of lectern-read-book = true");
            playerTakeLecternBookEvent.setCancelled(true);
        }
    }
}

