/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.bukkit.listener;

import com.plotsquared.bukkit.generator.BukkitPlotGenerator;
import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.generator.GeneratorWrapper;
import com.plotsquared.core.plot.world.PlotAreaManager;
import com.plotsquared.core.plot.world.SinglePlotAreaManager;
import com.plotsquared.google.Inject;
import org.bukkit.World;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.world.WorldInitEvent;
import org.bukkit.generator.ChunkGenerator;
import org.checkerframework.checker.nullness.qual.NonNull;

public class WorldEvents
implements Listener {
    private final PlotAreaManager plotAreaManager;

    @Inject
    public WorldEvents(@NonNull PlotAreaManager plotAreaManager) {
        this.plotAreaManager = plotAreaManager;
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onWorldInit(WorldInitEvent worldInitEvent) {
        SinglePlotAreaManager singlePlotAreaManager;
        World world = worldInitEvent.getWorld();
        String string = world.getName();
        PlotAreaManager plotAreaManager = this.plotAreaManager;
        if (plotAreaManager instanceof SinglePlotAreaManager && (singlePlotAreaManager = (SinglePlotAreaManager)plotAreaManager).isWorld(string)) {
            world.setKeepSpawnInMemory(false);
            return;
        }
        singlePlotAreaManager = world.getGenerator();
        if (singlePlotAreaManager instanceof GeneratorWrapper) {
            PlotSquared.get().loadWorld(string, (GeneratorWrapper)((Object)singlePlotAreaManager));
        } else {
            PlotSquared.get().loadWorld(string, new BukkitPlotGenerator(string, (ChunkGenerator)singlePlotAreaManager, this.plotAreaManager));
        }
    }
}

