/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.bukkit.player;

import com.google.common.base.Charsets;
import com.plotsquared.bukkit.paperlib.PaperLib;
import com.plotsquared.bukkit.util.BukkitUtil;
import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.configuration.adventure.audience.Audience;
import com.plotsquared.core.events.TeleportCause;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.permissions.Permission;
import com.plotsquared.core.permissions.PermissionHandler;
import com.plotsquared.core.player.ConsolePlayer;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.PlotWeather;
import com.plotsquared.core.plot.world.PlotAreaManager;
import com.plotsquared.core.util.EventDispatcher;
import com.plotsquared.core.util.MathMan;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.world.gamemode.GameMode;
import com.sk89q.worldedit.world.gamemode.GameModes;
import com.sk89q.worldedit.world.item.ItemType;
import com.sk89q.worldedit.world.item.ItemTypes;
import java.util.Arrays;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Sound;
import org.bukkit.WeatherType;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventException;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.permissions.PermissionAttachmentInfo;
import org.bukkit.plugin.RegisteredListener;
import org.bukkit.potion.PotionEffectType;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.NonNull;

public class BukkitPlayer
extends PlotPlayer<Player> {
    private static boolean CHECK_EFFECTIVE = true;
    public final Player player;
    private String name;

    BukkitPlayer(@NonNull PlotAreaManager plotAreaManager, @NonNull EventDispatcher eventDispatcher, @NonNull Player player, boolean bl, @NonNull PermissionHandler permissionHandler) {
        super(plotAreaManager, eventDispatcher, permissionHandler);
        this.player = player;
        this.setupPermissionProfile();
        if (bl) {
            super.populatePersistentMetaMap();
        }
    }

    @Override
    public Actor toActor() {
        return BukkitAdapter.adapt((Player)this.player);
    }

    @Override
    public Player getPlatformPlayer() {
        return this.player;
    }

    @Override
    public @NonNull UUID getUUID() {
        if (Settings.UUID.OFFLINE) {
            if (Settings.UUID.FORCE_LOWERCASE) {
                return UUID.nameUUIDFromBytes(("OfflinePlayer:" + this.getName().toLowerCase()).getBytes(Charsets.UTF_8));
            }
            return UUID.nameUUIDFromBytes(("OfflinePlayer:" + this.getName()).getBytes(Charsets.UTF_8));
        }
        return this.player.getUniqueId();
    }

    @Override
    public @NonNegative long getLastPlayed() {
        return this.player.getLastSeen();
    }

    @Override
    public boolean canTeleport(@NonNull Location location) {
        org.bukkit.Location location2 = BukkitUtil.adapt(location);
        org.bukkit.Location location3 = this.player.getLocation();
        PlayerTeleportEvent playerTeleportEvent = new PlayerTeleportEvent(this.player, location3, location2);
        this.callEvent((Event)playerTeleportEvent);
        if (playerTeleportEvent.isCancelled() || !playerTeleportEvent.getTo().equals((Object)location2)) {
            return false;
        }
        playerTeleportEvent = new PlayerTeleportEvent(this.player, location2, location3);
        this.callEvent((Event)playerTeleportEvent);
        return true;
    }

    private void callEvent(@NonNull Event event) {
        RegisteredListener[] registeredListenerArray;
        for (RegisteredListener registeredListener : registeredListenerArray = event.getHandlers().getRegisteredListeners()) {
            if (registeredListener.getPlugin().getName().equals(PlotSquared.platform().pluginName())) continue;
            try {
                registeredListener.callEvent(event);
            }
            catch (EventException eventException) {
                eventException.printStackTrace();
            }
        }
    }

    @Override
    public @NonNegative int hasPermissionRange(@NonNull String string, @NonNegative int n) {
        int n2;
        int n3;
        if (this.hasPermission(Permission.PERMISSION_ADMIN.toString())) {
            return Integer.MAX_VALUE;
        }
        String[] stringArray = string.split("\\.");
        StringBuilder stringBuilder = new StringBuilder();
        for (n3 = 0; n3 < stringArray.length - 1; ++n3) {
            stringBuilder.append(stringArray[n3]).append(".");
            if (string.equals(stringBuilder + Permission.PERMISSION_STAR.toString()) || !this.hasPermission(stringBuilder + Permission.PERMISSION_STAR.toString())) continue;
            return Integer.MAX_VALUE;
        }
        if (this.hasPermission(string + ".*")) {
            return Integer.MAX_VALUE;
        }
        n3 = 0;
        if (CHECK_EFFECTIVE) {
            n2 = 0;
            String string2 = string + ".";
            Set set = this.player.getEffectivePermissions();
            if (!set.isEmpty()) {
                String string3;
                for (PermissionAttachmentInfo permissionAttachmentInfo : set) {
                    if (!permissionAttachmentInfo.getValue() || !(string3 = permissionAttachmentInfo.getPermission()).startsWith(string2)) continue;
                    n2 = 1;
                    String string4 = string3.substring(string2.length());
                    if (!MathMan.isInteger(string4)) continue;
                    int n4 = Integer.parseInt(string4);
                    if (n4 > n) {
                        return n4;
                    }
                    if (n4 <= n3) continue;
                    n3 = n4;
                }
                if (n2 != 0) {
                    return n3;
                }
                for (PermissionAttachmentInfo permissionAttachmentInfo : set) {
                    string3 = permissionAttachmentInfo.getPermission();
                    if (!string3.startsWith("plots.") || string3.equals("plots.use")) continue;
                    return n3;
                }
                CHECK_EFFECTIVE = false;
            }
        }
        for (n2 = n; n2 > 0; --n2) {
            if (!this.hasPermission(string + "." + n2)) continue;
            return n2;
        }
        return n3;
    }

    @Override
    public void teleport(@NonNull Location location, @NonNull TeleportCause teleportCause) {
        if (Math.abs(location.getX()) >= 30000000 || Math.abs(location.getZ()) >= 30000000) {
            return;
        }
        org.bukkit.Location location2 = new org.bukkit.Location(BukkitUtil.getWorld(location.getWorldName()), (double)location.getX() + 0.5, (double)location.getY(), (double)location.getZ() + 0.5, location.getYaw(), location.getPitch());
        PaperLib.teleportAsync((Entity)this.player, location2, this.getTeleportCause(teleportCause));
    }

    @Override
    public String getName() {
        if (this.name == null) {
            this.name = this.player.getName();
        }
        return this.name;
    }

    @Override
    public void setCompassTarget(Location location) {
        this.player.setCompassTarget(new org.bukkit.Location(BukkitUtil.getWorld(location.getWorldName()), (double)location.getX(), (double)location.getY(), (double)location.getZ()));
    }

    @Override
    public Location getLocationFull() {
        return BukkitUtil.adaptComplete(this.player.getLocation());
    }

    @Override
    public void setWeather(@NonNull PlotWeather plotWeather) {
        switch (plotWeather) {
            case CLEAR: {
                this.player.setPlayerWeather(WeatherType.CLEAR);
                break;
            }
            case RAIN: {
                this.player.setPlayerWeather(WeatherType.DOWNFALL);
                break;
            }
            case WORLD: {
                this.player.resetPlayerWeather();
                break;
            }
        }
    }

    @Override
    public GameMode getGameMode() {
        return switch (this.player.getGameMode()) {
            case org.bukkit.GameMode.ADVENTURE -> GameModes.ADVENTURE;
            case org.bukkit.GameMode.CREATIVE -> GameModes.CREATIVE;
            case org.bukkit.GameMode.SPECTATOR -> GameModes.SPECTATOR;
            default -> GameModes.SURVIVAL;
        };
    }

    @Override
    public void setGameMode(GameMode gameMode) {
        if (GameModes.ADVENTURE.equals((Object)gameMode)) {
            this.player.setGameMode(org.bukkit.GameMode.ADVENTURE);
        } else if (GameModes.CREATIVE.equals((Object)gameMode)) {
            this.player.setGameMode(org.bukkit.GameMode.CREATIVE);
        } else if (GameModes.SPECTATOR.equals((Object)gameMode)) {
            this.player.setGameMode(org.bukkit.GameMode.SPECTATOR);
        } else {
            this.player.setGameMode(org.bukkit.GameMode.SURVIVAL);
        }
    }

    @Override
    public void setTime(long l) {
        if (l != Long.MAX_VALUE) {
            this.player.setPlayerTime(l, false);
        } else {
            this.player.resetPlayerTime();
        }
    }

    @Override
    public boolean getFlight() {
        return this.player.getAllowFlight();
    }

    @Override
    public void setFlight(boolean bl) {
        this.player.setAllowFlight(bl);
    }

    @Override
    public void playMusic(@NonNull Location location, @NonNull ItemType itemType) {
        if (itemType == ItemTypes.AIR) {
            for (Sound sound2 : Arrays.stream(Sound.values()).filter(sound -> sound.name().contains("DISC")).toList()) {
                this.player.stopSound(sound2);
            }
        } else {
            this.player.playSound(BukkitUtil.adapt(location), Sound.valueOf((String)BukkitAdapter.adapt((ItemType)itemType).name()), Float.MAX_VALUE, 1.0f);
        }
    }

    @Override
    public void kick(String string) {
        this.player.kickPlayer(string);
    }

    @Override
    public void stopSpectating() {
        if (this.getGameMode() == GameModes.SPECTATOR) {
            this.player.setSpectatorTarget(null);
        }
    }

    @Override
    public boolean isBanned() {
        return this.player.isBanned();
    }

    @Override
    public @NonNull Audience getAudience() {
        return BukkitUtil.BUKKIT_AUDIENCES.player(this.player);
    }

    @Override
    public void removeEffect(@NonNull String string) {
        PotionEffectType potionEffectType = PotionEffectType.getByName((String)string);
        if (potionEffectType != null) {
            this.player.removePotionEffect(potionEffectType);
        }
    }

    @Override
    public boolean canSee(PlotPlayer<?> plotPlayer) {
        if (plotPlayer instanceof ConsolePlayer) {
            return true;
        }
        return this.player.canSee(((BukkitPlayer)plotPlayer).getPlatformPlayer());
    }

    public PlayerTeleportEvent.TeleportCause getTeleportCause(@NonNull TeleportCause teleportCause) {
        if (TeleportCause.CauseSets.COMMAND.contains((Object)teleportCause)) {
            return PlayerTeleportEvent.TeleportCause.COMMAND;
        }
        if (teleportCause == TeleportCause.UNKNOWN) {
            return PlayerTeleportEvent.TeleportCause.UNKNOWN;
        }
        return PlayerTeleportEvent.TeleportCause.PLUGIN;
    }
}

