/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.bukkit.queue;

import com.plotsquared.bukkit.schematic.StateWrapper;
import com.plotsquared.core.queue.DelegateQueueCoordinator;
import com.plotsquared.core.queue.QueueCoordinator;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.entity.Entity;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bukkit.Location;
import org.bukkit.entity.EntityType;
import org.bukkit.generator.LimitedRegion;
import org.checkerframework.checker.nullness.qual.NonNull;

public class LimitedRegionWrapperQueue
extends DelegateQueueCoordinator {
    private static final Logger LOGGER = LogManager.getLogger((String)("PlotSquared/" + LimitedRegionWrapperQueue.class.getSimpleName()));
    private final LimitedRegion limitedRegion;
    private boolean useOtherRestoreTagMethod = false;

    public LimitedRegionWrapperQueue(LimitedRegion limitedRegion) {
        super((QueueCoordinator)null);
        this.limitedRegion = limitedRegion;
    }

    @Override
    public boolean setBlock(int n, int n2, int n3, @NonNull Pattern pattern) {
        return this.setBlock(n, n2, n3, pattern.applyBlock(BlockVector3.at((int)n, (int)n2, (int)n3)));
    }

    @Override
    public boolean setBlock(int n, int n2, int n3, @NonNull BaseBlock baseBlock) {
        boolean bl = this.setBlock(n, n2, n3, baseBlock.toImmutableState());
        if (bl && baseBlock.hasNbtData()) {
            CompoundTag compoundTag = baseBlock.getNbtData();
            StateWrapper stateWrapper = new StateWrapper(compoundTag);
            try {
                if (this.useOtherRestoreTagMethod && this.getWorld() != null) {
                    stateWrapper.restoreTag(this.getWorld().getName(), n, n2, n3);
                } else {
                    stateWrapper.restoreTag(this.limitedRegion.getBlockState(n, n2, n3).getBlock());
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                LOGGER.error("Error attempting to populate tile entity into the world at location {},{},{}", (Object)n, (Object)n2, (Object)n3, (Object)illegalArgumentException);
                return false;
            }
            catch (IllegalStateException illegalStateException) {
                this.useOtherRestoreTagMethod = true;
                LOGGER.warn("IllegalStateException attempting to populate tile entity into the world at location {},{},{}. Possibly on <=1.17.1, switching to secondary method.", (Object)n, (Object)n2, (Object)n3, (Object)illegalStateException);
            }
        }
        return bl;
    }

    @Override
    public boolean setBlock(int n, int n2, int n3, @NonNull BlockState blockState) {
        try {
            this.limitedRegion.setType(n, n2, n3, BukkitAdapter.adapt((BlockType)blockState.getBlockType()));
            this.limitedRegion.setBlockData(n, n2, n3, BukkitAdapter.adapt((BlockStateHolder)blockState));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LOGGER.error("Error attempting to populate block into the world at location {},{},{}", (Object)n, (Object)n2, (Object)n3, (Object)illegalArgumentException);
            return false;
        }
        return true;
    }

    @Override
    public boolean setEntity(@NonNull Entity entity) {
        EntityType entityType = BukkitAdapter.adapt((com.sk89q.worldedit.world.entity.EntityType)entity.getState().getType());
        double d = entity.getLocation().getX();
        double d2 = entity.getLocation().getY();
        double d3 = entity.getLocation().getZ();
        Location location = new Location(this.limitedRegion.getWorld(), d, d2, d3);
        try {
            this.limitedRegion.spawnEntity(location, entityType);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LOGGER.error("Error attempting to populate entity into the world at location {},{},{}", (Object)((int)d), (Object)((int)d2), (Object)((int)d3), (Object)illegalArgumentException);
            return false;
        }
        return true;
    }

    @Override
    public boolean setTile(int n, int n2, int n3, @NonNull CompoundTag compoundTag) {
        StateWrapper stateWrapper = new StateWrapper(compoundTag);
        try {
            return stateWrapper.restoreTag(this.limitedRegion.getBlockState(n, n2, n3).getBlock());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LOGGER.error("Error attempting to populate tile entity into the world at location {},{},{}", (Object)n, (Object)n2, (Object)n3, (Object)illegalArgumentException);
            return false;
        }
    }

    @Override
    public boolean isSettingTiles() {
        return true;
    }
}

