/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.bukkit.schematic;

import com.destroystokyo.paper.profile.PlayerProfile;
import com.destroystokyo.paper.profile.ProfileProperty;
import com.plotsquared.bukkit.paperlib.PaperLib;
import com.plotsquared.bukkit.util.BukkitUtil;
import com.sk89q.jnbt.ByteTag;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.jnbt.ListTag;
import com.sk89q.jnbt.ShortTag;
import com.sk89q.jnbt.StringTag;
import com.sk89q.jnbt.Tag;
import com.sk89q.worldedit.blocks.BaseItemStack;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.world.item.ItemType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.DyeColor;
import org.bukkit.World;
import org.bukkit.block.Banner;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Container;
import org.bukkit.block.Sign;
import org.bukkit.block.Skull;
import org.bukkit.block.banner.Pattern;
import org.bukkit.block.banner.PatternType;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.checkerframework.checker.nullness.qual.NonNull;

public class StateWrapper {
    public CompoundTag tag;
    private boolean paperErrorTextureSent = false;
    private static final Logger LOGGER = LogManager.getLogger((String)("PlotSquared/" + StateWrapper.class.getSimpleName()));

    public StateWrapper(CompoundTag compoundTag) {
        this.tag = compoundTag;
    }

    public static String jsonToColourCode(String string) {
        string = string.replace("{\"extra\":", "").replace("],\"text\":\"\"}", "]").replace("[{\"color\":\"black\",\"text\":\"", "&0").replace("[{\"color\":\"dark_blue\",\"text\":\"", "&1").replace("[{\"color\":\"dark_green\",\"text\":\"", "&2").replace("[{\"color\":\"dark_aqua\",\"text\":\"", "&3").replace("[{\"color\":\"dark_red\",\"text\":\"", "&4").replace("[{\"color\":\"dark_purple\",\"text\":\"", "&5").replace("[{\"color\":\"gold\",\"text\":\"", "&6").replace("[{\"color\":\"gray\",\"text\":\"", "&7").replace("[{\"color\":\"dark_gray\",\"text\":\"", "&8").replace("[{\"color\":\"blue\",\"text\":\"", "&9").replace("[{\"color\":\"green\",\"text\":\"", "&a").replace("[{\"color\":\"aqua\",\"text\":\"", "&b").replace("[{\"color\":\"red\",\"text\":\"", "&c").replace("[{\"color\":\"light_purple\",\"text\":\"", "&d").replace("[{\"color\":\"yellow\",\"text\":\"", "&e").replace("[{\"color\":\"white\",\"text\":\"", "&f").replace("[{\"obfuscated\":true,\"text\":\"", "&k").replace("[{\"bold\":true,\"text\":\"", "&l").replace("[{\"strikethrough\":true,\"text\":\"", "&m").replace("[{\"underlined\":true,\"text\":\"", "&n").replace("[{\"italic\":true,\"text\":\"", "&o").replace("[{\"color\":\"black\",", "&0").replace("[{\"color\":\"dark_blue\",", "&1").replace("[{\"color\":\"dark_green\",", "&2").replace("[{\"color\":\"dark_aqua\",", "&3").replace("[{\"color\":\"dark_red\",", "&4").replace("[{\"color\":\"dark_purple\",", "&5").replace("[{\"color\":\"gold\",", "&6").replace("[{\"color\":\"gray\",", "&7").replace("[{\"color\":\"dark_gray\",", "&8").replace("[{\"color\":\"blue\",", "&9").replace("[{\"color\":\"green\",", "&a").replace("[{\"color\":\"aqua\",", "&b").replace("[{\"color\":\"red\",", "&c").replace("[{\"color\":\"light_purple\",", "&d").replace("[{\"color\":\"yellow\",", "&e").replace("[{\"color\":\"white\",", "&f").replace("[{\"obfuscated\":true,", "&k").replace("[{\"bold\":true,", "&l").replace("[{\"strikethrough\":true,", "&m").replace("[{\"underlined\":true,", "&n").replace("[{\"italic\":true,", "&o").replace("{\"color\":\"black\",\"text\":\"", "&0").replace("{\"color\":\"dark_blue\",\"text\":\"", "&1").replace("{\"color\":\"dark_green\",\"text\":\"", "&2").replace("{\"color\":\"dark_aqua\",\"text\":\"", "&3").replace("{\"color\":\"dark_red\",\"text\":\"", "&4").replace("{\"color\":\"dark_purple\",\"text\":\"", "&5").replace("{\"color\":\"gold\",\"text\":\"", "&6").replace("{\"color\":\"gray\",\"text\":\"", "&7").replace("{\"color\":\"dark_gray\",\"text\":\"", "&8").replace("{\"color\":\"blue\",\"text\":\"", "&9").replace("{\"color\":\"green\",\"text\":\"", "&a").replace("{\"color\":\"aqua\",\"text\":\"", "&b").replace("{\"color\":\"red\",\"text\":\"", "&c").replace("{\"color\":\"light_purple\",\"text\":\"", "&d").replace("{\"color\":\"yellow\",\"text\":\"", "&e").replace("{\"color\":\"white\",\"text\":\"", "&f").replace("{\"obfuscated\":true,\"text\":\"", "&k").replace("{\"bold\":true,\"text\":\"", "&l").replace("{\"strikethrough\":true,\"text\":\"", "&m").replace("{\"underlined\":true,\"text\":\"", "&n").replace("{\"italic\":true,\"text\":\"", "&o").replace("{\"color\":\"black\",", "&0").replace("{\"color\":\"dark_blue\",", "&1").replace("{\"color\":\"dark_green\",", "&2").replace("{\"color\":\"dark_aqua\",", "&3").replace("{\"color\":\"dark_red\",", "&4").replace("{\"color\":\"dark_purple\",", "&5").replace("{\"color\":\"gold\",", "&6").replace("{\"color\":\"gray\",", "&7").replace("{\"color\":\"dark_gray\",", "&8").replace("{\"color\":\"blue\",", "&9").replace("{\"color\":\"green\",", "&a").replace("{\"color\":\"aqua\",", "&b").replace("{\"color\":\"red\",", "&c").replace("{\"color\":\"light_purple\",", "&d").replace("{\"color\":\"yellow\",", "&e").replace("{\"color\":\"white\",", "&f").replace("{\"obfuscated\":true,", "&k").replace("{\"bold\":true,", "&l").replace("{\"strikethrough\":true,", "&m").replace("{\"underlined\":true,", "&n").replace("{\"italic\":true,", "&o").replace("\"color\":\"black\",\"text\":\"", "&0").replace("\"color\":\"dark_blue\",\"text\":\"", "&1").replace("\"color\":\"dark_green\",\"text\":\"", "&2").replace("\"color\":\"dark_aqua\",\"text\":\"", "&3").replace("\"color\":\"dark_red\",\"text\":\"", "&4").replace("\"color\":\"dark_purple\",\"text\":\"", "&5").replace("\"color\":\"gold\",\"text\":\"", "&6").replace("\"color\":\"gray\",\"text\":\"", "&7").replace("\"color\":\"dark_gray\",\"text\":\"", "&8").replace("\"color\":\"blue\",\"text\":\"", "&9").replace("\"color\":\"green\",\"text\":\"", "&a").replace("\"color\":\"aqua\",\"text\":\"", "&b").replace("\"color\":\"red\",\"text\":\"", "&c").replace("\"color\":\"light_purple\",\"text\":\"", "&d").replace("\"color\":\"yellow\",\"text\":\"", "&e").replace("\"color\":\"white\",\"text\":\"", "&f").replace("\"obfuscated\":true,\"text\":\"", "&k").replace("\"bold\":true,\"text\":\"", "&l").replace("\"strikethrough\":true,\"text\":\"", "&m").replace("\"underlined\":true,\"text\":\"", "&n").replace("\"italic\":true,\"text\":\"", "&o").replace("\"color\":\"black\",", "&0").replace("\"color\":\"dark_blue\",", "&1").replace("\"color\":\"dark_green\",", "&2").replace("\"color\":\"dark_aqua\",", "&3").replace("\"color\":\"dark_red\",", "&4").replace("\"color\":\"dark_purple\",", "&5").replace("\"color\":\"gold\",", "&6").replace("\"color\":\"gray\",", "&7").replace("\"color\":\"dark_gray\",", "&8").replace("\"color\":\"blue\",", "&9").replace("\"color\":\"green\",", "&a").replace("\"color\":\"aqua\",", "&b").replace("\"color\":\"red\",", "&c").replace("\"color\":\"light_purple\",", "&d").replace("\"color\":\"yellow\",", "&e").replace("\"color\":\"white\",", "&f").replace("\"obfuscated\":true,", "&k").replace("\"bold\":true,", "&l").replace("\"strikethrough\":true,", "&m").replace("\"underlined\":true,", "&n").replace("\"italic\":true,", "&o").replace("[{\"text\":\"", "&0").replace("{\"text\":\"", "&0").replace("\"},", "").replace("\"}]", "").replace("\"}", "");
        string = ChatColor.translateAlternateColorCodes((char)'&', (String)string);
        return string;
    }

    public boolean restoreTag(String string, int n, int n2, int n3) {
        World world = BukkitUtil.getWorld(string);
        if (world == null) {
            return false;
        }
        return this.restoreTag(world.getBlockAt(n, n2, n3));
    }

    public boolean restoreTag(@NonNull Block block) {
        if (this.tag == null) {
            return false;
        }
        BlockState blockState = block.getState();
        switch (this.getId()) {
            case "chest": 
            case "beacon": 
            case "brewingstand": 
            case "dispenser": 
            case "dropper": 
            case "furnace": 
            case "hopper": 
            case "shulkerbox": {
                if (!(blockState instanceof Container)) {
                    return false;
                }
                Container container = (Container)blockState;
                List list = this.tag.getListTag("Items").getValue();
                Inventory inventory = container.getSnapshotInventory();
                for (Tag tag2 : list) {
                    CompoundTag compoundTag2 = (CompoundTag)tag2;
                    ItemType itemType = (ItemType)ItemType.REGISTRY.get(compoundTag2.getString("id").toLowerCase());
                    if (itemType == null) continue;
                    byte by = compoundTag2.getByte("Count");
                    byte by2 = compoundTag2.getByte("Slot");
                    CompoundTag compoundTag3 = (CompoundTag)compoundTag2.getValue().get("tag");
                    BaseItemStack baseItemStack = new BaseItemStack(itemType, compoundTag3, (int)by);
                    ItemStack itemStack = BukkitAdapter.adapt((BaseItemStack)baseItemStack);
                    inventory.setItem((int)by2, itemStack);
                }
                container.update(true, false);
                return true;
            }
            case "sign": {
                if (blockState instanceof Sign) {
                    Sign sign = (Sign)blockState;
                    sign.setLine(0, StateWrapper.jsonToColourCode(this.tag.getString("Text1")));
                    sign.setLine(1, StateWrapper.jsonToColourCode(this.tag.getString("Text2")));
                    sign.setLine(2, StateWrapper.jsonToColourCode(this.tag.getString("Text3")));
                    sign.setLine(3, StateWrapper.jsonToColourCode(this.tag.getString("Text4")));
                    blockState.update(true);
                    return true;
                }
                return false;
            }
            case "skull": {
                if (blockState instanceof Skull) {
                    Skull skull = (Skull)blockState;
                    CompoundTag compoundTag4 = (CompoundTag)this.tag.getValue().get("SkullOwner");
                    if (compoundTag4 == null) {
                        return true;
                    }
                    String string = compoundTag4.getString("Name");
                    if (string != null && !string.isEmpty()) {
                        try {
                            skull.setOwningPlayer(Bukkit.getOfflinePlayer((String)string));
                            skull.update(true);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        return true;
                    }
                    CompoundTag compoundTag5 = (CompoundTag)compoundTag4.getValue().get("Properties");
                    if (compoundTag5 == null) {
                        return false;
                    }
                    ListTag listTag = compoundTag5.getListTag("textures");
                    if (listTag.getValue().isEmpty()) {
                        return false;
                    }
                    CompoundTag compoundTag6 = (CompoundTag)listTag.getValue().get(0);
                    if (compoundTag6 == null) {
                        return false;
                    }
                    String string2 = compoundTag6.getString("Value");
                    if (string2 == null) {
                        return false;
                    }
                    if (!PaperLib.isPaper()) {
                        if (!this.paperErrorTextureSent) {
                            this.paperErrorTextureSent = true;
                            LOGGER.error("Failed to populate skull data in your road schematic - This is a Spigot limitation.");
                        }
                        return false;
                    }
                    PlayerProfile playerProfile = Bukkit.createProfile((UUID)UUID.randomUUID());
                    playerProfile.setProperty(new ProfileProperty("textures", string2));
                    skull.setPlayerProfile(playerProfile);
                    skull.update(true);
                    return true;
                }
                return false;
            }
            case "banner": {
                if (blockState instanceof Banner) {
                    Banner banner = (Banner)blockState;
                    List list = this.tag.getListTag("Patterns").getValue();
                    if (list == null || list.isEmpty()) {
                        return false;
                    }
                    banner.setPatterns(list.stream().map(tag -> (CompoundTag)tag).map(compoundTag -> {
                        DyeColor dyeColor = DyeColor.getByWoolData((byte)((byte)compoundTag.getInt("Color")));
                        PatternType patternType = PatternType.getByIdentifier((String)compoundTag.getString("Pattern"));
                        if (dyeColor == null || patternType == null) {
                            return null;
                        }
                        return new Pattern(dyeColor, patternType);
                    }).filter(Objects::nonNull).toList());
                    banner.update(true);
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    public String getId() {
        String string = this.tag.getString("id").toLowerCase();
        if (string.startsWith("minecraft:")) {
            string = string.replace("minecraft:", "");
        }
        return string;
    }

    public List<CompoundTag> serializeInventory(ItemStack[] itemStackArray) {
        ArrayList<CompoundTag> arrayList = new ArrayList<CompoundTag>();
        for (int i = 0; i < itemStackArray.length; ++i) {
            if (itemStackArray[i] == null) continue;
            Map<String, Tag> map = this.serializeItem(itemStackArray[i]);
            map.put("Slot", (Tag)new ByteTag((byte)i));
            arrayList.add(new CompoundTag(map));
        }
        return arrayList;
    }

    public Map<String, Tag> serializeItem(ItemStack itemStack) {
        HashMap<String, Tag> hashMap = new HashMap<String, Tag>();
        hashMap.put("id", (Tag)new StringTag(itemStack.getType().name()));
        hashMap.put("Damage", (Tag)new ShortTag(itemStack.getDurability()));
        hashMap.put("Count", (Tag)new ByteTag((byte)itemStack.getAmount()));
        if (!itemStack.getEnchantments().isEmpty()) {
            ArrayList<CompoundTag> arrayList = new ArrayList<CompoundTag>();
            for (Map.Entry entry : itemStack.getEnchantments().entrySet()) {
                HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
                hashMap2.put("id", new StringTag(((Enchantment)entry.getKey()).toString()));
                hashMap2.put("lvl", new ShortTag(((Integer)entry.getValue()).shortValue()));
                arrayList.add(new CompoundTag(hashMap2));
            }
            HashMap hashMap3 = new HashMap();
            hashMap3.put("ench", new ListTag(CompoundTag.class, arrayList));
            hashMap.put("tag", (Tag)new CompoundTag((Map)hashMap3));
        }
        return hashMap;
    }
}

