/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.bukkit.serverlib;

import com.plotsquared.bukkit.serverlib.Check;
import com.plotsquared.bukkit.serverlib.forks.Akarin;
import com.plotsquared.bukkit.serverlib.forks.KibblePatcher;
import com.plotsquared.bukkit.serverlib.forks.Sugarcane;
import com.plotsquared.bukkit.serverlib.forks.Yatopia;
import com.plotsquared.bukkit.serverlib.hybrids.Fabric;
import com.plotsquared.bukkit.serverlib.hybrids.Forge;
import com.plotsquared.bukkit.serverlib.util.JavaVersionCheck;
import java.util.ArrayList;
import java.util.Collection;

public final class ServerLib {
    private final Collection<Check> checks;

    private ServerLib(Collection<Check> collection) {
        this.checks = collection;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static void checkUnsafeForks() {
        ServerLib serverLib = ServerLib.builder().withCheck(new Akarin()).withCheck(new KibblePatcher()).withCheck(new Yatopia()).withCheck(new Sugarcane()).withCheck(new Fabric()).withCheck(new Forge()).build();
        serverLib.runChecks();
    }

    @Deprecated
    public static void checkJavaLTS() {
        JavaVersionCheck.checkJavaSixteen();
    }

    public static void isJavaSixteen() {
        JavaVersionCheck.checkJavaSixteen();
    }

    @Deprecated
    public static void checkJavaMinor() {
        JavaVersionCheck.checkJavaFifteen();
    }

    public static void isJavaFifteen() {
        JavaVersionCheck.checkJavaFifteen();
    }

    public void runChecks() {
        for (Check check : this.checks) {
            if (!check.shouldFlag()) continue;
            check.printExplanation();
        }
    }

    public static final class Builder {
        private final Collection<Check> checks = new ArrayList<Check>();

        private Builder(Collection<Check> collection) {
            this.checks.addAll(collection);
        }

        private Builder() {
        }

        public Builder withCheck(Check check) {
            ArrayList<Check> arrayList = new ArrayList<Check>(this.checks);
            arrayList.add(check);
            return new Builder(arrayList);
        }

        public ServerLib build() {
            return new ServerLib(this.checks);
        }
    }
}

